/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DownloadPane
extends OptionsSettingsPane {
    private static final String SIMULTANEOUS_DOWNLOADS_KEY = "SimultaneousDownloads";
    private static final String DOWNLOADS_PER_HOST_KEY = "DownloadsPerHost";
    private IntegerTextField simultaneousDonwnloadsTF;
    private IntegerTextField donwnloadsPerHostTF;
    private JCheckBox removeCompletedDownloadsChkbx;

    public DownloadPane() {
        super("Download");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("GeneralDownloadSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(SIMULTANEOUS_DOWNLOADS_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.simultaneousDonwnloadsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxDownload), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.simultaneousDonwnloadsTF, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(DOWNLOADS_PER_HOST_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.donwnloadsPerHostTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxDownloadPerIP), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.donwnloadsPerHostTF, gridBagConstraints);
        this.removeCompletedDownloadsChkbx = new JCheckBox(Localizer.getString("AutoRemoveCompletedDownloads"), ServiceManager.sCfg.mDownloadAutoRemoveCompleted);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.removeCompletedDownloadsChkbx, gridBagConstraints);
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.simultaneousDonwnloadsTF.getText();
            n = new Integer(string);
            hashMap.put(SIMULTANEOUS_DOWNLOADS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.simultaneousDonwnloadsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.donwnloadsPerHostTF.getText();
            n = new Integer(string);
            hashMap.put(DOWNLOADS_PER_HOST_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.donwnloadsPerHostTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        Integer n;
        int n2;
        Integer n3 = (Integer)hashMap.get(SIMULTANEOUS_DOWNLOADS_KEY);
        int n4 = n3;
        if (ServiceManager.sCfg.mMaxDownload != n4) {
            ServiceManager.sCfg.mMaxDownload = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mMaxDownloadPerIP != (n2 = (n = (Integer)hashMap.get(DOWNLOADS_PER_HOST_KEY)).intValue())) {
            ServiceManager.sCfg.mMaxDownloadPerIP = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted != (bl = this.removeCompletedDownloadsChkbx.isSelected())) {
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }
}

