/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import phex.ServiceManager;
import phex.gui.dialogs.options.BandwidthPane;
import phex.gui.dialogs.options.DirectoriesPane;
import phex.gui.dialogs.options.DownloadPane;
import phex.gui.dialogs.options.GeneralTextPane;
import phex.gui.dialogs.options.GeneralUIPane;
import phex.gui.dialogs.options.MainTextPane;
import phex.gui.dialogs.options.NetworkPane;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.dialogs.options.OptionsTreeCellRenderer;
import phex.gui.dialogs.options.SharingPane;
import phex.utils.Localizer;

public class OptionsDialog
extends JDialog {
    private JPanel optionViewPane;
    private JTree optionTree;
    private OptionsSettingsPane[] settingsPanes = null;
    private HashMap inputDictionary = new HashMap();

    public OptionsDialog() {
        super(ServiceManager.getManager().getMainFrame(), Localizer.getString("PhexOptions"), false);
        this.settingsPanes = new OptionsSettingsPane[9];
        this.prepareComponent();
    }

    public void setOptionView(OptionsSettingsPane optionsSettingsPane) {
        optionsSettingsPane.prepareForDisplay();
        this.optionViewPane.removeAll();
        this.optionViewPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.optionViewPane.add((Component)optionsSettingsPane, gridBagConstraints);
        this.optionViewPane.revalidate();
        this.optionViewPane.repaint();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
            dimension2.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            ((Component)this).setSize(dimension2);
            this.doLayout();
        }
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OptionsDialog.this.closeDialog();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        SpecialLAFPanel specialLAFPanel = new SpecialLAFPanel();
        specialLAFPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)specialLAFPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        specialLAFPanel.add((Component)jPanel, gridBagConstraints);
        this.optionTree = new JTree(this.createOptionTreeModel());
        this.optionTree.setCellRenderer(new OptionsTreeCellRenderer());
        this.optionTree.setRootVisible(false);
        this.optionTree.expandRow(2);
        this.optionTree.expandRow(1);
        this.optionTree.expandRow(0);
        this.optionTree.getSelectionModel().setSelectionMode(1);
        this.optionTree.putClientProperty("JTree.lineStyle", "Angled");
        this.optionTree.addTreeSelectionListener(new OptionSelectionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.optionTree);
        jPanel.add((Component)this.optionTree, gridBagConstraints);
        this.optionViewPane = new JPanel();
        this.optionViewPane.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        specialLAFPanel.add((Component)this.optionViewPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        specialLAFPanel.add((Component)jPanel2, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jSeparator, gridBagConstraints);
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.isAllInputValid()) {
                    OptionsDialog.this.saveAndApplyAllChanges();
                    OptionsDialog.this.closeDialog();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        jPanel2.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(Localizer.getString("Apply"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.isAllInputValid()) {
                    OptionsDialog.this.saveAndApplyAllChanges();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        jPanel2.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton(Localizer.getString("Cancel"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.closeDialog();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        jPanel2.add((Component)jButton3, gridBagConstraints);
        this.optionTree.setSelectionRow(0);
        this.pack();
        specialLAFPanel.setMinimumSize(specialLAFPanel.getPreferredSize());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(ServiceManager.getManager().getMainFrame());
    }

    private boolean isAllInputValid() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.optionTree.getModel().getRoot();
        for (int i = 0; i < this.settingsPanes.length; ++i) {
            if (!this.settingsPanes[i].isSettingsPaneDisplayed()) continue;
            this.settingsPanes[i].checkInput(this.inputDictionary);
            if (this.settingsPanes[i].isInputValid(this.inputDictionary)) continue;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof OptionsSettingsPane) || object != this.settingsPanes[i]) continue;
                this.optionTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                break;
            }
            this.setOptionView(this.settingsPanes[i]);
            this.settingsPanes[i].displayErrorMessage(this.inputDictionary);
            return false;
        }
        return true;
    }

    private void saveAndApplyAllChanges() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.optionTree.getModel().getRoot();
        for (int i = 0; i < this.settingsPanes.length; ++i) {
            if (!this.settingsPanes[i].isSettingsPaneDisplayed()) continue;
            this.settingsPanes[i].saveAndApplyChanges(this.inputDictionary);
        }
        if (OptionsSettingsPane.isSaveConfigTriggered(this.inputDictionary)) {
            ServiceManager.sCfg.save();
        }
        if (OptionsSettingsPane.isSharedFilesRescanTriggered(this.inputDictionary)) {
            ServiceManager.getShareManager().getFileAdministration().rescan();
        }
    }

    private void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private TreeModel createOptionTreeModel() {
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.settingsPanes[n] = new MainTextPane();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.settingsPanes[++n] = new NetworkPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new BandwidthPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new GeneralTextPane("DownloadSharingSettings", "DownloadSharingSettingsText", "DownloadSharingSettings");
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.settingsPanes[++n] = new DownloadPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new SharingPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new DirectoriesPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new GeneralTextPane("UserInterface", "UserInterfaceText", "UserInterface");
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.settingsPanes[++n] = new GeneralUIPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    class SpecialLAFPanel
    extends JPanel {
        private boolean inited = true;

        public void updateUI() {
            if (this.inited && OptionsDialog.this.settingsPanes != null) {
                for (int i = 0; i < OptionsDialog.this.settingsPanes.length; ++i) {
                    if (OptionsDialog.this.settingsPanes[i] == null || !OptionsDialog.this.settingsPanes[i].isSettingsPaneDisplayed()) continue;
                    SwingUtilities.updateComponentTreeUI(OptionsDialog.this.settingsPanes[i]);
                }
            }
            super.updateUI();
        }
    }

    class OptionSelectionListener
    implements TreeSelectionListener {
        OptionSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof OptionsSettingsPane) {
                OptionsDialog.this.setOptionView((OptionsSettingsPane)object);
            }
        }
    }
}

