/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.AbstractListModel;
import javax.swing.event.ListDataEvent;
import phex.ServiceManager;
import phex.event.CaughtHostsChangeListener;
import phex.gui.common.LazyEventQueue;
import phex.host.HostManager;

public class CaughtHostsListModel
extends AbstractListModel {
    private HostManager hostMgr = ServiceManager.getHostManager();

    public CaughtHostsListModel() {
        this.hostMgr.addCaughtHostsChangeListener(new CaughtHostsListener());
    }

    public int getSize() {
        return this.hostMgr.getCaughtHostCount();
    }

    public Object getElementAt(int n) {
        String string = this.hostMgr.getCaughtHostAt(n);
        if (string == null) {
            this.fireIntervalRemoved(this, n, n);
            string = "";
        }
        return string;
    }

    private class CaughtHostsListener
    implements CaughtHostsChangeListener {
        private LazyEventQueue lazyEventQueue = ServiceManager.getLazyEventQueue();

        public void caughtHostAdded(int n) {
            this.lazyEventQueue.addListDataEvent(new ListDataEvent(CaughtHostsListModel.this, 1, n, n));
        }

        public void caughtHostRemoved(int n) {
            CaughtHostsListModel.this.fireIntervalRemoved(CaughtHostsListModel.this, n, n);
        }

        public void autoConnectHostAdded(int n) {
        }

        public void autoConnectHostRemoved(int n) {
        }
    }
}

