/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.table.AbstractTableModel;
import phex.ServiceManager;
import phex.event.NetworkHostsChangeListener;
import phex.host.Host;
import phex.host.HostManager;
import phex.utils.StrUtil;

public class NetworkTableModel
extends AbstractTableModel {
    private HostManager hostMgr = ServiceManager.getHostManager();
    private static final int numColRemoteHost = 0;
    private static final int numColType = 1;
    private static final int numColReceivedDropped = 2;
    private static final int numColSentQueued = 3;
    private static final int numColPingLatency = 4;
    private static final int numColShared = 5;
    private static final int numColUptime = 6;
    private static final int numColStatus = 7;
    private static String[] tableColumns = new String[]{"Remote Host", "Type", "Received (Dropped)", "Sent (Queued)", "Ping Latency (ms)", "Shared", "Uptime", "Status"};
    static Class class$java$lang$String;

    public NetworkTableModel() {
        this.hostMgr.addNetworkHostsChangeListener(new NetworkHostsListener());
    }

    public String getColumnName(int n) {
        return tableColumns[n];
    }

    public int getColumnCount() {
        return tableColumns.length;
    }

    public int getRowCount() {
        return this.hostMgr.getNetworkHostCount();
    }

    public Object getValueAt(int n, int n2) {
        Host host = this.hostMgr.getNetworkHostAt(n);
        if (host == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(host.getHostAddress().getHostName()))).append(":").append(host.getHostAddress().getPort())));
            }
            case 1: {
                return host.getTypeName();
            }
            case 2: {
                return String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(host.getReceivedCount()))).append(" (").append(String.valueOf(host.getDropCount())).append(")"))));
            }
            case 3: {
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(host.getSentCount())))).append(" (").append(String.valueOf(host.getSendQueueLength())).append(")")));
            }
            case 4: {
                if (host.getLatency() == 99999) {
                    return "Timeout";
                }
                return String.valueOf(host.getLatency());
            }
            case 5: {
                if (host.getFileCount() == 0) {
                    return "";
                }
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(host.getFileCount()))).append("/").append(StrUtil.formatSizeBytes((long)host.getTotalSize() * 1024L))));
            }
            case 6: {
                long l = host.getConnectionUpTime(System.currentTimeMillis()) / (long)1000;
                return StrUtil.formatSignificantElapsedTime(l);
            }
            case 7: {
                return host.getStatusName();
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Class getColumnClass(int n) {
        return class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NetworkHostsListener
    implements NetworkHostsChangeListener {
        private NetworkHostsListener() {
        }

        public void networkHostChanged(int n) {
            NetworkTableModel.this.fireTableRowsUpdated(n, n);
        }

        public void networkHostAdded(int n) {
            NetworkTableModel.this.fireTableRowsInserted(n, n);
        }

        public void networkHostRemoved(int n) {
            NetworkTableModel.this.fireTableRowsDeleted(n, n);
        }
    }
}

