/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import phex.ServiceManager;
import phex.event.SharedFilesChangeListener;
import phex.gui.common.LazyEventQueue;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.utils.Localizer;

public class SharedFilesTableModel
extends AbstractTableModel {
    private static final int colNumFile = 0;
    private static final int colNumDirectory = 1;
    private static final int colNumSize = 2;
    private static final int colNumSearchCount = 3;
    private static final int colNumUploadCount = 4;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Directory"), Localizer.getString("Size"), Localizer.getString("SearchCount"), Localizer.getString("UploadCount")};
    private FileAdministration sharedFileAdmin = ServiceManager.getShareManager().getFileAdministration();
    static Class class$java$lang$Integer;
    static Class class$java$lang$Long;
    static Class class$java$lang$String;

    public SharedFilesTableModel() {
        this.sharedFileAdmin.addSharedFilesChangeListener(new SharedFilesListener());
    }

    public String getColumnName(int n) {
        return tableColumns[n];
    }

    public int getColumnCount() {
        return tableColumns.length;
    }

    public int getRowCount() {
        return this.sharedFileAdmin.getFileCount();
    }

    public Object getValueAt(int n, int n2) {
        ShareFile shareFile = this.sharedFileAdmin.getFileAt(n);
        if (shareFile == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return shareFile.getEffectiveName();
            }
            case 1: {
                return shareFile.getFile().getParent();
            }
            case 2: {
                return shareFile.getFileSizeObject();
            }
            case 3: {
                return new Integer(shareFile.getSearchCount());
            }
            case 4: {
                return new Integer(shareFile.getUploadCount());
            }
        }
        return "";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 2: {
                return class$java$lang$Long == null ? (class$java$lang$Long = SharedFilesTableModel.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 3: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = SharedFilesTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = SharedFilesTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = SharedFilesTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SharedFilesListener
    implements SharedFilesChangeListener {
        private LazyEventQueue lazyEventQueue = ServiceManager.getLazyEventQueue();

        public void sharedFileChanged(int n) {
            SharedFilesTableModel.this.fireTableCellUpdated(n, n);
        }

        public void sharedFileAdded(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, n, n, -1, 1));
        }

        public void allSharedFilesChanged() {
            SharedFilesTableModel.this.fireTableDataChanged();
        }
    }
}

