/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import phex.MainFrame;
import phex.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.TextFieldFactory;
import phex.gui.models.AutoConnectHostsListModel;
import phex.gui.models.CaughtHostsListModel;
import phex.gui.models.NetworkTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.interfaces.IHostChanged;
import phex.msg.MsgManager;
import phex.utils.IPUtils;
import phex.utils.Localizer;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;
import phex.utils.TableSorter;

public class NetworkTab
extends JPanel
implements IHostChanged {
    private MainFrame mainFrame;
    private HostManager mHostMgr;
    private StatisticTracker statTracker;
    private MsgManager mMsgManager;
    private JTable mNetTable;
    private AbstractTableModel mNetModel;
    private TableSorter mNetSorter;
    private JLabel mConnectionLabel;
    private JTextField mConnectHostText;
    private JLabel mMyIP;
    private JCheckBox mAutoCleanupCheck;
    private JCheckBox mAutoConnectCheck;
    private JList mCatcherList;
    private JTextArea mStats;
    private JTextField newAutoConnectHostTF;
    private JButton addAutoConnectHostBtn;
    private JList autoConnectList;
    private JButton removeAutoConnectHostBtn;
    private JPopupMenu mHostPopupMenu;
    private JPopupMenu mCatcherPopupMenu;

    public NetworkTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.mHostMgr = ServiceManager.getHostManager();
        this.mMsgManager = ServiceManager.getMsgManager();
        this.statTracker = ServiceManager.getStatisticTracker();
        this.mHostPopupMenu = new JPopupMenu();
        this.mainFrame.populatePopupMenu(this.mHostPopupMenu, "HostTable.PopupMenu");
        this.mCatcherPopupMenu = new JPopupMenu();
        this.mainFrame.populatePopupMenu(this.mCatcherPopupMenu, "CatcherTable.PopupMenu");
    }

    public void initComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mNetModel = new NetworkTableModel();
        this.mNetSorter = new TableSorter(this.mNetModel);
        this.mNetTable = new JTable(this.mNetSorter);
        this.mNetTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.mNetTable.addMouseListener(new MouseHandler());
        this.mNetSorter.addMouseListenerToHeaderInTable(this.mNetTable);
        this.mConnectionLabel = new JLabel("Connections:");
        jPanel.add("North", this.mConnectionLabel);
        jPanel.add("Center", new JScrollPane(this.mNetTable));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.mConnectHostText = TextFieldFactory.newTextField("", 16);
        this.mConnectHostText.addKeyListener(new ConnectHostKeyHandler());
        this.mainFrame.addRefreshComponent("ActionNetworkLeave", this.mConnectHostText);
        JLabel jLabel = new JLabel("My Address:");
        this.mainFrame.addRefreshComponent("ActionNetworkLeave", jLabel);
        this.mMyIP = new JLabel(" ");
        this.mainFrame.addRefreshComponent("ActionNetworkLeave", this.mMyIP);
        JButton jButton = new JButton("Connect");
        jButton.setDefaultCapable(false);
        this.mainFrame.addRefreshComponent("ActionHostConnect", jButton);
        this.mAutoCleanupCheck = new JCheckBox("Auto Cleanup", ServiceManager.sCfg.mAutoCleanup);
        this.mainFrame.addRefreshComponent("ActionNetworkLeave", this.mAutoCleanupCheck);
        jPanel2.add(jLabel);
        jPanel2.add(this.mMyIP);
        jPanel2.add(new JLabel("        "));
        jPanel2.add(this.mConnectHostText);
        jPanel2.add(jButton);
        jPanel2.add(this.mAutoCleanupCheck);
        jButton.addActionListener(new ConnectHostHandler());
        this.mAutoCleanupCheck.addActionListener(new AutoCleanupHandler());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", jPanel);
        jPanel3.add("South", jPanel2);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3, 10, 0));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.mStats = new JTextArea();
        this.mStats.setEditable(false);
        this.mStats.setBorder(BorderFactory.createEtchedBorder());
        JButton jButton2 = new JButton("Reset");
        jButton2.setDefaultCapable(false);
        jButton2.addActionListener(new UpdateStatHandler());
        this.mainFrame.addRefreshComponent("ActionNetworkLeave", jButton2);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.add(jButton2);
        jPanel5.add("North", new JLabel("Statistics"));
        jPanel5.add("Center", new JScrollPane(this.mStats));
        jPanel5.add("South", jPanel6);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        this.mCatcherList = new JList(new CaughtHostsListModel());
        this.mCatcherList.setVisibleRowCount(4);
        this.mCatcherList.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.mCatcherList.addMouseListener(new MouseHandler());
        this.mAutoConnectCheck = new JCheckBox("Auto Connect", ServiceManager.sCfg.mAutoConnect);
        this.mAutoConnectCheck.addActionListener(new AutoConnectHandler());
        JButton jButton3 = new JButton("Connect");
        jButton3.setDefaultCapable(false);
        this.mainFrame.addRefreshComponent("ActionHostConnectFromCatcher", jButton3);
        JButton jButton4 = new JButton("Reset");
        jButton4.setDefaultCapable(false);
        JPanel jPanel8 = new JPanel(new FlowLayout());
        jPanel8.add(this.mAutoConnectCheck);
        jPanel8.add(jButton3);
        jPanel8.add(jButton4);
        jPanel7.add("North", new JLabel("Host Catcher"));
        jPanel7.add("Center", new JScrollPane(this.mCatcherList));
        jPanel7.add("South", jPanel8);
        jButton3.addActionListener(new ConnectCatcherHandler());
        jButton4.addActionListener(new ResetCatcherHandler());
        JPanel jPanel9 = new JPanel(new BorderLayout());
        JLabel jLabel2 = new JLabel(Localizer.getString("AutoConnectHosts"));
        jPanel9.add((Component)jLabel2, "North");
        JPanel jPanel10 = new JPanel(new GridBagLayout());
        this.newAutoConnectHostTF = new JTextField(15);
        this.newAutoConnectHostTF.setMinimumSize(this.newAutoConnectHostTF.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel10.add((Component)this.newAutoConnectHostTF, gridBagConstraints);
        this.addAutoConnectHostBtn = new JButton(Localizer.getString("Add"));
        this.addAutoConnectHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTab.this.performAddAutoConnectHostAction();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel10.add((Component)this.addAutoConnectHostBtn, gridBagConstraints);
        this.removeAutoConnectHostBtn = new JButton(Localizer.getString("Remove"));
        this.removeAutoConnectHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTab.this.performRemoveAutoConnectHostAction();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel10.add((Component)this.removeAutoConnectHostBtn, gridBagConstraints);
        this.autoConnectList = new JList(new AutoConnectHostsListModel());
        this.autoConnectList.setVisibleRowCount(3);
        this.autoConnectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    NetworkTab.this.autoConnectListValueChanged();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel10.add((Component)new JScrollPane(this.autoConnectList), gridBagConstraints);
        jPanel9.add((Component)jPanel10, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel10.add((Component)jPanel7, gridBagConstraints);
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel9);
        Dimension dimension = new Dimension(0, 0);
        jPanel3.setMinimumSize(dimension);
        jPanel4.setMinimumSize(dimension);
        jPanel3.setPreferredSize(new Dimension(780, 280));
        jPanel4.setPreferredSize(new Dimension(780, 150));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel3);
        jSplitPane.setBottomComponent(jPanel4);
        this.add("Center", jSplitPane);
        CellRenderer cellRenderer = new CellRenderer();
        this.mNetTable.getColumn(this.mNetModel.getColumnName(0)).setCellRenderer(cellRenderer);
        this.mNetTable.getColumn(this.mNetModel.getColumnName(1)).setCellRenderer(cellRenderer);
        this.mNetTable.getColumn(this.mNetModel.getColumnName(2)).setCellRenderer(cellRenderer);
        this.mNetTable.getColumn(this.mNetModel.getColumnName(3)).setCellRenderer(cellRenderer);
        this.mNetTable.getColumn(this.mNetModel.getColumnName(4)).setCellRenderer(cellRenderer);
        this.mNetTable.getColumn(this.mNetModel.getColumnName(5)).setCellRenderer(cellRenderer);
        this.mNetTable.getColumn(this.mNetModel.getColumnName(6)).setCellRenderer(cellRenderer);
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.mNetTable);
    }

    public void updateMyIP() {
        HostAddress hostAddress = ServiceManager.getListener().getLocalAddress();
        this.mMyIP.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(hostAddress.getHostName()))).append(":").append(hostAddress.getPort()))));
    }

    public void removeHost() {
        int n;
        int n2;
        int n3 = this.mNetTable.getSelectedRowCount();
        if (n3 <= 0 || n3 > this.mHostMgr.getNetworkHostCount()) {
            return;
        }
        int[] nArray = this.mNetTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            if (n >= this.mHostMgr.getNetworkHostCount()) {
                return;
            }
            nArray2[n2] = this.mNetSorter.indexes[n];
        }
        for (n2 = nArray2.length - 1; n2 > 0; --n2) {
            for (n = 0; n < n2; ++n) {
                if (nArray2[n] <= nArray2[n + 1]) continue;
                int n4 = nArray2[n];
                nArray2[n] = nArray2[n + 1];
                nArray2[n + 1] = n4;
            }
        }
        for (n2 = nArray2.length - 1; n2 >= 0; --n2) {
            Host host = this.mHostMgr.getNetworkHostAt(nArray2[n2]);
            this.mHostMgr.removeNetworkHost(host);
        }
        GUIUtils.fireTableChanged(this.mNetTable, this.mNetModel);
        this.mainFrame.refreshAllActions();
    }

    public boolean isConnectSelected() {
        String string = this.mConnectHostText.getText().trim();
        if (string.length() > 0) {
            return true;
        }
        return this.isConnectTableSelected();
    }

    public boolean isConnectTableSelected() {
        int n = this.mNetTable.getSelectedRowCount();
        return n > 0 && this.mHostMgr.getNetworkHostCount() > 0;
    }

    public void disconnectHost() {
        int[] nArray = this.mNetTable.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        Host[] hostArray = new Host[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            n2 = this.mNetSorter.indexes[n2];
            hostArray[i] = this.mHostMgr.getNetworkHostAt(n2);
        }
        this.mHostMgr.removeNetworkHosts(hostArray);
        GUIUtils.fireTableChanged(this.mNetTable, this.mNetModel);
        this.mainFrame.refreshAllActions();
    }

    public boolean isDisconnectSelected() {
        int n = this.mNetTable.getSelectedRowCount();
        return n > 0 && this.mHostMgr.getNetworkHostCount() > 0;
    }

    public void ignoreHost() {
        int[] nArray = this.mNetTable.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        Host[] hostArray = new Host[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            n2 = this.mNetSorter.indexes[n2];
            hostArray[i] = this.mHostMgr.getNetworkHostAt(n2);
            if (hostArray[i] == null) continue;
            String string = hostArray[i].getHostAddress().getHostName();
            ServiceManager.sCfg.mNetIgnoredHosts.addElement(IPUtils.splitIP2Parts(string));
        }
        this.mHostMgr.removeNetworkHosts(hostArray);
        ServiceManager.sCfg.save();
        GUIUtils.fireTableChanged(this.mNetTable, this.mNetModel);
        this.mainFrame.refreshAllActions();
    }

    public void invalidHost() {
        int[] nArray = this.mCatcherList.getSelectedIndices();
        if (nArray.length <= 0) {
            return;
        }
        String[] stringArray = this.mHostMgr.getCaughtHostsAt(nArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            ServiceManager.sCfg.mNetInvalidHosts.addElement(IPUtils.splitIP2Parts(string));
        }
        ServiceManager.sCfg.save();
        this.mainFrame.refreshAllActions();
    }

    public void refresh() {
        GUIUtils.fireTableChanged(this.mNetTable, this.mNetModel);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.statTracker.getStatHosts()).append(" hosts\n");
        int n = this.statTracker.getStatFiles();
        if (n == Integer.MAX_VALUE) {
            stringBuffer.append("> ");
        }
        stringBuffer.append(this.statTracker.getStatFiles()).append(" files\n");
        stringBuffer.append(this.statTracker.getStatSizeStr()).append("\n");
        stringBuffer.append(this.statTracker.getStatMsgCount()).append(" messages\n");
        stringBuffer.append(this.statTracker.getRate()).append(" bytes/second\n");
        stringBuffer.append(this.statTracker.getStatDropCount()).append(" dropped messages\n");
        float f2 = (float)this.statTracker.getStatTakenCount() / (float)(this.statTracker.getStatMsgCount() + 1);
        String string = String.valueOf(String.valueOf(String.valueOf(f2))).concat("00000");
        stringBuffer.append(string.substring(0, 5)).append(" average hops\n");
        stringBuffer.append(this.statTracker.getStatDownloadCount()).append(" downloads\n");
        stringBuffer.append(this.statTracker.getStatUploadCount()).append(" uploads\n");
        stringBuffer.append(StrUtil.formatSignificantElapsedTime(this.statTracker.getPhexUptimeInSeconds())).append(" Phex uptime\n");
        this.mStats.setText(stringBuffer.toString());
    }

    public boolean isConnectFromHostCatcherSelected() {
        boolean bl = this.mCatcherList.isSelectionEmpty();
        return !bl;
    }

    public void updateStat() {
        this.mMsgManager.resetMyMsgInit();
        this.mMsgManager.sendMsgToHosts(this.mMsgManager.getMyMsgInit());
        this.statTracker.resetStat();
    }

    public void connectHost() {
        String string = this.mConnectHostText.getText().trim();
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            this.mHostMgr.createOutgoingConnectionToHost(string2);
            GUIUtils.fireTableChanged(this.mNetTable, this.mNetModel);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf(58);
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1, string3.length());
                int n2 = Integer.parseInt(string5);
                HostAddress hostAddress = new HostAddress(string4, n2);
                this.mHostMgr.addCaughtHost(hostAddress, (short)0);
                bl = true;
            }
            if (bl) {
                this.mConnectHostText.setText("");
            }
        }
    }

    public void connectFromHostCatcher() {
        int[] nArray = this.mCatcherList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        String[] stringArray = this.mHostMgr.getCaughtHostsAt(nArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.mHostMgr.createOutgoingConnectionToHost(stringArray[i]);
            this.mHostMgr.removeCaughtHost(stringArray[i]);
        }
        GUIUtils.fireTableChanged(this.mNetTable, this.mNetModel);
    }

    private void toggleAutoConnect() {
        ServiceManager.sCfg.mAutoConnect = this.mAutoConnectCheck.isSelected();
        ServiceManager.sCfg.save();
    }

    private void toggleAutoCleanup() {
        ServiceManager.sCfg.mAutoCleanup = this.mAutoCleanupCheck.isSelected();
        ServiceManager.sCfg.save();
    }

    private void performAddAutoConnectHostAction() {
        String string = this.newAutoConnectHostTF.getText();
        if ((string = string.trim()).length() > 0) {
            this.mHostMgr.getCaughtHostsContainer().addAutoConnectHost(string);
        }
        this.newAutoConnectHostTF.setText("");
    }

    private void performRemoveAutoConnectHostAction() {
        String string = this.newAutoConnectHostTF.getText();
        if ((string = string.trim()).length() > 0) {
            this.mHostMgr.getCaughtHostsContainer().removeAutoConnectHost(string);
        }
        this.newAutoConnectHostTF.setText("");
    }

    private void autoConnectListValueChanged() {
        String string = (String)this.autoConnectList.getSelectedValue();
        if (string != null) {
            this.newAutoConnectHostTF.setText(string);
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            NetworkTab.this.mainFrame.refreshAllActions();
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            block15: {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setForeground(Color.black);
                if (jTable != NetworkTab.this.mNetTable || n >= NetworkTab.this.mHostMgr.getNetworkHostCount()) return this;
                int n3 = ((NetworkTab)NetworkTab.this).mNetSorter.indexes[n];
                Host host = NetworkTab.this.mHostMgr.getNetworkHostAt(n3);
                if (host == null) {
                    return this;
                }
                switch (host.getStatus()) {
                    case 0: {
                        return this;
                    }
                    case 1: {
                        this.setForeground(Color.gray);
                        return this;
                    }
                    case 2: 
                    case 3: {
                        this.setForeground(Color.red);
                        return this;
                    }
                    case 4: {
                        this.setForeground(Color.blue);
                        switch (n2) {
                            case 2: {
                                if (!host.dropPacketsInRed()) return this;
                                this.setForeground(Color.red);
                                break block15;
                            }
                            case 3: {
                                if (!host.sendQueueInRed()) return this;
                                this.setForeground(Color.red);
                                break block15;
                            }
                            case 4: {
                                if (!host.latencyInRed()) return this;
                                this.setForeground(Color.red);
                            }
                        }
                    }
                }
            }
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == NetworkTab.this.mNetTable) {
                NetworkTab.this.mHostPopupMenu.show(component, n, n2);
            } else if (component == NetworkTab.this.mCatcherList) {
                NetworkTab.this.mCatcherPopupMenu.show(component, n, n2);
            }
        }
    }

    private class UpdateStatHandler
    implements ActionListener {
        private UpdateStatHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkTab.this.updateStat();
        }
    }

    private class ConnectHostKeyHandler
    implements KeyListener {
        private ConnectHostKeyHandler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && NetworkTab.this.mConnectHostText.getText().trim().length() > 0) {
                NetworkTab.this.connectHost();
            }
            NetworkTab.this.mainFrame.refreshAction("ActionHostConnect");
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    private class AutoCleanupHandler
    implements ActionListener {
        private AutoCleanupHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkTab.this.toggleAutoCleanup();
        }
    }

    private class ConnectHostHandler
    implements ActionListener {
        private ConnectHostHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkTab.this.connectHost();
        }
    }

    private class AutoConnectHandler
    implements ActionListener {
        private AutoConnectHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkTab.this.toggleAutoConnect();
        }
    }

    private class ResetCatcherHandler
    implements ActionListener {
        private ResetCatcherHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkTab.this.mHostMgr.resetCaughtHosts();
        }
    }

    private class ConnectCatcherHandler
    implements ActionListener {
        private ConnectCatcherHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkTab.this.connectFromHostCatcher();
        }
    }
}

