/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import phex.MainFrame;
import phex.ServiceManager;
import phex.config.Cfg;
import phex.dialogues.DlgAddAsCandidate;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.download.RemoteFile;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.SearchComboBoxModel;
import phex.gui.models.SearchTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.gui.renderer.SearchListRenderer;
import phex.interfaces.IFind;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.utils.IPUtils;
import phex.utils.Localizer;
import phex.utils.TableSorter;
import phex.utils.URLUtil;

public class SearchTab
extends JPanel
implements IFind {
    private DownloadManager mDownloadMgr = ServiceManager.getDownloadManager();
    private SearchContainer searchContainer;
    private boolean mSearchTextTyped = true;
    private MainFrame mainFrame;
    private JLabel mSearchResultLabel;
    private JTextField mSearchText;
    private JTextField mMaxSearch;
    private JTextField mMinSpeed;
    private JTextField mMinimumSizeFilterText;
    private JTextField mMaximumSizeFilterText;
    private JTextField mSearchFilterText;
    private JButton mSearchStopButton;
    private JButton removeSearchBtn;
    private JButton mSearchButton;
    private JComboBox mSearchResultCombo;
    private JCheckBox mApplyFilterCheck;
    private SearchComboBoxModel mSearchResultModel;
    private JTable mSearchTable;
    private AbstractTableModel mSearchModel;
    private TableSorter mSearchSorter;
    private JPopupMenu mSearchResultPopupMenu;

    public SearchTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.searchContainer = ServiceManager.getQueryManager().getSearchContainer();
        this.mSearchResultPopupMenu = new JPopupMenu();
        this.mainFrame.populatePopupMenu(this.mSearchResultPopupMenu, "SearchResultTable.PopupMenu");
    }

    public void findInResult(boolean bl, boolean bl2, String string) {
        int n;
        int n2 = this.mSearchTable.getSelectedRowCount();
        if (n2 <= 0) {
            n = -1;
        } else {
            int[] nArray = this.mSearchTable.getSelectedRows();
            n = nArray[0];
        }
        n = bl2 ? ++n : --n;
        if (!bl) {
            string = string.toLowerCase();
        }
        int n3 = n;
        n2 = this.mSearchSorter.getRowCount();
        int n4 = this.mSearchSorter.getColumnCount();
        while (!(bl2 ? n3 >= n2 : n3 < 0)) {
            for (int i = 0; i < n4; ++i) {
                int n5;
                Object object = this.mSearchSorter.getValueAt(n3, i);
                if (object == null || (n5 = bl ? object.toString().indexOf(string) : object.toString().toLowerCase().indexOf(string)) == -1) continue;
                this.mSearchTable.clearSelection();
                this.mSearchTable.addRowSelectionInterval(n3, n3);
                this.mSearchTable.scrollRectToVisible(this.mSearchTable.getCellRect(n3, 0, true));
                return;
            }
            if (bl2) {
                ++n3;
                continue;
            }
            --n3;
        }
        JOptionPane.showMessageDialog(this, "No more result found.", "Find", 0);
    }

    public void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.mSearchText = new JTextField(ServiceManager.sCfg.mSearchLastSearch, 40);
        this.mSearchText.addKeyListener(new SearchKeyHandler());
        GUIUtils.setToolTipText(this.mSearchText, Localizer.getString("TTTSearchText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)this.mSearchText, gridBagConstraints);
        this.mSearchButton = new JButton(Localizer.getString("Search"));
        this.mSearchButton.addActionListener(new SearchButtonHandler());
        GUIUtils.setToolTipText(this.mSearchButton, Localizer.getString("TTTSearch"));
        this.mainFrame.addRefreshComponent("ActionQuerySearch", this.mSearchButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)this.mSearchButton, gridBagConstraints);
        this.mApplyFilterCheck = new JCheckBox(Localizer.getString("HideFilteredHosts"), ServiceManager.sCfg.mApplyFilterdHosts);
        GUIUtils.setToolTipText(this.mApplyFilterCheck, Localizer.getString("TTTHideFilteredHosts"));
        this.mApplyFilterCheck.addActionListener(new ApplyFilterHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.mApplyFilterCheck, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("MaxSearchResults"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        String string = String.valueOf(ServiceManager.sCfg.mSearchMaxSearch);
        this.mMaxSearch = new IntegerTextField(string, 6, 6);
        this.mMaxSearch.addKeyListener(new SearchKeyHandler());
        GUIUtils.setToolTipText(this.mMaxSearch, Localizer.getString("TTTMaxSearchResults"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 10);
        jPanel2.add((Component)this.mMaxSearch, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("ResultFilter"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.mSearchFilterText = new JTextField(ServiceManager.sCfg.mSearchFilter, 16);
        this.mSearchFilterText.addKeyListener(new SearchKeyHandler());
        GUIUtils.setToolTipText(this.mSearchFilterText, Localizer.getString("TTTResultFilter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.mSearchFilterText, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("MinSpeed"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        String string2 = String.valueOf(ServiceManager.sCfg.mSearchMinSpeed);
        this.mMinSpeed = new IntegerTextField(string2, 8, 10);
        this.mMinSpeed.addKeyListener(new SearchKeyHandler());
        GUIUtils.setToolTipText(this.mMinSpeed, Localizer.getString("TTTMinSpeed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 10);
        jPanel2.add((Component)this.mMinSpeed, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("MinFileSize"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        String string3 = String.valueOf(ServiceManager.sCfg.mMinimumFileSize);
        this.mMinimumSizeFilterText = new IntegerTextField(string3, 10, 13);
        this.mMinimumSizeFilterText.addKeyListener(new SearchKeyHandler());
        GUIUtils.setToolTipText(this.mMinimumSizeFilterText, Localizer.getString("TTTMinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.mMinimumSizeFilterText, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.mSearchResultModel = new SearchComboBoxModel();
        this.mSearchResultModel.addListDataListener(new SearchUpdateChangeListener());
        this.mSearchResultCombo = new JComboBox(this.mSearchResultModel);
        this.mSearchResultCombo.setRenderer(new SearchListRenderer());
        this.mSearchResultCombo.setEditable(false);
        this.mSearchResultCombo.addActionListener(new SearchComboActionHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.mSearchResultCombo, gridBagConstraints);
        this.mSearchStopButton = new JButton("Stop");
        GUIUtils.setToolTipText(this.mSearchStopButton, "Stop the selected search.");
        this.mSearchStopButton.setEnabled(false);
        this.mSearchStopButton.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.mSearchStopButton, gridBagConstraints);
        this.removeSearchBtn = new JButton(Localizer.getString("Remove"));
        GUIUtils.setToolTipText(this.removeSearchBtn, Localizer.getString("RemoveSearchTTT"));
        this.removeSearchBtn.setEnabled(true);
        this.removeSearchBtn.addActionListener(new SearchButtonHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.removeSearchBtn, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.mSearchModel = new SearchTableModel(this.mainFrame);
        this.mSearchSorter = new TableSorter(this.mSearchModel);
        this.mSearchTable = new JTable(this.mSearchSorter);
        this.mSearchTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.mSearchTable);
        GUIUtils.setToolTipText(this.mSearchTable, "Search results.  Perform sorting by clicking on the column.");
        this.mSearchTable.addMouseListener(new MouseHandler());
        this.mSearchSorter.addMouseListenerToHeaderInTable(this.mSearchTable);
        this.mSearchResultLabel = new JLabel("Search Result:");
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(Localizer.getString("QuickDownload"));
        GUIUtils.setToolTipText(jButton, Localizer.getString("QuickDownloadTTT"));
        jButton.addActionListener(new QuickDownloadHandler());
        this.mainFrame.addRefreshComponent("ActionTransferDownload", jButton);
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(Localizer.getString("Download"));
        GUIUtils.setToolTipText(jButton2, Localizer.getString("DownloadTTT"));
        jButton2.addActionListener(new DownloadHandler());
        this.mainFrame.addRefreshComponent("ActionTransferDownload", jButton2);
        jPanel5.add(jButton2);
        JButton jButton3 = new JButton("Add As Candidate");
        GUIUtils.setToolTipText(jButton3, "Add the selected file as download candidate to existing download.");
        jButton3.addActionListener(new AddAsCandidateHandler());
        this.mainFrame.addRefreshComponent("ActionTransferAddAsCandidate", jButton3);
        jPanel5.add(jButton3);
        jPanel4.add("North", this.mSearchResultLabel);
        jPanel4.add("Center", new JScrollPane(this.mSearchTable));
        jPanel4.add("South", jPanel5);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel6.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel6.add((Component)jPanel4, gridBagConstraints);
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add("North", jPanel);
        jPanel7.add("Center", jPanel6);
        this.add("Center", jPanel7);
    }

    public Search getSelectedSearchResult() {
        int n = this.mSearchResultCombo.getSelectedIndex();
        if (n >= 0 && n < this.searchContainer.getSearchCount()) {
            return this.searchContainer.getSearchAt(n);
        }
        return null;
    }

    public void search() {
        int n;
        String string = this.mSearchText.getText().trim();
        String string2 = this.mMaxSearch.getText().trim();
        String string3 = this.mMinSpeed.getText().trim();
        String string4 = this.mMinimumSizeFilterText.getText().trim();
        String string5 = this.mSearchFilterText.getText().trim();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Maximum search results should be an integer.", "Invalid Maximum Results", 0);
            return;
        }
        int n2 = 0;
        try {
            if (string3.length() > 0) {
                n2 = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Minimum speed should be an integer.", "Invalid Minimum Speed", 0);
            return;
        }
        long l = 0L;
        try {
            if (string4.length() > 0) {
                l = Integer.parseInt(string4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Minimum size should be an integer.", "Invalid Minimum Size", 0);
            return;
        }
        ServiceManager.sCfg.mSearchLastSearch = string;
        ServiceManager.sCfg.mSearchMaxSearch = n;
        ServiceManager.sCfg.mSearchMinSpeed = n2;
        ServiceManager.sCfg.mMinimumFileSize = l;
        ServiceManager.sCfg.mSearchFilter = string5;
        ServiceManager.sCfg.save();
        if (string.length() == 0) {
            return;
        }
        if (string.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
            Object[] objectArray = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
            GUIUtils.showErrorMessage(Localizer.getFormatedString("MinSearchTerm", objectArray));
            this.mSearchText.requestFocus();
            return;
        }
        this.mSearchTextTyped = false;
        this.mainFrame.refreshAllActions();
        Search.FileSizeConstraints fileSizeConstraints = new Search.FileSizeConstraints(ServiceManager.sCfg.mMinimumFileSize, ServiceManager.sCfg.mMaximumFileSize);
        Search search = this.searchContainer.createSearch(string, n2, fileSizeConstraints);
    }

    public void stopSearch() {
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            search.stopSearching();
        }
    }

    private void removeSearch() {
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            this.searchContainer.removeSearch(search);
        }
    }

    void addAsCandidate() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return;
        }
        int n = this.mSearchTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mSearchTable.getSelectedRows();
        int n2 = nArray[0];
        n2 = this.mSearchSorter.indexes[n2];
        RemoteFile remoteFile = search.getQueryHit(n2);
        RemoteFile remoteFile2 = new RemoteFile(remoteFile);
        DlgAddAsCandidate dlgAddAsCandidate = new DlgAddAsCandidate(this.mainFrame, remoteFile2);
        ((Component)dlgAddAsCandidate).setVisible(true);
        if (dlgAddAsCandidate.getCancel()) {
            return;
        }
        DownloadFile downloadFile = dlgAddAsCandidate.getDownloadFile();
        if (downloadFile == null) {
            return;
        }
        downloadFile.addRemoteCandidate(remoteFile2);
        this.mainFrame.setSelectedTab(3);
        this.mainFrame.refreshAllActions();
    }

    public RemoteFile getSelectedRemoteFile() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return null;
        }
        if (this.mSearchTable.getSelectedRowCount() < 1) {
            return null;
        }
        int[] nArray = this.mSearchTable.getSelectedRows();
        int n = this.mSearchSorter.indexes[nArray[0]];
        RemoteFile remoteFile = search.getQueryHit(n);
        return remoteFile;
    }

    public void filterDownloadHost() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return;
        }
        int n = this.mSearchTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mSearchTable.getSelectedRows();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            n2 = this.mSearchSorter.indexes[n2];
            RemoteFile remoteFile = search.getQueryHit(n2);
            ServiceManager.sCfg.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(remoteFile.getRemoteHost()));
        }
        ServiceManager.sCfg.save();
    }

    public int getResultSelectedCount() {
        return this.mSearchTable.getSelectedRowCount();
    }

    public void copyURL() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return;
        }
        int n = this.mSearchTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this.mSearchTable.getSelectedRows();
        int n2 = this.mSearchSorter.indexes[nArray[0]];
        RemoteFile remoteFile = search.getQueryHit(n2);
        String string = URLUtil.encodeURL(remoteFile.getURL());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public void quickDownload() {
        Search search = this.getSelectedSearchResult();
        if (search == null) {
            return;
        }
        int n = this.mSearchTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mSearchTable.getSelectedRows();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            RemoteFile remoteFile = search.getQueryHit(n3 = this.mSearchSorter.indexes[n3]);
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            if (!this.mDownloadMgr.addFileToDownload(remoteFile2)) {
                String string = String.valueOf(String.valueOf(new StringBuffer("Another file with the same name '").append(remoteFile2.getFilename()).append("' is being downloading now.\n")));
                string = String.valueOf(String.valueOf(string)).concat("Please wait until the other file has completed its download.");
                JOptionPane.showMessageDialog(ServiceManager.getManager().getMainFrame(), string, "Duplicate File", 1);
                continue;
            }
            ++n2;
            remoteFile.setInDownloadQueue(true);
        }
        if (n2 > 0) {
            this.mainFrame.setSelectedTab(3);
        }
        this.mainFrame.refreshAllActions();
    }

    public boolean getSearchTextTyped() {
        return this.mSearchTextTyped;
    }

    private void updateSearchResultLabel() {
        Search search = this.getSelectedSearchResult();
        if (search != null) {
            this.updateSearchResultLabel(search);
            return;
        }
        this.mSearchStopButton.setEnabled(false);
        this.mainFrame.refreshAllActions();
        this.mSearchResultLabel.setText("Search Result:");
    }

    private void updateSearchResultLabel(Search search) {
        final Search search2 = search;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string;
                StringBuffer stringBuffer = new StringBuffer("Search Result:    ");
                stringBuffer.append(search2.getQueryHitCount());
                stringBuffer.append(" returned");
                if (search2.isSearching()) {
                    stringBuffer.append(", searching...");
                }
                if (!(string = stringBuffer.toString()).equals(SearchTab.this.mSearchResultLabel.getText())) {
                    SearchTab.this.mSearchStopButton.setEnabled(search2.isSearching());
                    SearchTab.this.mainFrame.refreshAllActions();
                    SearchTab.this.mSearchResultLabel.setText(string);
                }
            }
        });
    }

    private class SearchKeyHandler
    extends KeyAdapter {
        private SearchKeyHandler() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == SearchTab.this.mSearchText && keyEvent.getKeyCode() == 10) {
                if (SearchTab.this.mSearchTextTyped) {
                    SearchTab.this.search();
                }
            } else {
                SearchTab.this.mSearchTextTyped = true;
                SearchTab.this.mainFrame.refreshAllActions();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SearchTab.this.mSearchTable) {
                SearchTab.this.quickDownload();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SearchTab.this.mSearchTable) {
                SearchTab.this.mSearchResultPopupMenu.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SearchTab.this.mainFrame.refreshAllActions();
        }
    }

    private class SearchButtonHandler
    implements ActionListener {
        private SearchButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchTab.this.mSearchButton) {
                SearchTab.this.search();
            } else if (object == SearchTab.this.mSearchStopButton) {
                SearchTab.this.stopSearch();
            } else if (object == SearchTab.this.removeSearchBtn) {
                SearchTab.this.removeSearch();
            }
        }
    }

    private class AddAsCandidateHandler
    implements ActionListener {
        private AddAsCandidateHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.addAsCandidate();
        }
    }

    private class QuickDownloadHandler
    implements ActionListener {
        private QuickDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.quickDownload();
        }
    }

    private class DownloadHandler
    implements ActionListener {
        private DownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Search search = SearchTab.this.getSelectedSearchResult();
            if (search == null) {
                return;
            }
            int n = SearchTab.this.mSearchTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            n = ((SearchTab)SearchTab.this).mSearchSorter.indexes[n];
            RemoteFile remoteFile = search.getQueryHit(n);
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(remoteFile2);
            downloadConfigDialog.show();
        }
    }

    private class SearchComboActionHandler
    implements ActionListener {
        private SearchComboActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.updateSearchResultLabel();
            GUIUtils.fireTableChanged(SearchTab.this.mSearchTable, SearchTab.this.mSearchModel);
        }
    }

    private class ApplyFilterHandler
    implements ActionListener {
        private ApplyFilterHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServiceManager.sCfg.mApplyFilterdHosts = SearchTab.this.mApplyFilterCheck.isSelected();
            ServiceManager.sCfg.save();
        }
    }

    private class SearchUpdateChangeListener
    implements ListDataListener {
        private SearchUpdateChangeListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getType() == 0) {
                Search search = SearchTab.this.getSelectedSearchResult();
                if (search == null) {
                    return;
                }
                SearchTab.this.updateSearchResultLabel(search);
                GUIUtils.fireTableChanged(SearchTab.this.mSearchTable, SearchTab.this.mSearchModel);
            } else {
                SearchTab.this.updateSearchResultLabel();
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }
    }
}

