/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import phex.Debug;
import phex.FQueue;
import phex.ReadWorker;
import phex.SendManager;
import phex.ServiceManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.HostMsg;
import phex.msg.MsgInit;
import phex.msg.MsgInitResponse;

public class Host {
    private static final int STABLE_CONNECTION_TIME = 75000;
    public static final int sStatusNotConnected = 0;
    public static final int sStatusError = 1;
    public static final int sStatusConnecting = 2;
    public static final int sStatusAccepting = 3;
    public static final int sStatusConnected = 4;
    public static final int sStatusTimeout = 6;
    public static final int sTypeOutgoing = 1;
    public static final int sTypeIncoming = 2;
    public static final int sTypeDownload = 3;
    public static final int sTypePush = 4;
    public static final int sLatencyTimeout = 99999;
    private HostManager mManager = ServiceManager.getHostManager();
    private SendManager mSendManager = ServiceManager.getSendManager();
    private HostAddress hostAddress;
    private Socket mSock = null;
    private InputStream mIs = null;
    private OutputStream mOs = null;
    private int mStatus = 0;
    private String mLastStatusMsg = "";
    private long mStatusTime = 0L;
    private int mType = 1;
    private boolean mHasWorker = false;
    private boolean mSending = false;
    private int mReceivedCount;
    private int mSentCount;
    private int mDropCount;
    private FQueue mWaitingQueue;
    private MsgInit mPingMsg = null;
    private long mPingStartTime = 0L;
    private long mPingNextStartTime = -1L;
    private int mPingLatency = 0;
    private long mLatencyTimeOutStartTime = 0L;
    private long mConnectionStartTime = 0L;
    private int mFileCount = 0;
    private int mTotalSize = 0;
    private boolean isConnectionStable = false;

    public Host() {
    }

    public Host(HostAddress hostAddress) {
        this();
        this.hostAddress = hostAddress;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public Socket getSock() {
        return this.mSock;
    }

    public void setSock(Socket socket) {
        this.mSock = socket;
        this.mReceivedCount = 0;
        this.mSentCount = 0;
        this.mDropCount = 0;
    }

    public InputStream getIs() {
        return this.mIs;
    }

    public void setIs(InputStream inputStream) {
        this.mIs = inputStream;
    }

    public OutputStream getOs() {
        return this.mOs;
    }

    public void setOs(OutputStream outputStream) {
        this.mOs = outputStream;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public String getStatusName() {
        switch (this.mStatus) {
            case 0: {
                return "(Not connected)";
            }
            case 1: {
                return "Error.  ".concat(String.valueOf(String.valueOf(this.mLastStatusMsg)));
            }
            case 2: {
                return "Connecting...  ".concat(String.valueOf(String.valueOf(this.mLastStatusMsg)));
            }
            case 3: {
                return "Accepting...  ".concat(String.valueOf(String.valueOf(this.mLastStatusMsg)));
            }
            case 4: {
                if (this.sendQueueInRed() || this.latencyInRed()) {
                    return "Connected (deprecated, no broadcast forwarded)";
                }
                return "Connected";
            }
            case 6: {
                return "Timed out";
            }
        }
        return "Unknown";
    }

    public void setStatus(int n) {
        this.setStatus(n, null, System.currentTimeMillis());
    }

    public void setStatus(int n, long l) {
        this.setStatus(n, null, l);
    }

    public void setStatus(int n, String string) {
        this.setStatus(n, string, System.currentTimeMillis());
    }

    public void setStatus(int n, String string, long l) {
        if (this.mStatus == n) {
            return;
        }
        this.mStatus = n;
        this.mLastStatusMsg = string;
        this.mStatusTime = l;
        this.mManager.fireNetworkHostChanged(this);
    }

    public void checkForStableConnection(long l) {
        if (this.mStatus == 4 && this.getConnectionUpTime(l) > (long)75000) {
            this.isConnectionStable = true;
            this.mManager.fireNetworkHostChanged(this);
        }
    }

    public boolean isConnectionStable() {
        return this.isConnectionStable;
    }

    public long getConnectionUpTime(long l) {
        if (this.mStatus == 4) {
            return l - this.mStatusTime;
        }
        return 0L;
    }

    public void checkForConnectingTimeout(long l) {
        if (this.mStatus == 2 && this.mType == 1 && l - this.mConnectionStartTime > (long)ServiceManager.sCfg.mNetConnectionTimeout) {
            this.setStatus(6, l);
        }
    }

    public void markConnectionStartTime() {
        this.mConnectionStartTime = System.currentTimeMillis();
    }

    public boolean isErrorStatusExpired(long l) {
        return (this.mStatus == 1 || this.mStatus == 0 || this.mStatus == 6) && l - this.mStatusTime > (long)5000;
    }

    public int getType() {
        return this.mType;
    }

    public String getTypeName() {
        switch (this.mType) {
            case 1: {
                return "Outgoing";
            }
            case 2: {
                return "Incoming";
            }
            case 3: {
                return "Download";
            }
            case 4: {
                return "Push";
            }
        }
        return "Unknown";
    }

    public void setType(int n) {
        this.mType = n;
    }

    public void incReceivedCount() {
        ++this.mReceivedCount;
    }

    public int getReceivedCount() {
        return this.mReceivedCount;
    }

    public void incSentCount() {
        ++this.mSentCount;
    }

    public int getSentCount() {
        return this.mSentCount;
    }

    public void incDropCount() {
        ++this.mDropCount;
    }

    public int getDropCount() {
        return this.mDropCount;
    }

    public int getFileCount() {
        return this.mFileCount;
    }

    public int getTotalSize() {
        return this.mTotalSize;
    }

    public boolean tooManyDropPackets() {
        if (!ServiceManager.sCfg.mDisconnectApplyPolicy) {
            return false;
        }
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio;
    }

    public boolean dropPacketsInRed() {
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio * 3 / 4;
    }

    public void connectForReading() {
        if (this.getType() != 1) {
            return;
        }
        if (this.mSock != null) {
            return;
        }
        new ReadWorker(this, 0);
    }

    public boolean isConnected() {
        return this.mSock != null;
    }

    public void disconnect() {
        if (this.mSock != null && this.mStatus != 1) {
            this.setStatus(0);
        }
        if (this.mIs != null) {
            try {
                this.mIs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mIs = null;
        }
        if (this.mOs != null) {
            try {
                this.mOs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mOs = null;
        }
        if (this.mSock != null) {
            try {
                this.mSock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSock = null;
        }
    }

    public synchronized boolean acquireByWorker() {
        if (this.mHasWorker) {
            return false;
        }
        this.mHasWorker = true;
        return true;
    }

    public synchronized void releaseFromWorker() {
        this.mHasWorker = false;
    }

    public synchronized boolean acquireSendLockOrQueueMsg(HostMsg hostMsg) {
        if (this.mSending) {
            this.initWaitingQueue();
            if (hostMsg.getUrgent()) {
                this.mWaitingQueue.addToHead(hostMsg);
            } else {
                this.mWaitingQueue.add(hostMsg);
            }
            return false;
        }
        this.mSending = true;
        return true;
    }

    public synchronized void releaseSendLock() {
        this.initWaitingQueue();
        HostMsg hostMsg = (HostMsg)this.mWaitingQueue.remove();
        if (hostMsg != null) {
            this.mSendManager.queueMsgToSend(hostMsg);
        }
        this.mSending = false;
    }

    public int getSendQueueLength() {
        if (this.mWaitingQueue == null) {
            return 0;
        }
        return this.mWaitingQueue.getCount();
    }

    public boolean sendQueueTooLong() {
        if (!ServiceManager.sCfg.mDisconnectApplyPolicy) {
            return false;
        }
        if (this.mWaitingQueue == null) {
            return false;
        }
        return this.mWaitingQueue.getCount() >= ServiceManager.sCfg.mNetMaxSendQueue - 1;
    }

    public boolean sendQueueInRed() {
        if (this.mWaitingQueue == null) {
            return false;
        }
        return this.mWaitingQueue.getCount() >= ServiceManager.sCfg.mNetMaxSendQueue * 3 / 4;
    }

    public void pingHost() {
        if (this.mStatus != 4) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.mPingMsg != null) {
            if (l - this.mPingStartTime > (long)ServiceManager.sCfg.mPingTimeout) {
                this.mPingLatency = 99999;
                this.mPingMsg = null;
                this.mLatencyTimeOutStartTime = System.currentTimeMillis();
            }
            return;
        }
        if (l < this.mPingNextStartTime) {
            return;
        }
        this.mPingStartTime = l;
        this.mPingNextStartTime = l + (long)ServiceManager.sCfg.mPingFrequency;
        this.mPingMsg = new MsgInit();
        this.mPingMsg.getHeader().setTTL(1);
        this.mSendManager.queueMsgToSend(this, this.mPingMsg, true);
    }

    public boolean checkPingResponse(MsgInitResponse msgInitResponse) {
        if (this.mPingMsg != null && msgInitResponse.getHeader().getMsgID().equals(this.mPingMsg.getHeader().getMsgID())) {
            this.mPingMsg = null;
            this.mPingLatency = (int)(System.currentTimeMillis() - this.mPingStartTime);
            this.mFileCount = msgInitResponse.getFileCount();
            this.mTotalSize = msgInitResponse.getTotalSize();
            return true;
        }
        return false;
    }

    public int getLatency() {
        return this.mPingLatency;
    }

    public boolean tooMuchLatency(long l) {
        if (!ServiceManager.sCfg.mDisconnectApplyPolicy) {
            return false;
        }
        return this.mPingLatency == 99999 && l - this.mLatencyTimeOutStartTime > (long)ServiceManager.sCfg.mDisconnectLatency;
    }

    public boolean latencyInRed() {
        return this.mPingLatency == 99999;
    }

    public void log(String string) {
        if (Debug.DbgHost()) {
            Debug.msg(String.valueOf(String.valueOf(new StringBuffer("Host ").append(this.hostAddress.getHostName()).append(":").append(this.hostAddress.getPort()).append(": ").append(string))));
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.hostAddress.getHostName()))).append(":").append(this.hostAddress.getPort())));
    }

    private void initWaitingQueue() {
        if (this.mWaitingQueue != null) {
            return;
        }
        this.mWaitingQueue = new FQueue(ServiceManager.sCfg.mNetMaxSendQueue);
    }
}

