/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.net.InetAddress;
import java.net.UnknownHostException;
import phex.ServiceManager;
import phex.host.MalformedHostAddressException;
import phex.utils.IPUtils;

public class HostAddress {
    public static String LOCAL_HOST_NAME = "127.0.0.1";
    public static final int DEFAULT_PORT = 6346;
    private String hostName;
    private int port;
    private byte[] hostIP;

    public HostAddress(String string, int n) {
        this.hostName = string;
        this.port = n;
    }

    public HostAddress(byte[] byArray, int n) {
        this.hostIP = byArray;
        this.port = n;
        this.hostName = IPUtils.ip2string(byArray);
    }

    public HostAddress(String string) throws MalformedHostAddressException {
        int n = string.indexOf(58);
        if (n < 0 || n == string.length() - 1) {
            this.hostName = string;
            this.port = 6346;
            return;
        }
        if (n == 0) {
            throw new MalformedHostAddressException("No host name: ".concat(String.valueOf(String.valueOf(string))));
        }
        this.hostName = string.substring(0, n);
        String string2 = string.substring(n + 1);
        try {
            this.port = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedHostAddressException("Can't parse port: ".concat(String.valueOf(String.valueOf(string2))));
        }
    }

    public void updateAddress(String string, int n) {
        if (!string.equals(this.hostName)) {
            this.hostName = string;
            this.hostIP = null;
        }
        this.port = n;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getHostIP() throws UnknownHostException {
        this.initHostIP();
        return this.hostIP;
    }

    public boolean equals(HostAddress hostAddress) {
        return this.hostName.equals(hostAddress.hostName) && this.port == hostAddress.port;
    }

    public boolean isLocalHost() {
        HostAddress hostAddress = ServiceManager.getListener().getLocalAddress();
        boolean bl = this.port == hostAddress.getPort();
        try {
            this.initHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            boolean bl2 = false;
            return bl2;
        }
        if (this.hostIP[0] == 127) {
            return bl;
        }
        return hostAddress.equals(this);
    }

    private void initHostIP() throws UnknownHostException {
        if (this.hostIP == null) {
            this.hostIP = InetAddress.getByName(this.hostName).getAddress();
        }
    }
}

