/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import phex.ServiceManager;
import phex.event.NetworkHostsChangeListener;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;

public final class NetworkHostsContainer {
    private ArrayList networkHosts;
    private ArrayList connectedHosts;
    private ArrayList listenerList = new ArrayList(3);

    public NetworkHostsContainer() {
        this.networkHosts = new ArrayList();
        this.connectedHosts = new ArrayList();
    }

    public synchronized int getConnectedHostCount() {
        return this.connectedHosts.size();
    }

    public synchronized boolean hasIncommingSlotsAvailable() {
        return this.getConnectedHostCount() + 1 <= ServiceManager.sCfg.mNetMaxConnection;
    }

    public synchronized Host getConnectedHostAt(int n) {
        if (n >= this.connectedHosts.size()) {
            return null;
        }
        return (Host)this.connectedHosts.get(n);
    }

    public synchronized void cleanupConnectedHosts() {
        long l = System.currentTimeMillis();
        int n = this.connectedHosts.size();
        for (int i = 0; i < n; ++i) {
            Host host = (Host)this.connectedHosts.get(i);
            if (host.getStatus() == 1 || !host.tooManyDropPackets() && !host.tooMuchLatency(l) && !host.sendQueueTooLong()) continue;
            host.setStatus(1, "Apply disconnect policy.", l);
        }
    }

    public synchronized void addConnectedHost(Host host) {
        this.connectedHosts.add(host);
        ServiceManager.getHostManager().addCaughtHost(host.getHostAddress(), (short)1);
    }

    public synchronized void periodicallyCheckHosts() {
        Host host;
        long l = System.currentTimeMillis();
        Iterator iterator = ((AbstractList)this.networkHosts).iterator();
        while (iterator.hasNext()) {
            host = (Host)iterator.next();
            host.checkForConnectingTimeout(l);
        }
        iterator = ((AbstractList)this.connectedHosts).iterator();
        while (iterator.hasNext()) {
            host = (Host)iterator.next();
            host.checkForStableConnection(l);
        }
    }

    public synchronized Host getNetworkHostAt(int n) {
        if (n >= this.networkHosts.size()) {
            return null;
        }
        return (Host)this.networkHosts.get(n);
    }

    public synchronized int getNetworkHostCount() {
        return this.networkHosts.size();
    }

    public synchronized void addNetworkHost(Host host) {
        int n = this.networkHosts.size();
        this.networkHosts.add(n, host);
        this.fireNetworkHostAdded(n);
    }

    public synchronized void createOutgoingConnectionToHost(String string) {
        HostAddress hostAddress = null;
        try {
            hostAddress = new HostAddress(string);
        }
        catch (MalformedHostAddressException malformedHostAddressException) {
            return;
        }
        for (int i = 0; i < this.networkHosts.size(); ++i) {
            Host host = (Host)this.networkHosts.get(i);
            if (host.getType() != 1 || !host.getHostAddress().equals(hostAddress)) continue;
            return;
        }
        Host host = new Host(hostAddress);
        host.setType(1);
        this.addNetworkHost(host);
        host.connectForReading();
    }

    public synchronized void addIncomingHost(Host host) {
        this.addNetworkHost(host);
        this.connectedHosts.add(host);
    }

    public synchronized void cleanupNetworkHosts() {
        if (!ServiceManager.sCfg.mAutoCleanup) {
            return;
        }
        int n = this.networkHosts.size();
        Host[] hostArray = new Host[n];
        long l = System.currentTimeMillis();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Host host = (Host)this.networkHosts.get(i);
            int n3 = host.getStatus();
            if (n3 == 4 || n3 == 2 || n3 == 3 || !host.isErrorStatusExpired(l)) continue;
            hostArray[n2] = host;
            ++n2;
        }
        if (n2 > 0) {
            this.removeNetworkHosts(hostArray);
        }
    }

    public synchronized void removeAllNetworkHosts() {
        Iterator iterator = ((AbstractList)this.networkHosts).iterator();
        while (this.networkHosts.size() > 0) {
            Host host = (Host)this.networkHosts.get(0);
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHosts(Host[] hostArray) {
        int n = hostArray.length;
        for (int i = 0; i < n; ++i) {
            Host host = hostArray[i];
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHost(Host host) {
        this.internalRemoveNetworkHost(host);
    }

    private void internalRemoveNetworkHost(Host host) {
        int n;
        if (host == null) {
            return;
        }
        if (host.isConnected()) {
            ((AbstractCollection)this.connectedHosts).remove(host);
        }
        if ((n = this.networkHosts.indexOf(host)) >= 0) {
            this.networkHosts.remove(n);
            host.disconnect();
            this.fireNetworkHostRemoved(n);
        }
    }

    public void addNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.listenerList.add(networkHostsChangeListener);
    }

    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        ((AbstractCollection)this.listenerList).remove(networkHostsChangeListener);
    }

    private void fireNetworkHostChanged(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener networkHostsChangeListener = (NetworkHostsChangeListener)objectArray[i];
                    networkHostsChangeListener.networkHostChanged(n);
                }
            }
        });
    }

    private void fireNetworkHostAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener networkHostsChangeListener = (NetworkHostsChangeListener)objectArray[i];
                    networkHostsChangeListener.networkHostAdded(n);
                }
            }
        });
    }

    private void fireNetworkHostRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener networkHostsChangeListener = (NetworkHostsChangeListener)objectArray[i];
                    networkHostsChangeListener.networkHostRemoved(n);
                }
            }
        });
    }

    public void fireNetworkHostChanged(Host host) {
        int n = this.networkHosts.indexOf(host);
        if (n >= 0) {
            this.fireNetworkHostChanged(n);
        }
    }
}

