/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import phex.GUID;
import phex.ServiceManager;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.msg.MsgResRecord;
import phex.utils.IOUtil;

public class MsgQueryResponse
implements IMsg {
    private static final boolean INCLUDE_QHD = true;
    private static final short UNKNOWN_FLAG = -1;
    private static final short TRUE_FLAG = 1;
    private static final short FALSE_FLAG = 0;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private MsgHeader mHeader;
    private byte[] body;
    private short mRemoteListeningPort;
    private InetAddress mRemoteHost;
    private int mRemoteHostSpeed;
    private MsgResRecord[] mRecords;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isParsed;

    private MsgQueryResponse() {
        throw new UnsupportedOperationException();
    }

    public MsgQueryResponse(MsgHeader msgHeader, GUID gUID, InetAddress inetAddress, short s, int n, MsgResRecord[] msgResRecordArray) {
        this.setHeader(msgHeader);
        this.remoteClientID = gUID;
        this.mRemoteHost = inetAddress;
        this.mRemoteListeningPort = s;
        this.mRemoteHostSpeed = n;
        this.mRecords = msgResRecordArray;
        boolean bl = false;
        if (!ServiceManager.getListener().hasConnectedIncoming() || ServiceManager.sCfg.isBehindFirewall) {
            bl = true;
        }
        boolean bl2 = ServiceManager.getShareManager().isHostBusy();
        this.buildBody(bl, bl2);
        msgHeader.setDataLen(this.body.length);
        this.isParsed = true;
    }

    private void buildBody(boolean bl, boolean bl2) {
        int n;
        int n2 = this.calculateBodySize();
        this.body = new byte[n2];
        int n3 = this.mRecords.length;
        this.body[0] = (byte)n3;
        IOUtil.serializeShortLE(this.mRemoteListeningPort, this.body, 1);
        byte[] byArray = this.mRemoteHost.getAddress();
        this.body[3] = byArray[0];
        this.body[4] = byArray[1];
        this.body[5] = byArray[2];
        this.body[6] = byArray[3];
        IOUtil.serializeIntLE(this.mRemoteHostSpeed, this.body, 7);
        int n4 = 11;
        for (n = 0; n < n3; ++n) {
            n4 = this.mRecords[n].serialize(this.body, n4);
        }
        this.body[n4++] = 80;
        this.body[n4++] = 72;
        this.body[n4++] = 69;
        this.body[n4++] = 88;
        this.body[n4++] = 2;
        n = 0;
        if (bl) {
            n = 1;
        }
        int n5 = 0;
        if (bl2) {
            n5 = 4;
        }
        this.body[n4++] = (byte)(n | 4 | 0 | 0x10);
        this.body[n4++] = (byte)(1 | n5 | 0 | 0);
        n4 = this.remoteClientID.serialize(this.body, n4);
    }

    public MsgQueryResponse(MsgHeader msgHeader, byte[] byArray) {
        this.setHeader(msgHeader);
        this.body = byArray;
        msgHeader.setDataLen(this.body.length);
        this.isParsed = false;
    }

    private void setHeader(MsgHeader msgHeader) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(129);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public int getRecordCount() {
        this.parseBody();
        return this.mRecords.length;
    }

    public InetAddress getRemoteHost() {
        this.parseBody();
        return this.mRemoteHost;
    }

    public String getRemoteHostStr() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getRemoteHost().getHostAddress()))).append(":").append(this.mRemoteListeningPort)));
    }

    public int getRemoteHostSpeed() {
        this.parseBody();
        return this.mRemoteHostSpeed;
    }

    public GUID getRemoteClientID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public MsgResRecord getMsgRecord(int n) {
        this.parseBody();
        return this.mRecords[n];
    }

    public void computeHeaderLen() {
    }

    public int getSize() {
        return this.mHeader.getSize() + this.mHeader.getDataLen();
    }

    private int calculateBodySize() {
        int n = 11;
        n += this.getRecordLength();
        n = n + 4 + 1 + 2;
        return n += this.remoteClientID.getSize();
    }

    private int getRecordLength() {
        int n = 0;
        int n2 = this.mRecords.length;
        for (int i = 0; i < n2; ++i) {
            MsgResRecord msgResRecord = this.mRecords[i];
            n += msgResRecord.getSize();
        }
        return n;
    }

    public void copy(MsgQueryResponse msgQueryResponse) {
        this.mHeader.copy(msgQueryResponse.getHeader());
        this.mRemoteListeningPort = this.mRemoteListeningPort;
        this.mRemoteHost = this.mRemoteHost;
        this.mRemoteHostSpeed = this.mRemoteHostSpeed;
        this.remoteClientID = this.remoteClientID;
        int n = msgQueryResponse.mRecords.length;
        this.mRecords = new MsgResRecord[n];
        for (int i = 0; i < n; ++i) {
            MsgResRecord msgResRecord = new MsgResRecord();
            msgResRecord.copy(msgQueryResponse.mRecords[i]);
            this.mRecords[i] = msgResRecord;
        }
        this.body = msgQueryResponse.body;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.mHeader.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.body.length))).append("  ").append(n).append("  ").append(this.mHeader.getDataLen()).append("  ").append(this.calculateBodySize()).append("\n").append(new String(this.body)).append("\n").append(new String(byArray)).append("\n----"))));
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        return n;
    }

    private void parseBody() {
        int n;
        if (this.isParsed) {
            return;
        }
        int n2 = 0;
        int n3 = (n = this.body[n2++]) < 0 ? 256 + n : n;
        this.mRemoteListeningPort = IOUtil.deserializeShortLE(this.body, n2);
        n2 += 2;
        StringBuffer stringBuffer = new StringBuffer();
        n2 = IOUtil.deserializeIP(this.body, n2, stringBuffer);
        try {
            int n4;
            this.mRemoteHost = InetAddress.getByName(stringBuffer.toString());
            this.mRemoteHostSpeed = IOUtil.deserializeIntLE(this.body, n2);
            n2 += 4;
            this.mRecords = new MsgResRecord[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                MsgResRecord msgResRecord = new MsgResRecord();
                n2 = msgResRecord.deserialize(this.body, n2);
                this.mRecords[n4] = msgResRecord;
            }
            if (n2 <= this.mHeader.getDataLen() - 16 - 4 - 2) {
                this.vendorCode = new String(this.body, n2, 4, "ISO-8859-1");
                n4 = IOUtil.unsignedByte2int(this.body[n2 += 4]);
                ++n2;
                if (n4 > 1) {
                    byte by = this.body[n2];
                    byte by2 = this.body[n2 + 1];
                    if ((by2 & 1) != 0) {
                        this.pushNeededFlag = (by & 1) != 0 ? (short)1 : 0;
                    }
                    if ((by & 4) != 0) {
                        this.serverBusyFlag = (by2 & 4) != 0 ? (short)1 : 0;
                    }
                    if ((by & 8) != 0) {
                        this.hasUploadedFlag = (by2 & 8) != 0 ? (short)1 : 0;
                    }
                    if ((by & 0x10) != 0) {
                        this.uploadSpeedFlag = (by2 & 0x10) != 0 ? (short)1 : 0;
                    }
                }
                n2 += n4;
            }
            this.parseRemoteClientID();
            this.isParsed = true;
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.mHeader.getDataLen() - 16);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(new StringBuffer("[").append(this.mHeader).append(" ").append("NumRecords=").append(this.mRecords.length).append(", ").append("RemoteListeningPort=").append(this.mRemoteListeningPort).append(", ").append("RemoteHost=").append(this.mRemoteHost.getHostAddress()).append(", ").append("RemoteHostSpeed=").append(this.mRemoteHostSpeed).append(", ").append("RemoteClientID=").append(this.remoteClientID).append(", ").append("Records=")));
        for (int i = 0; i < this.mRecords.length; ++i) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.mRecords[i])).concat(" "))));
        }
        string = String.valueOf(String.valueOf(string)).concat("]");
        return string;
    }
}

