/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.FQueue;
import phex.ServiceManager;
import phex.config.Cfg;
import phex.event.QueryHistoryChangeListener;
import phex.msg.MsgQuery;

public class QueryHistoryMonitor {
    private Cfg configuration = ServiceManager.sCfg;
    private FQueue historyQueue;
    private QueryHistoryChangeListener changeListener;

    public QueryHistoryMonitor() {
        this.historyQueue = new FQueue(this.configuration.searchHistoryLength);
    }

    public void setHistoryMonitored(boolean bl) {
        this.configuration.monitorSearchHistory = bl;
        this.configuration.save();
    }

    public boolean isHistoryMonitored() {
        return this.configuration.monitorSearchHistory;
    }

    public synchronized void setMaxHistroySize(int n) {
        if (n == this.historyQueue.getMax()) {
            return;
        }
        this.historyQueue.resize(n);
        this.configuration.searchHistoryLength = n;
        this.configuration.save();
    }

    public synchronized int getMaxHistorySize() {
        return this.historyQueue.getMax();
    }

    public synchronized int getHistorySize() {
        return this.historyQueue.getCount();
    }

    public synchronized MsgQuery getSearchQueryAt(int n) {
        return (MsgQuery)this.historyQueue.getAt(n);
    }

    public synchronized void addSearchQuery(MsgQuery msgQuery) {
        if (this.configuration.monitorSearchHistory) {
            this.historyQueue.add(msgQuery);
            this.fireQueryHistoryChanged();
        }
    }

    public void setQueryHistoryChangeListener(QueryHistoryChangeListener queryHistoryChangeListener) {
        if (this.changeListener != null) {
            throw new RuntimeException("CaughtHostChangedListener already used!!");
        }
        this.changeListener = queryHistoryChangeListener;
    }

    private void fireQueryHistoryChanged() {
        this.changeListener.queryHistoryChanged();
    }
}

