/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import phex.ServiceManager;
import phex.config.Cfg;
import phex.event.SharedFilesChangeListener;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.ReadWriteLock;

public class FileAdministration {
    private static final String aliasFile = "filealias";
    private static final String aliasFilename = "filealias.txt";
    private ReadWriteLock rwLock;
    private ArrayList sharedDirectories;
    private ArrayList sharedFiles;
    private HashMap nameToFileMap;
    private ArrayList fileExclusionList;
    private ArrayList fileInclusionList;
    private int totalFileSizeKb;
    private ShareManager shareManager;
    private Thread rescanThread;
    private ArrayList listenerList = new ArrayList(2);

    public FileAdministration(ShareManager shareManager) {
        this.rwLock = new ReadWriteLock();
        this.shareManager = shareManager;
        this.sharedDirectories = new ArrayList(1);
        this.sharedFiles = new ArrayList();
        this.fileExclusionList = new ArrayList();
        this.fileInclusionList = new ArrayList();
        this.nameToFileMap = new HashMap();
        this.totalFileSizeKb = 0;
    }

    /*
     * Loose catch block
     */
    public ShareFile getFileAt(int n) {
        ShareFile shareFile;
        this.rwLock.readLock();
        if (n < this.sharedFiles.size()) break block6;
        ShareFile shareFile2 = null;
        Object var4_4 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        {
            block6: {
                return shareFile2;
            }
            shareFile = (ShareFile)this.sharedFiles.get(n);
        }
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
    }

    public ShareFile[] getSharedFiles() {
        ShareFile[] shareFileArray;
        this.rwLock.readLock();
        try {
            ShareFile[] shareFileArray2 = new ShareFile[this.sharedFiles.size()];
            shareFileArray = shareFileArray2 = this.sharedFiles.toArray(shareFileArray2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFileArray;
    }

    public Object[] getSharedDirectories() {
        Object[] objectArray;
        this.rwLock.readLock();
        try {
            objectArray = this.sharedDirectories.toArray();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return objectArray;
    }

    public int getFileCount() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.sharedFiles.size();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return n;
    }

    public ShareFile getFileByName(String string) {
        ShareFile shareFile;
        this.rwLock.readLock();
        try {
            shareFile = (ShareFile)this.nameToFileMap.get(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
    }

    /*
     * Loose catch block
     */
    public ShareFile getFileByIndex(int n) throws IndexOutOfBoundsException {
        ShareFile shareFile;
        this.rwLock.readLock();
        if (n < this.sharedFiles.size()) break block6;
        ShareFile shareFile2 = null;
        Object var4_4 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        {
            block6: {
                return shareFile2;
            }
            shareFile = (ShareFile)this.sharedFiles.get(n);
        }
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return shareFile;
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
    }

    public int getTotalFileSizeInKb() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.totalFileSizeKb;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return n;
    }

    public void rescan() {
        if (this.rescanThread == null || !this.rescanThread.isAlive()) {
            FileRescanRunner fileRescanRunner = new FileRescanRunner();
            this.rescanThread = new Thread(fileRescanRunner);
            this.rescanThread.setDaemon(true);
            this.rescanThread.setPriority(1);
            this.rescanThread.start();
        }
    }

    /*
     * Loose catch block
     */
    public boolean isFileInvalid(File file) {
        block12: {
            block10: {
                boolean bl;
                if (file.getName().toLowerCase().endsWith(".dl")) {
                    return true;
                }
                if (file.getName().equals("files.idx")) {
                    return true;
                }
                if (file.getName().equals(aliasFilename)) {
                    return true;
                }
                this.rwLock.readLock();
                if (this.isIncluded(file)) break block11;
                boolean bl2 = true;
                Object var4_4 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                {
                    block11: {
                        return bl2;
                    }
                    if (!this.isExcluded(file)) break block10;
                    bl = true;
                }
                Object var4_5 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                return bl;
            }
            Object var4_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            break block12;
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                throw throwable;
            }
        }
        return false;
    }

    private void setInclusions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.fileInclusionList.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.fileInclusionList.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    private boolean isIncluded(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        for (int i = 0; i < this.fileInclusionList.size(); ++i) {
            String string2 = (String)this.fileInclusionList.get(i);
            if (string2.equals("*")) {
                return true;
            }
            if (string2.equals("*.*")) {
                return true;
            }
            if (string2.startsWith("*")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    private void setExclusions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.fileExclusionList.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.fileExclusionList.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    private boolean isExcluded(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = file.getName().toLowerCase();
        if (string.indexOf(aliasFile) != -1) {
            return true;
        }
        for (int i = 0; i < this.fileExclusionList.size(); ++i) {
            String string2 = (String)this.fileExclusionList.get(i);
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    private void scanDir(File file, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("'").append(file).append("' is not a directory."))));
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.isFileInvalid(fileArray[i])) continue;
            if (fileArray[i].isFile()) {
                this.handleScannedFile(fileArray[i]);
                continue;
            }
            if (!fileArray[i].isDirectory() || !bl) continue;
            this.scanDir(fileArray[i], bl);
        }
    }

    private void handleScannedFile(File file) {
        ShareFile shareFile = new ShareFile(file);
        this.rwLock.writeLock();
        try {
            int n = this.sharedFiles.size();
            shareFile.setFileIndex(n);
            this.sharedFiles.add(n, shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / (long)1024);
            this.fireSharedFileAdded(n);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void setSharedDirectories(String string) {
        this.rwLock.writeLock();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n = stringTokenizer.countTokens();
            this.sharedDirectories.clear();
            this.sharedDirectories.ensureCapacity(n);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.sharedDirectories.add(string2);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void addSharedFilesChangeListener(SharedFilesChangeListener sharedFilesChangeListener) {
        this.listenerList.add(sharedFilesChangeListener);
    }

    public void removeSharedFilesChangeListener(SharedFilesChangeListener sharedFilesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(sharedFilesChangeListener);
    }

    private void fireSharedFileChanged(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[i];
                    sharedFilesChangeListener.sharedFileChanged(n);
                }
            }
        });
    }

    private void fireSharedFileAdded(int n) {
        Object[] objectArray = this.listenerList.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[i];
            sharedFilesChangeListener.sharedFileAdded(n);
        }
    }

    private void fireAllSharedFilesChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[i];
                    sharedFilesChangeListener.allSharedFilesChanged();
                }
            }
        });
    }

    public void fireSharedFileChanged(ShareFile shareFile) {
        int n = this.sharedFiles.indexOf(shareFile);
        if (n >= 0) {
            this.fireSharedFileChanged(n);
        }
    }

    class FileRescanRunner
    implements Runnable {
        FileRescanRunner() {
        }

        public void run() {
            Cfg cfg = ServiceManager.sCfg;
            FileAdministration.this.setSharedDirectories(cfg.mUploadDir);
            FileAdministration.this.setExclusions(cfg.mUploadFileExclusions);
            FileAdministration.this.setInclusions(cfg.mUploadFileInclusions);
            FileAdministration.this.rwLock.writeLock();
            try {
                FileAdministration.this.sharedFiles.clear();
                FileAdministration.this.nameToFileMap.clear();
                FileAdministration.this.totalFileSizeKb = 0;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    FileAdministration.this.rwLock.writeUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                throw throwable;
            }
            try {
                FileAdministration.this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException object) {
                ((Throwable)object).printStackTrace();
            }
            FileAdministration.this.fireAllSharedFilesChanged();
            FileAdministration.this.rwLock.readLock();
            try {
                object = ((AbstractList)FileAdministration.this.sharedDirectories).iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    File file = new File(string);
                    FileAdministration.this.scanDir(file, ServiceManager.sCfg.mUploadScanRecursively);
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    FileAdministration.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                throw throwable;
            }
            try {
                FileAdministration.this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

