/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import phex.ServiceManager;

public final class IPUtils {
    private static ArrayList invalidIPs = new ArrayList();
    private static ArrayList privateIPs;

    private IPUtils() {
    }

    public static boolean isInvalidIP(String string) {
        Iterator iterator = ((AbstractList)invalidIPs).iterator();
        return IPUtils.isIPInIterator(string, iterator);
    }

    public static boolean isInvalidIP(byte[] byArray) {
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            return true;
        }
        return byArray[0] >= 224 && byArray[0] <= 239;
    }

    public static boolean isPrivateIP(String string) {
        Iterator iterator = ((AbstractList)privateIPs).iterator();
        return IPUtils.isIPInIterator(string, iterator);
    }

    public static boolean isPrivateIP(byte[] byArray) {
        if (byArray[0] == 10) {
            return true;
        }
        if (byArray[0] == -84 && byArray[1] >= 16 && byArray[1] <= 31) {
            return true;
        }
        return byArray[0] == -64 && byArray[1] == -88;
    }

    public static boolean isHostInUserIgnoreList(String string) {
        return IPUtils.isIPInIterator(string, ((AbstractList)ServiceManager.sCfg.mNetIgnoredHosts).iterator());
    }

    public static boolean isHostInUserInvalidList(String string) {
        return IPUtils.isIPInIterator(string, ((AbstractList)ServiceManager.sCfg.mNetInvalidHosts).iterator());
    }

    public static boolean isHostInUserFilter(String string) {
        return ServiceManager.sCfg.mApplyFilterdHosts && IPUtils.isIPInIterator(string, ((AbstractList)ServiceManager.sCfg.mFilteredSearchHosts).iterator());
    }

    private static boolean isIPInIterator(String string, Iterator iterator) {
        String[] stringArray = IPUtils.splitIP2Parts(string);
        while (iterator.hasNext()) {
            int n;
            Object e = iterator.next();
            String[] stringArray2 = e instanceof String[] ? (String[])e : IPUtils.splitIP2Parts((String)e);
            for (n = 0; n < 4 && (stringArray2[n].equals("*") || stringArray2[n].equals(stringArray[n])); ++n) {
            }
            if (n != 4) continue;
            return true;
        }
        return false;
    }

    public static String[] splitIP2Parts(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken()};
        return stringArray;
    }

    public static String ip2string(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[1] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[2] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[3] & 0xFF);
        return stringBuffer.toString();
    }

    static {
        invalidIPs.add("0.0.0.0");
        invalidIPs.add("224.*.*.*");
        invalidIPs.add("225.*.*.*");
        invalidIPs.add("226.*.*.*");
        invalidIPs.add("227.*.*.*");
        invalidIPs.add("228.*.*.*");
        invalidIPs.add("229.*.*.*");
        invalidIPs.add("230.*.*.*");
        invalidIPs.add("231.*.*.*");
        invalidIPs.add("232.*.*.*");
        invalidIPs.add("233.*.*.*");
        invalidIPs.add("234.*.*.*");
        invalidIPs.add("235.*.*.*");
        invalidIPs.add("236.*.*.*");
        invalidIPs.add("237.*.*.*");
        invalidIPs.add("238.*.*.*");
        invalidIPs.add("239.*.*.*");
        privateIPs = new ArrayList();
        privateIPs.add("10.*.*.*");
        privateIPs.add("172.16.*.*");
        privateIPs.add("172.17.*.*");
        privateIPs.add("172.18.*.*");
        privateIPs.add("172.19.*.*");
        privateIPs.add("172.20.*.*");
        privateIPs.add("172.21.*.*");
        privateIPs.add("172.22.*.*");
        privateIPs.add("172.23.*.*");
        privateIPs.add("172.24.*.*");
        privateIPs.add("172.25.*.*");
        privateIPs.add("172.26.*.*");
        privateIPs.add("172.27.*.*");
        privateIPs.add("172.28.*.*");
        privateIPs.add("172.29.*.*");
        privateIPs.add("172.30.*.*");
        privateIPs.add("172.31.*.*");
        privateIPs.add("192.168.*.*");
    }
}

