/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

public class ReadWriteLock {
    private Thread writeOwner;
    private int readLockCount;
    private boolean readLock = false;
    private boolean writeLock = false;

    public synchronized void readLock() {
        if (this.writeOwner == Thread.currentThread()) {
            return;
        }
        while (this.writeLock) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.readLock = true;
        ++this.readLockCount;
    }

    public synchronized void readUnlock() throws IllegalAccessException {
        if (this.writeOwner == Thread.currentThread()) {
            return;
        }
        --this.readLockCount;
        if (this.readLockCount == 0) {
            this.readLock = false;
        } else if (this.readLockCount < 0) {
            throw new IllegalAccessException("More read unlocks then locks found");
        }
        this.notify();
    }

    public synchronized void writeLock() {
        if (this.writeOwner == Thread.currentThread()) {
            return;
        }
        while (this.writeLock) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.writeLock = true;
        this.writeOwner = Thread.currentThread();
        while (this.readLock) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void writeUnlock() throws IllegalAccessException {
        if (this.writeOwner != Thread.currentThread()) {
            throw new IllegalAccessException("Current thread not owner.");
        }
        this.writeLock = false;
        this.notify();
    }

    private void debug() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("readLock: ").append(this.readLock).append("  ").append(this.readLockCount).append(" - writeLock: ").append(this.writeLock).append(" - ").append(Thread.currentThread()))));
    }
}

