/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.Arrays;

public class SearchEngine {
    private static final int SKIP_TABLE_SIZE = 128;
    private char[] text;
    private char[] pattern;
    private int[] skipTable = new int[128];
    private int patternLength;
    private int textLength;

    public void setText(String string, boolean bl) {
        this.textLength = string.length();
        if (!bl) {
            this.text = new char[this.textLength];
            for (int i = 0; i < this.textLength; ++i) {
                this.text[i] = Character.toLowerCase(string.charAt(i));
            }
        } else {
            this.text = string.toCharArray();
        }
    }

    public void setText(char[] cArray, boolean bl) {
        this.textLength = cArray.length;
        if (!bl) {
            this.text = new char[this.textLength];
            for (int i = 0; i < this.textLength; ++i) {
                this.text[i] = Character.toLowerCase(cArray[i]);
            }
        } else {
            this.text = cArray;
        }
    }

    public void setPattern(String string, boolean bl) {
        this.patternLength = string.length();
        if (!bl) {
            this.pattern = new char[this.patternLength];
            for (int i = 0; i < this.patternLength; ++i) {
                this.pattern[i] = Character.toLowerCase(string.charAt(i));
            }
        } else {
            this.pattern = string.toCharArray();
        }
        this.initSkipTable();
    }

    private void initSkipTable() {
        Arrays.fill(this.skipTable, this.patternLength);
        for (int i = 0; i < this.patternLength - 1; ++i) {
            char c = this.pattern[i];
            int n = this.patternLength - i - 1;
            int n2 = c % 128;
            this.skipTable[n2] = n;
        }
    }

    public boolean match() {
        int n;
        boolean bl = false;
        int n2 = n = this.patternLength - 1;
        block0: while (n >= 0 && n2 < this.textLength) {
            n = this.patternLength - 1;
            int n3 = n2;
            while (true) {
                if (n < 0) {
                    bl = true;
                    continue block0;
                }
                char c = this.pattern[n];
                char c2 = this.text[n3];
                if (c != c2) {
                    int n4 = this.text[n2] % 128;
                    n2 += this.skipTable[n4];
                    continue block0;
                }
                --n;
                --n3;
            }
        }
        return bl;
    }
}

