/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import phex.Debug;
import phex.utils.NotifyThrottleController;
import phex.utils.SlidingWindow;
import phex.utils.ThrottleResetTimer;

public final class ThrottleController
implements NotifyThrottleController {
    private long maxRate;
    private SlidingWindow slidingWindow = new SlidingWindow(2);
    private static final long oneSecondInMillis = 1000L;
    private static final long paneLengthInMillis = 1000L;
    private final String throttleNumberString = Integer.toHexString(this.hashCode());
    private static final ThrottleResetTimer timer = new ThrottleResetTimer(1000L);

    public static ThrottleController acquireThrottle() {
        return new ThrottleController();
    }

    public static void releaseThrottle(ThrottleController throttleController) {
        throttleController.dispose();
    }

    public synchronized void setRate(long l) {
        this.maxRate = l;
    }

    public void controlThrottle(long l) {
        boolean bl;
        ThrottleController throttleController = this;
        synchronized (throttleController) {
            bl = this.slidingWindow.addBytesTransfered(l);
        }
        if (bl) {
            long l2 = timer.getRemainingTimeThisPeriod() + (long)3;
            if (l2 <= (long)0) {
                l2 = 1L;
            }
            try {
                Thread.sleep(l2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ThrottleController() {
        this.setRate(0L);
        timer.registerThrottleController(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void dispose() {
        timer.deregisterThrottleController(this);
    }

    private static void logInfo(String string) {
        Debug.msg(string);
    }

    public void newRatePeriod() {
        this.slidingWindow.slideWindow(this.maxRate);
    }

    public String name() {
        return this.throttleNumberString;
    }
}

