/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import phex.Res;
import phex.ServiceManager;
import phex.actions.base.ActionBase;

public class BaseFrame
extends JFrame {
    private static Vector sFrames = new Vector();
    private Applet mApplet = null;
    private String mFrameType;
    protected Hashtable mActions;
    protected Hashtable mAccelerators = new Hashtable();

    protected BaseFrame() {
    }

    public BaseFrame(String string, Applet applet) {
        sFrames.addElement(this);
        this.mFrameType = string;
        this.mApplet = applet;
        this.mActions = new Hashtable();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: ".concat(String.valueOf(String.valueOf(exception))));
        }
        this.setTitle(Res.getStr(String.valueOf(String.valueOf(this.mFrameType)).concat(".Title")));
        ((Component)this).setBackground(Color.lightGray);
        ImageIcon imageIcon = Res.getIcon(String.valueOf(String.valueOf(this.mFrameType)).concat(".Icon"));
        if (imageIcon != null) {
            ((Frame)this).setIconImage(imageIcon.getImage());
        }
        JMenuBar jMenuBar = this.createMenubar();
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = this.createToolbar();
        if (jToolBar != null) {
            this.getContentPane().add("North", jToolBar);
        }
    }

    public void dispose() {
        sFrames.removeElement(this);
        super.dispose();
    }

    private ActionBase loadAction(String string) {
        String string2 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".ActionID"));
        String string3 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".Label"));
        ImageIcon imageIcon = Res.getIcon(String.valueOf(String.valueOf(string)).concat(".Icon"));
        String string4 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".ActionClass"));
        if (string2 == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Missing ").append(string).append(".ActionID"))));
            return null;
        }
        if (string4 == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Missing ").append(string).append(".ActionClass"))));
            return null;
        }
        if (this.mActions.get(string2) != null) {
            return (ActionBase)this.mActions.get(string2);
        }
        try {
            Class[] classArray = new Class[3];
            Object[] objectArray = new Object[3];
            classArray[0] = this.getClass().getSuperclass();
            classArray[1] = Class.forName("java.lang.String");
            classArray[2] = Class.forName("javax.swing.Icon");
            objectArray[0] = this;
            objectArray[1] = string3;
            objectArray[2] = imageIcon;
            Class<?> clazz = Class.forName(string4);
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            ActionBase actionBase = (ActionBase)constructor.newInstance(objectArray);
            this.mActions.put(string2, actionBase);
            ActionBase actionBase2 = actionBase;
            return actionBase2;
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Fail to load ").append(string4).append(".  ").append(exception))));
            return null;
        }
    }

    private JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String string = Res.getStr(String.valueOf(String.valueOf(this.mFrameType)).concat(".MenuBar"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = Res.getStr(String.valueOf(String.valueOf(string2)).concat(".Label"));
                if (string3 == null) continue;
                JMenu jMenu = new JMenu(string3);
                String string4 = Res.getStr(String.valueOf(String.valueOf(string2)).concat(".Mnemonic"));
                if (string4 != null) {
                    jMenu.setMnemonic(string4.charAt(0));
                }
                this.populateMenu(jMenu, string2);
                jMenuBar.add(jMenu);
            }
        }
        return jMenuBar;
    }

    private void populateMenu(JMenu jMenu, String string) {
        String string2 = Res.getStr(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        Object object = "";
        ButtonGroup buttonGroup = null;
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            Object object3;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            if (Res.getStr(String.valueOf(String.valueOf(string3)).concat(".SubMenu")) != null) {
                object3 = new JMenu(Res.getStr(String.valueOf(String.valueOf(string3)).concat(".Label")));
                object2 = Res.getStr(String.valueOf(String.valueOf(string3)).concat(".Mnemonic"));
                ((AbstractButton)object3).setMnemonic(((String)object2).charAt(0));
                this.populateMenu((JMenu)object3, string3);
                jMenu.add((JMenuItem)object3);
                continue;
            }
            object3 = Res.getStr(String.valueOf(String.valueOf(string3)).concat(".Radio"));
            if (object3 == null) {
                buttonGroup = null;
                object = "";
            } else if (!((String)object3).equals(object) || buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                object = object3;
            }
            if ((object2 = this.createMenuItem(string3, buttonGroup)) == null) continue;
            jMenu.add((JMenuItem)object2);
        }
    }

    public JPopupMenu createPopupMenu(String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.populatePopupMenu(jPopupMenu, string);
        return jPopupMenu;
    }

    public void populatePopupMenu(JPopupMenu jPopupMenu, String string) {
        String string2 = Res.getStr(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = "";
        ButtonGroup buttonGroup = null;
        while (stringTokenizer.hasMoreTokens()) {
            JMenuItem jMenuItem;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("-")) {
                jPopupMenu.addSeparator();
                continue;
            }
            String string5 = Res.getStr(String.valueOf(String.valueOf(string4)).concat(".Radio"));
            if (string5 == null) {
                buttonGroup = null;
                string3 = "";
            } else if (!string5.equals(string3) || buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                string3 = string5;
            }
            if ((jMenuItem = this.createMenuItem(string4, buttonGroup)) == null) continue;
            jPopupMenu.add(jMenuItem);
        }
    }

    private JMenuItem createMenuItem(String string, ButtonGroup buttonGroup) {
        JMenuItem jMenuItem;
        String string2 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".ActionID"));
        if (string2 == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Missing ").append(string).append(".ActionID"))));
            return null;
        }
        String string3 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".Label"));
        ImageIcon imageIcon = Res.getIcon(String.valueOf(String.valueOf(string)).concat(".Icon"));
        boolean bl = Res.getStr(String.valueOf(String.valueOf(string)).concat(".CheckBox")) != null;
        String string4 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".Mnemonic"));
        KeyStroke keyStroke = Res.getAccelerator(String.valueOf(String.valueOf(string)).concat(".Accelerator"));
        boolean bl2 = Res.getStr(String.valueOf(String.valueOf(string)).concat(".Radio.Selected")) != null;
        ActionBase actionBase = this.loadAction(string);
        if (buttonGroup != null) {
            jMenuItem = new JRadioButtonMenuItem(string3);
            buttonGroup.add(jMenuItem);
            if (bl2) {
                jMenuItem.setSelected(true);
            }
        } else {
            jMenuItem = bl ? new JCheckBoxMenuItem(string3) : new JMenuItem(string3);
        }
        if (actionBase != null) {
            jMenuItem.addActionListener(actionBase);
            actionBase.addRefreshComponent(jMenuItem);
        } else {
            jMenuItem.setEnabled(false);
        }
        if (string4 != null) {
            jMenuItem.setMnemonic(string4.charAt(0));
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
            this.mAccelerators.put(keyStroke, keyStroke);
        }
        if (imageIcon != null && !bl) {
            jMenuItem.setIcon(imageIcon);
            jMenuItem.setHorizontalTextPosition(4);
        }
        return jMenuItem;
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        int n = 0;
        String string = Res.getStr(String.valueOf(String.valueOf(this.mFrameType)).concat(".ToolBar"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                AbstractButton abstractButton;
                ++n;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("-")) {
                    jToolBar.addSeparator();
                    continue;
                }
                boolean bl = Res.getStr(String.valueOf(String.valueOf(string2)).concat(".CheckBox")) != null;
                ActionBase actionBase = this.loadAction(string2);
                if (actionBase == null) {
                    System.out.println("No action class for ".concat(String.valueOf(String.valueOf(string2))));
                    continue;
                }
                if (bl) {
                    ImageIcon imageIcon = Res.getIcon(String.valueOf(String.valueOf(string2)).concat(".Icon"));
                    ImageIcon imageIcon2 = Res.getIcon(String.valueOf(String.valueOf(string2)).concat(".Icon.Selected"));
                    JToggleButton jToggleButton = new JToggleButton(imageIcon2);
                    jToggleButton.setSelectedIcon(imageIcon);
                    jToggleButton.addActionListener(actionBase);
                    jToolBar.add(jToggleButton);
                    abstractButton = jToggleButton;
                } else {
                    abstractButton = jToolBar.add(actionBase);
                }
                actionBase.addRefreshComponent(abstractButton);
                abstractButton.setMargin(new Insets(0, 0, 0, 0));
                abstractButton.setToolTipText(Res.getStr(String.valueOf(String.valueOf(string2)).concat(".Tooltip")));
                abstractButton.setText(null);
            }
        }
        if (n > 0) {
            jToolBar.add(Box.createHorizontalGlue());
            return jToolBar;
        }
        return null;
    }

    public void refreshAllActions() {
        Enumeration enumeration = this.mActions.elements();
        while (enumeration.hasMoreElements()) {
            ActionBase actionBase = (ActionBase)enumeration.nextElement();
            actionBase.refresh();
        }
    }

    public void refreshAction(String string) {
        ActionBase actionBase = (ActionBase)this.mActions.get(string);
        if (actionBase != null) {
            actionBase.refresh();
        }
    }

    protected void doAction(Component component, String string) {
        Action action = (Action)this.mActions.get(string);
        if (action == null) {
            JOptionPane.showMessageDialog(this, "No action defined for ".concat(String.valueOf(String.valueOf(string))), "Error", 0);
            return;
        }
        action.actionPerformed(new ActionEvent(component, 1001, string));
    }

    public void addRefreshComponent(String string, JComponent jComponent) {
        ActionBase actionBase = (ActionBase)this.mActions.get(string);
        if (actionBase != null) {
            actionBase.addRefreshComponent(jComponent);
        }
    }

    public void setFonts() {
        FontUIResource fontUIResource = new FontUIResource(ServiceManager.sCfg.mFontTable);
        UIManager.getDefaults().put("Table.font", fontUIResource);
        UIManager.getDefaults().put("TextPane.font", fontUIResource);
        UIManager.getDefaults().put("TextArea.font", fontUIResource);
        UIManager.getDefaults().put("TextField.font", fontUIResource);
        UIManager.getDefaults().put("PasswordField.font", fontUIResource);
        UIManager.getDefaults().put("EditorPane.font", fontUIResource);
        UIManager.getDefaults().put("ProgressBar.font", fontUIResource);
        FontUIResource fontUIResource2 = new FontUIResource(ServiceManager.sCfg.mFontMenu);
        UIManager.getDefaults().put("MenuBar.font", fontUIResource2);
        UIManager.getDefaults().put("Menu.font", fontUIResource2);
        UIManager.getDefaults().put("MenuItem.font", fontUIResource2);
        UIManager.getDefaults().put("PopupMenu.font", fontUIResource2);
        UIManager.getDefaults().put("CheckBoxMenuItem.font", fontUIResource2);
        UIManager.getDefaults().put("RadioButtonMenuItem.font", fontUIResource2);
        FontUIResource fontUIResource3 = new FontUIResource(ServiceManager.sCfg.mFontLabel);
        UIManager.getDefaults().put("CheckBox.font", fontUIResource3);
        UIManager.getDefaults().put("ComboBox.font", fontUIResource3);
        UIManager.getDefaults().put("Button.font", fontUIResource3);
        UIManager.getDefaults().put("Tree.font", fontUIResource3);
        UIManager.getDefaults().put("ScrollPane.font", fontUIResource3);
        UIManager.getDefaults().put("TabbedPane.font", fontUIResource3);
        UIManager.getDefaults().put("TitledBorder.font", fontUIResource3);
        UIManager.getDefaults().put("OptionPane.font", fontUIResource3);
        UIManager.getDefaults().put("ToolBar.font", fontUIResource3);
        UIManager.getDefaults().put("RadioButton.font", fontUIResource3);
        UIManager.getDefaults().put("ToggleButton.font", fontUIResource3);
        UIManager.getDefaults().put("ToolTip.font", fontUIResource3);
        UIManager.getDefaults().put("TableHeader.font", fontUIResource3);
        UIManager.getDefaults().put("Panel.font", fontUIResource3);
        UIManager.getDefaults().put("List.font", fontUIResource3);
        UIManager.getDefaults().put("ColorChooser.font", fontUIResource3);
        UIManager.getDefaults().put("Label.font", fontUIResource3);
        UIManager.getDefaults().put("Viewport.font", fontUIResource3);
        BaseFrame.updateComponentsUI();
    }

    public static void setAllFramesLookAndFeel(LookAndFeel lookAndFeel) {
        try {
            if (lookAndFeel.getID().equals(UIManager.getLookAndFeel().getID())) {
                return;
            }
            UIManager.setLookAndFeel(lookAndFeel);
            BaseFrame.updateComponentsUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(ServiceManager.getManager().getMainFrame(), "Error loading Look & Feel ".concat(String.valueOf(String.valueOf(exception))), "Error", 0);
        }
    }

    private static void updateComponentsUI() {
        for (int i = 0; i < sFrames.size(); ++i) {
            BaseFrame baseFrame = (BaseFrame)sFrames.elementAt(i);
            SwingUtilities.updateComponentTreeUI(baseFrame);
            baseFrame.refreshAllActions();
            Window[] windowArray = baseFrame.getOwnedWindows();
            for (int j = 0; j < windowArray.length; ++j) {
                SwingUtilities.updateComponentTreeUI(windowArray[j]);
            }
        }
    }

    public void resetLookAndFeel() {
        try {
            UIManager.setLookAndFeel(ServiceManager.sCfg.mLFClassName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error loading Look & Feel ".concat(String.valueOf(String.valueOf(exception))), "Error", 0);
        }
        this.refreshAllActions();
    }

    public static void resetAllFramesLookAndFeel() {
        for (int i = 0; i < sFrames.size(); ++i) {
            BaseFrame baseFrame = (BaseFrame)sFrames.elementAt(i);
            baseFrame.resetLookAndFeel();
        }
    }

    public boolean isApplet() {
        return this.mApplet != null;
    }

    public static void centerWindow(Window window, Point point) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        Rectangle rectangle = new Rectangle((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y, dimension2.width, dimension2.height);
        ((Component)window).setBounds(rectangle);
    }

    static void centerAndSizeWindow(Window window, int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width * n / n2;
        int n4 = dimension.height * n / n2;
        Rectangle rectangle = new Rectangle((dimension.width - n3) / 2, (dimension.height - n4) / 2, n3, n4);
        ((Component)window).setBounds(rectangle);
    }
}

