/*
 * Decompiled with CFR 0.152.
 */
package phex;

public class FQueue {
    private int mMax;
    private int mCount;
    private int mHeadIndex;
    private int mTailIndex;
    private Object[] mElements;

    private FQueue() {
    }

    public FQueue(int n) {
        this.mMax = n;
        this.mCount = 0;
        this.mHeadIndex = 0;
        this.mTailIndex = 0;
        this.mElements = new Object[this.mMax];
    }

    public int getCount() {
        return this.mCount;
    }

    public int getMax() {
        return this.mMax;
    }

    public synchronized void resize(int n) {
        if (n == this.mMax) {
            return;
        }
        this.mMax = n;
        this.mElements = new Object[n];
        this.mCount = 0;
        this.mHeadIndex = 0;
        this.mTailIndex = 0;
    }

    public boolean isEmpty() {
        return this.mHeadIndex == this.mTailIndex;
    }

    public synchronized int add(Object object) {
        if (this.mElements.length == 0) {
            return -1;
        }
        this.mHeadIndex = this.nextPos(this.mHeadIndex);
        if (this.mHeadIndex == this.mTailIndex) {
            this.mTailIndex = this.nextPos(this.mTailIndex);
            --this.mCount;
        }
        this.mElements[this.mHeadIndex] = object;
        ++this.mCount;
        return this.mHeadIndex;
    }

    public synchronized void addToHead(Object object) {
        this.mElements[this.mTailIndex] = object;
        this.mTailIndex = this.prevPos(this.mTailIndex);
        if (this.mTailIndex == this.mHeadIndex) {
            this.mHeadIndex = this.prevPos(this.mHeadIndex);
            --this.mCount;
        }
        ++this.mCount;
    }

    public synchronized Object remove() {
        if (this.mTailIndex == this.mHeadIndex) {
            return null;
        }
        this.mTailIndex = this.nextPos(this.mTailIndex);
        --this.mCount;
        return this.mElements[this.mTailIndex];
    }

    public Object getAt(int n) {
        if ((n = this.mTailIndex + 1 + n) >= this.mMax) {
            n -= this.mMax;
        }
        return this.mElements[n];
    }

    private final int nextPos(int n) {
        if (++n > this.mMax) {
            return -1;
        }
        if (n == this.mMax) {
            return 0;
        }
        return n;
    }

    private final int prevPos(int n) {
        if (n == 0) {
            return this.mMax - 1;
        }
        return n - 1;
    }
}

