/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import phex.BaseFrame;
import phex.NetworkManager;
import phex.ServiceManager;
import phex.SignalPanel;
import phex.SplashWindow;
import phex.download.DownloadManager;
import phex.download.RemoteFile;
import phex.event.NetworkHostsChangeListener;
import phex.event.UpdateNotificationListener;
import phex.event.UploadFilesChangeListener;
import phex.gui.dialogs.UpdateNotificationDialog;
import phex.gui.tabs.DownloadTab;
import phex.gui.tabs.MonitorTab;
import phex.gui.tabs.NetworkTab;
import phex.gui.tabs.SearchTab;
import phex.gui.tabs.ShareTab;
import phex.host.HostManager;
import phex.interfaces.IDataChangedListener;
import phex.msg.MsgManager;
import phex.query.Search;
import phex.share.UploadFileContainer;
import phex.update.UpdateChecker;
import phex.utils.BrowserLauncher;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;
import phex.utils.URLUtil;

public class MainFrame
extends BaseFrame {
    public static int DOWNLOAD_TAB = 3;
    private MsgManager mMsgManager = ServiceManager.getMsgManager();
    private DownloadManager mDownloadMgr = ServiceManager.getDownloadManager();
    private StatisticTracker statTracker = ServiceManager.getStatisticTracker();
    private HostManager mHostMgr;
    private NetworkManager mNetworkMgr;
    private JLabel mStatusLabel;
    private JTabbedPane mTabs;
    private JPanel mUpload;
    private Timer mRefresher;
    private boolean mInRefreshHandler = false;
    private SignalPanel mSignalPanel;
    private UploadFileContainer uploadContainer;
    private NetworkTab networkTab;
    private SearchTab searchTab;
    private MonitorTab monitorTab;
    private DownloadTab downloadTab;
    private ShareTab shareTab;

    private MainFrame() {
    }

    public MainFrame(Applet applet, SplashWindow splashWindow) {
        super("Main", applet);
        ServiceManager.getManager().setMainFrame(this);
        this.mHostMgr = ServiceManager.getHostManager();
        this.mNetworkMgr = ServiceManager.getNetworkManager();
        this.uploadContainer = ServiceManager.getShareManager().getUploadFileContainer();
        ServiceManager.sCfg.save();
        this.setFonts();
        this.setupComponents();
        ServiceManager.getListener().setHostChangedListener(this.networkTab);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.pack();
        BaseFrame.centerAndSizeWindow(this, 7, 8);
        this.refreshAllActions();
        this.resetLookAndFeel();
        this.setTitle();
        splashWindow.dispose();
        ((Component)this).setVisible(true);
        try {
            ServiceManager.getListener().startup();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ServiceManager.getNetworkManager().init();
        this.mDownloadMgr.init();
        this.mRefresher = new Timer(1000, new RefreshHandler());
        this.mRefresher.start();
        ServiceManager.getManager().startJobsRunner();
        this.checkForUpdates();
    }

    private void setupComponents() {
        this.mTabs = new JTabbedPane();
        this.mTabs.setMinimumSize(new Dimension(50, 50));
        this.networkTab = new NetworkTab(this);
        this.networkTab.initComponent();
        this.mTabs.add(" Gnutella Net ", this.networkTab);
        this.searchTab = new SearchTab(this);
        this.searchTab.initComponent();
        this.mTabs.add(" Search ", this.searchTab);
        this.monitorTab = new MonitorTab(this);
        this.monitorTab.initComponent();
        this.mTabs.add(" Monitor Search ", this.monitorTab);
        this.downloadTab = new DownloadTab(this);
        this.downloadTab.initComponent();
        this.mTabs.add(" Download ", this.downloadTab);
        this.shareTab = new ShareTab(this);
        this.shareTab.initComponent();
        this.mTabs.add(" Share ", this.shareTab);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.mSignalPanel = new SignalPanel();
        this.mStatusLabel = new JLabel();
        jPanel.add("West", this.mSignalPanel);
        jPanel.add("Center", this.mStatusLabel);
        this.getContentPane().add("Center", this.mTabs);
        this.getContentPane().add("South", jPanel);
        StatusChangedListener statusChangedListener = new StatusChangedListener();
        this.statTracker.addStatusChangedListener(statusChangedListener);
        this.mDownloadMgr.addStatusChangedListener(statusChangedListener);
        this.mHostMgr.addNetworkHostsChangeListener(new NetworkHostsListener());
        this.uploadContainer.addUploadFilesChangeListener(new UploadFilesListener());
    }

    public void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(StrUtil.getAppNameVersion());
        if (this.mNetworkMgr.getJoined()) {
            stringBuffer.append(" - ");
            stringBuffer.append(ServiceManager.sCfg.mCurrentNetwork);
        }
        if (ServiceManager.sCfg.mProxyUse) {
            stringBuffer.append("  (via Proxy Server)");
        }
        super.setTitle(stringBuffer.toString());
    }

    public void selectTab(int n) {
        this.mTabs.setSelectedIndex(n);
    }

    public boolean isNetTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedIndex() == 0;
    }

    public boolean isSearchTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedIndex() == 1;
    }

    public boolean isMonitorTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedIndex() == 2;
    }

    public boolean isDownloadTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedIndex() == DOWNLOAD_TAB;
    }

    public boolean isUploadTabSelected() {
        return this.mTabs != null && this.mTabs.getSelectedIndex() == 4;
    }

    public void search() {
        this.searchTab.search();
    }

    public Search getSelectedSearchResult() {
        return this.searchTab.getSelectedSearchResult();
    }

    public void setSelectedTab(int n) {
        this.mTabs.setSelectedIndex(n);
    }

    public void launchBrowserOnHost() {
        RemoteFile remoteFile;
        if (this.isSearchTabSelected()) {
            remoteFile = this.searchTab.getSelectedRemoteFile();
        } else if (this.isMonitorTabSelected()) {
            remoteFile = this.monitorTab.getSelectedRemoteFile();
        } else {
            return;
        }
        String string = StrUtil.parseURLHostPort(remoteFile.getURL());
        if (string == null) {
            return;
        }
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to launch browser  ".concat(String.valueOf(String.valueOf(exception.getMessage()))), "Can't Launch Browser", 0);
        }
    }

    public void launchBrowserOnURL() {
        RemoteFile remoteFile;
        if (this.isSearchTabSelected()) {
            remoteFile = this.searchTab.getSelectedRemoteFile();
        } else if (this.isMonitorTabSelected()) {
            remoteFile = this.monitorTab.getSelectedRemoteFile();
        } else {
            return;
        }
        String string = URLUtil.encodeURL(remoteFile.getURL());
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to launch browser  ".concat(String.valueOf(String.valueOf(exception.getMessage()))), "Can't Launch Browser", 0);
        }
    }

    public ShareTab getShareTab() {
        return this.shareTab;
    }

    public NetworkTab getNetworkTab() {
        return this.networkTab;
    }

    public SearchTab getSearchTab() {
        return this.searchTab;
    }

    public MonitorTab getMonitorTab() {
        return this.monitorTab;
    }

    public DownloadTab getDownloadTab() {
        return this.downloadTab;
    }

    public int getResultSelectedCount() {
        return this.searchTab.getResultSelectedCount();
    }

    private void checkForUpdates() {
        UpdateChecker updateChecker = new UpdateChecker(new UpdateNotificationListener(){

            public void updateNotification(UpdateChecker updateChecker) {
                UpdateNotificationDialog updateNotificationDialog = new UpdateNotificationDialog(updateChecker);
                updateNotificationDialog.show();
            }
        });
        updateChecker.checkForUpdate();
    }

    private void fireTableChanged(JTable jTable, AbstractTableModel abstractTableModel) {
        int n = jTable.getSelectedRowCount();
        int[] nArray = jTable.getSelectedRows();
        abstractTableModel.fireTableDataChanged();
        if (n > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= jTable.getRowCount()) continue;
                jTable.addRowSelectionInterval(nArray[i], nArray[i]);
            }
        }
    }

    private void updateStatusBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("  Connected Hosts: ");
                stringBuffer.append(MainFrame.this.mHostMgr.getConnectedHostCount());
                stringBuffer.append("    Uploads: ");
                stringBuffer.append(MainFrame.this.uploadContainer.getUploadFileCount());
                stringBuffer.append(", ");
                stringBuffer.append(MainFrame.this.statTracker.getStatUploadCount());
                stringBuffer.append("    Downloads: ");
                stringBuffer.append(MainFrame.this.mDownloadMgr.getDownloadingCount());
                stringBuffer.append(", ");
                stringBuffer.append(MainFrame.this.statTracker.getStatDownloadCount());
                MainFrame.this.mStatusLabel.setText(stringBuffer.toString());
            }
        });
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MainFrame.this.doAction(MainFrame.this, "ActionFileExit");
        }
    }

    private class RefreshHandler
    implements ActionListener {
        private RefreshHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.mInRefreshHandler = true;
            MainFrame.this.networkTab.refresh();
            MainFrame.this.mInRefreshHandler = false;
        }
    }

    private class StatusChangedListener
    implements IDataChangedListener {
        private StatusChangedListener() {
        }

        public void dataChanged(Object object) {
            MainFrame.this.updateStatusBar();
        }
    }

    private class NetworkHostsListener
    implements NetworkHostsChangeListener {
        private NetworkHostsListener() {
        }

        public void networkHostChanged(int n) {
        }

        public void networkHostAdded(int n) {
            MainFrame.this.updateStatusBar();
            this.updateSignalPanel();
        }

        public void networkHostRemoved(int n) {
            MainFrame.this.updateStatusBar();
            this.updateSignalPanel();
        }

        private void updateSignalPanel() {
            int n = MainFrame.this.mHostMgr.getNetworkHostCount();
            if (n > 0) {
                MainFrame.this.mSignalPanel.setState(2);
            } else {
                MainFrame.this.mSignalPanel.setState(0);
            }
        }
    }

    private class UploadFilesListener
    implements UploadFilesChangeListener {
        private UploadFilesListener() {
        }

        public void uploadFileChanged(int n) {
        }

        public void uploadFileAdded(int n) {
            MainFrame.this.updateStatusBar();
        }

        public void uploadFileRemoved(int n) {
            MainFrame.this.updateStatusBar();
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MainFrame.this.refreshAllActions();
        }
    }
}

