/*
 * Decompiled with CFR 0.152.
 */
package phex;

import phex.MainFrame;
import phex.ServiceManager;
import phex.host.HostManager;

public class NetworkManager {
    private static final String sRequestSignature = "GNUTELLA CONNECT";
    private static final String sRequestVersion = "/0.4";
    private ServiceManager mManager = ServiceManager.getManager();
    private boolean mJoined;

    NetworkManager() {
        this.mJoined = ServiceManager.sCfg.mAutoJoin;
    }

    public void init() {
        if (this.getJoined()) {
            HostManager hostManager = ServiceManager.getHostManager();
            hostManager.initializeCaughtHosts();
        }
    }

    public synchronized void joinNetwork() {
        HostManager hostManager = ServiceManager.getHostManager();
        hostManager.initializeCaughtHosts();
        this.mManager.getMainFrame().getNetworkTab().updateStat();
        this.mJoined = true;
        this.mManager.getMainFrame().setTitle();
        this.mManager.getMainFrame().refreshAllActions();
    }

    public synchronized void leaveNetwork() {
        this.mJoined = false;
        MainFrame mainFrame = ServiceManager.getManager().getMainFrame();
        mainFrame.setTitle();
        mainFrame.refreshAllActions();
        ServiceManager.getHostManager().removeAllNetworkHosts();
        ServiceManager.getQueryManager().getSearchContainer().stopAllSearches();
    }

    public boolean getJoined() {
        return this.mJoined;
    }

    public String getGreeting() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            return sRequestSignature;
        }
        return "GNUTELLA PCONNECT ".concat(String.valueOf(String.valueOf(ServiceManager.sCfg.mCurrentNetwork)));
    }

    public String getFullGreeting() {
        return String.valueOf(String.valueOf(this.getGreeting())).concat(sRequestVersion);
    }
}

