/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.net.Socket;
import phex.ServiceManager;
import phex.connection.ConnectionRequest;
import phex.host.Host;
import phex.host.HostAddress;
import phex.msg.MsgPushRequest;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.IOUtil;

public class PushWorker
implements Runnable {
    private MsgPushRequest mPushMsg;

    private PushWorker() {
    }

    public PushWorker(MsgPushRequest msgPushRequest) {
        this.mPushMsg = msgPushRequest;
        new Thread((Runnable)this, "PushWorker-".concat(String.valueOf(String.valueOf(Integer.toHexString(this.hashCode()))))).start();
    }

    public void run() {
        ShareManager shareManager = ServiceManager.getShareManager();
        Host host = null;
        try {
            ShareFile shareFile = shareManager.getFileAdministration().getFileByIndex(this.mPushMsg.getFileIndex());
            if (shareFile == null) {
                return;
            }
            Socket socket = ServiceManager.getConnectionManager().connect(this.mPushMsg.getRequestHost(), (int)this.mPushMsg.getRequestPort());
            HostAddress hostAddress = new HostAddress(this.mPushMsg.getRequestHost(), (int)this.mPushMsg.getRequestPort());
            host = new Host(hostAddress);
            host.setType(4);
            host.setSock(socket);
            host.setOs(socket.getOutputStream());
            host.setIs(socket.getInputStream());
            String string = String.valueOf(String.valueOf(new StringBuffer("GIV ").append(this.mPushMsg.getFileIndex()).append(":").append(this.mPushMsg.getClientID().toHexString()).append("/").append(shareFile.getEffectiveName())));
            byte[] byArray = new byte[1024];
            int n = IOUtil.serializeString(string, byArray, 0);
            byArray[n++] = 10;
            byArray[n++] = 10;
            host.getOs().write(byArray, 0, n);
            ConnectionRequest connectionRequest = new ConnectionRequest(host);
            connectionRequest.initialize();
            if (connectionRequest.getMethod().equals("GET")) {
                shareManager.httpRequestHandler(connectionRequest, host);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

