/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import phex.FlexBuf;
import phex.GUID;
import phex.Listener;
import phex.PushWorker;
import phex.SendManager;
import phex.ServiceManager;
import phex.connection.ConnectionManager;
import phex.connection.ConnectionRequest;
import phex.download.DownloadManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.msg.MsgHeader;
import phex.msg.MsgInit;
import phex.msg.MsgInitResponse;
import phex.msg.MsgManager;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryHistoryMonitor;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.Digest;
import phex.utils.HexDec;
import phex.utils.IOUtil;
import phex.utils.IPUtils;
import phex.utils.StatisticTracker;

public class ReadWorker
implements Runnable {
    private static final String sRequestSignature = "GNUTELLA CONNECT/0.4";
    private static final String sReplySignature = "GNUTELLA OK";
    private static final String sPasswordChallege = "GNUTELLA AUTHENTICATION CHALLENGE";
    private static final String sPasswordReply = "GNUTELLA AUTHENTICATION RESPONSE";
    private static final String sAuthFailed = "GNUTELLA AUTHENTICATION FAILED";
    private Host mRemoteHost;
    private byte[] mHeaderBuf;
    private FlexBuf mBuf1;
    private FlexBuf mBuf2;
    private FlexBuf mBodyBuf;
    private int mSleepBeforeStart = 0;
    private ServiceManager mManager = ServiceManager.getManager();
    private ConnectionManager mConnMgr = ServiceManager.getConnectionManager();
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private SendManager mSendMgr = ServiceManager.getSendManager();
    private ShareManager mShareMgr = ServiceManager.getShareManager();
    private QueryHistoryMonitor queryHistory;
    private FileAdministration fileAdministration;
    private DownloadManager mDownloadMgr = ServiceManager.getDownloadManager();
    private StatisticTracker statTracker = ServiceManager.getStatisticTracker();
    private MsgManager mMsgMgr = ServiceManager.getMsgManager();

    private ReadWorker() {
    }

    public ReadWorker(Host host, int n) {
        this.mRemoteHost = host;
        this.mHeaderBuf = new byte[23];
        this.mBuf1 = new FlexBuf();
        this.mBuf2 = new FlexBuf();
        this.mBodyBuf = new FlexBuf();
        this.mSleepBeforeStart = n;
        this.fileAdministration = this.mShareMgr.getFileAdministration();
        this.queryHistory = ServiceManager.getQueryManager().getQueryHistoryMonitor();
        new Thread((Runnable)this, "ReadWorker-".concat(String.valueOf(String.valueOf(Integer.toHexString(this.hashCode()))))).start();
    }

    public void run() {
        if (!this.mRemoteHost.acquireByWorker()) {
            return;
        }
        if (this.mSleepBeforeStart > 0) {
            try {
                Thread.sleep(this.mSleepBeforeStart);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            try {
                if (this.mRemoteHost.getType() == 1) {
                    this.mRemoteHost.setStatus(2, "");
                    this.connectToRemoteHost();
                    if (this.mRemoteHost.getStatus() == 6) {
                        throw new IOException("Timed out.");
                    }
                    String string = this.mRemoteHost.getSock().getLocalAddress().getHostAddress();
                    ServiceManager.getListener().setSelfHostname(string);
                    this.mRemoteHost.setStatus(2, "Negotiate handshake.");
                    this.negotiateHandShakeAsClient();
                    this.mRemoteHost.setStatus(4, "");
                    this.mHostMgr.addConnectedHost(this.mRemoteHost);
                    this.mSendMgr.queueMsgToSend(this.mRemoteHost, this.mMsgMgr.getMyMsgInit(), false);
                    this.processIncomingData();
                } else if (this.mRemoteHost.getType() == 2) {
                    this.handleIncomingConnection();
                } else {
                    throw new Exception("Invalid host type");
                }
                Object var3_5 = null;
                if (this.mRemoteHost != null) {
                    this.mHostMgr.removeNetworkHost(this.mRemoteHost);
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
            catch (IOException iOException) {
                this.mRemoteHost.setStatus(1, iOException.getMessage());
                Object var3_6 = null;
                if (this.mRemoteHost != null) {
                    this.mHostMgr.removeNetworkHost(this.mRemoteHost);
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
            catch (Exception exception) {
                this.mRemoteHost.setStatus(1, exception.getMessage());
                exception.printStackTrace();
                Object var3_7 = null;
                if (this.mRemoteHost != null) {
                    this.mHostMgr.removeNetworkHost(this.mRemoteHost);
                    this.mRemoteHost.releaseFromWorker();
                    this.mRemoteHost.disconnect();
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            if (this.mRemoteHost != null) {
                this.mHostMgr.removeNetworkHost(this.mRemoteHost);
                this.mRemoteHost.releaseFromWorker();
                this.mRemoteHost.disconnect();
            }
            throw throwable;
        }
    }

    private void handleIncomingConnection() throws Exception {
        ConnectionRequest connectionRequest = this.negotiateHandShakeAsServer();
        if (connectionRequest.getMethod().equals("GNUTELLA CONNECT")) {
            this.mHostMgr.addIncomingHost(this.mRemoteHost);
            this.mSendMgr.queueMsgToSend(this.mRemoteHost, this.mMsgMgr.getMyMsgInit(), false);
            this.processIncomingData();
        } else if (connectionRequest.getMethod().equals("GET")) {
            this.mShareMgr.httpRequestHandler(connectionRequest, this.mRemoteHost);
        } else if (connectionRequest.getMethod().equals("GIV")) {
            if (this.mDownloadMgr.notifyReadPushedFile(connectionRequest, this.mRemoteHost)) {
                this.mRemoteHost.releaseFromWorker();
                this.mRemoteHost = null;
            }
        } else {
            throw new Exception("Unknown incoming request type.");
        }
    }

    private void connectToRemoteHost() throws Exception {
        try {
            this.mRemoteHost.markConnectionStartTime();
            Socket socket = this.mConnMgr.connect(this.mRemoteHost.getHostAddress());
            this.mRemoteHost.setSock(socket);
            this.mRemoteHost.setOs(socket.getOutputStream());
            this.mRemoteHost.setIs(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("Unknown host.");
        }
    }

    private void negotiateHandShakeAsClient() throws Exception {
        boolean bl = false;
        String string = String.valueOf(String.valueOf(ServiceManager.getNetworkManager().getFullGreeting())).concat("\n\n");
        byte[] byArray = this.mBuf1.getBuf(1024);
        int n = IOUtil.serializeString(string, byArray, 0);
        this.mRemoteHost.getOs().write(byArray, 0, n);
        try {
            String string2;
            while (true) {
                StringBuffer stringBuffer = new StringBuffer();
                n = IOUtil.readToCRLF(this.mRemoteHost.getIs(), byArray, 1024, 0);
                IOUtil.deserializeString(byArray, 0, n, stringBuffer);
                string2 = stringBuffer.toString();
                String string3 = (String)ServiceManager.sCfg.mNetworkPasswords.get(ServiceManager.sCfg.mCurrentNetwork);
                if (string2.equals(sReplySignature) || string2.startsWith("GNUTELLA/0.6 200 OK")) {
                    if (!bl && string3 != null && string3.length() > 0) {
                        throw new Exception("Remote host doesn't have password set.");
                    }
                    return;
                }
                if (!string2.startsWith(sPasswordChallege)) break;
                String string4 = string2.substring(sPasswordChallege.length() + 1);
                byte[] byArray2 = HexDec.convertHexStringToBytes(string4);
                if (string3 == null || string3.length() == 0) {
                    throw new Exception("Password requried.");
                }
                byte[] byArray3 = Digest.computePasswordDigest(string3, byArray2);
                String string5 = HexDec.convertBytesToHexString(byArray3);
                n = IOUtil.serializeString(String.valueOf(String.valueOf(new StringBuffer("GNUTELLA AUTHENTICATION RESPONSE ").append(string5).append("\n\n"))), byArray, 0);
                this.mRemoteHost.getOs().write(byArray, 0, n);
                bl = true;
            }
            if (string2.startsWith(sAuthFailed)) {
                throw new Exception("Password not accepted by remote host.");
            }
            throw new Exception(String.valueOf(String.valueOf(new StringBuffer("Unrecognized Reply: ").append(string2).append(" Host: ").append(this.mRemoteHost))));
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw new IOException("Disconnected from remote host during initial handshake");
            }
            exception.printStackTrace();
            throw exception;
        }
    }

    private ConnectionRequest negotiateHandShakeAsServer() throws Exception {
        if (!ServiceManager.getNetworkManager().getJoined()) {
            throw new Exception("Network not joined.");
        }
        if (IPUtils.isHostInUserIgnoreList(this.mRemoteHost.getHostAddress().getHostName())) {
            throw new IOException("Host is ignored.");
        }
        ConnectionRequest connectionRequest = new ConnectionRequest(this.mRemoteHost);
        connectionRequest.initialize();
        return connectionRequest;
    }

    private void processIncomingData() throws Exception {
        block13: {
            this.mRemoteHost.setStatus(4, "");
            try {
                block10: while (true) {
                    MsgHeader msgHeader;
                    if ((msgHeader = this.readHeader()).getDataLen() > 65536) {
                        this.mRemoteHost.log("Packet too big.  ".concat(String.valueOf(String.valueOf(msgHeader))));
                        throw new IOException("Packet too big.  Disconnecting the remote host.");
                    }
                    byte[] byArray = this.readBody(msgHeader);
                    this.mRemoteHost.incReceivedCount();
                    this.statTracker.incStatMsgCount(1);
                    this.statTracker.incStatTakenCount(msgHeader.getHopsTaken());
                    switch (msgHeader.getFunction()) {
                        case 0: {
                            this.handleInit(msgHeader, byArray);
                            continue block10;
                        }
                        case 1: {
                            this.handleInitResponse(msgHeader, byArray);
                            continue block10;
                        }
                        case 64: {
                            this.handlePushRequest(msgHeader, byArray);
                            continue block10;
                        }
                        case 128: {
                            this.handleQuery(msgHeader, byArray);
                            continue block10;
                        }
                        case 129: {
                            this.handleQueryResponse(msgHeader, byArray);
                            continue block10;
                        }
                    }
                    this.handleUnknown(msgHeader, byArray);
                }
            }
            catch (IOException iOException) {
                if (this.mRemoteHost.getSock() != null) {
                    this.mRemoteHost.setStatus(1, iOException.getMessage());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.mRemoteHost.getSock() == null) break block13;
                this.mRemoteHost.setStatus(1, exception.getMessage());
            }
        }
    }

    private MsgHeader readHeader() throws Exception {
        int n;
        int n2;
        InputStream inputStream = this.mRemoteHost.getIs();
        if (inputStream == null) {
            throw new IOException("Connection closed by remote host");
        }
        for (n = 0; n < 23; n += n2) {
            n2 = inputStream.read(this.mHeaderBuf, n, 23 - n);
            if (n2 != 0 && n2 != -1) continue;
            this.mRemoteHost.log("Disconnected from remote host during reading header");
            throw new IOException("Connection closed by remote host");
        }
        this.statTracker.incBytesCount(n);
        MsgHeader msgHeader = new MsgHeader(new GUID(true));
        msgHeader.deserialize(this.mHeaderBuf, 0);
        msgHeader.setArrivalTime(System.currentTimeMillis());
        msgHeader.setFromHost(this.mRemoteHost);
        this.mHostMgr.throttleControl(n);
        return msgHeader;
    }

    private byte[] readBody(MsgHeader msgHeader) throws Exception {
        InputStream inputStream = this.mRemoteHost.getIs();
        if (inputStream == null) {
            throw new IOException("Connection closed by remote host");
        }
        int n = msgHeader.getDataLen();
        int n2 = 0;
        byte[] byArray = this.mBodyBuf.getBuf(n);
        Arrays.fill(byArray, (byte)0);
        while (n2 < n) {
            int n3;
            int n4 = n - n2;
            if (n4 > 1024) {
                n4 = 1024;
            }
            if ((n3 = inputStream.read(byArray, n2, n4)) == 0 || n3 == -1) {
                throw new IOException("Connection closed by remote host");
            }
            this.statTracker.incBytesCount(n3);
            this.mHostMgr.throttleControl(n2 += n3);
        }
        return byArray;
    }

    private void handleInit(MsgHeader msgHeader, byte[] byArray) throws Exception {
        MsgInit msgInit = new MsgInit(msgHeader);
        msgInit.deserialize(byArray, 0);
        if (this.mMsgMgr.checkAndAddMsgSeen(msgInit)) {
            this.mRemoteHost.incDropCount();
            this.statTracker.incStatDropCount(1);
            return;
        }
        this.mMsgMgr.addToRoutingTable(msgInit.getHeader().getMsgID(), this.mRemoteHost);
        this.mMsgMgr.forwardMsg(msgInit, this.mRemoteHost);
        Listener listener = ServiceManager.getListener();
        if (!this.mHostMgr.hasIncommingSlotsAvailable()) {
            return;
        }
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID());
        MsgInitResponse msgInitResponse = new MsgInitResponse(msgHeader2);
        msgHeader2.setTTL(msgHeader.getHopsTaken() + 1);
        msgInitResponse.setPort((short)listener.getLocalAddress().getPort());
        msgInitResponse.setIP(listener.getLocalAddress().getHostIP());
        msgInitResponse.setFileCount(this.fileAdministration.getFileCount());
        msgInitResponse.setTotalSize(this.fileAdministration.getTotalFileSizeInKb());
        this.mSendMgr.queueMsgToSend(this.mRemoteHost, msgInitResponse, false);
    }

    private void handleInitResponse(MsgHeader msgHeader, byte[] byArray) throws Exception {
        MsgInitResponse msgInitResponse = new MsgInitResponse(msgHeader);
        msgInitResponse.deserialize(byArray, 0);
        HostAddress hostAddress = new HostAddress(msgInitResponse.getIP(), (int)msgInitResponse.getPort());
        if (!IPUtils.isHostInUserInvalidList(hostAddress.getHostName())) {
            this.mHostMgr.addCaughtHost(hostAddress, (short)1);
        }
        MsgInit msgInit = this.mMsgMgr.getMyMsgInit();
        if (msgInitResponse.getHeader().getMsgID().equals(msgInit.getHeader().getMsgID())) {
            this.statTracker.incStatHosts(1);
            this.statTracker.incStatFiles(msgInitResponse.getFileCount());
            this.statTracker.incStatSize(msgInitResponse.getTotalSize());
            return;
        }
        if (this.mRemoteHost.checkPingResponse(msgInitResponse)) {
            return;
        }
        Host host = this.mMsgMgr.getRouting(msgInitResponse.getHeader().getMsgID());
        if (host == null) {
            return;
        }
        if (this.mMsgMgr.decTTL(msgInitResponse)) {
            return;
        }
        this.mSendMgr.queueMsgToSend(host, msgInitResponse, false);
    }

    private void handleQuery(MsgHeader msgHeader, byte[] byArray) throws Exception {
        MsgQuery msgQuery = new MsgQuery(msgHeader);
        msgQuery.deserialize(byArray, 0);
        if (this.mMsgMgr.checkAndAddMsgSeen(msgQuery)) {
            this.mRemoteHost.incDropCount();
            this.statTracker.incStatDropCount(1);
            return;
        }
        this.mMsgMgr.addToRoutingTable(msgQuery.getHeader().getMsgID(), this.mRemoteHost);
        this.queryHistory.addSearchQuery(msgQuery);
        this.mMsgMgr.forwardMsg(msgQuery, this.mRemoteHost);
        if ((long)msgQuery.getMinSpeed() * 1024L > (long)ServiceManager.sCfg.mUploadMaxBandwidth) {
            return;
        }
        ShareFile[] shareFileArray = this.mShareMgr.searchFile(msgQuery.getSearchString());
        if (shareFileArray.length == 0) {
            return;
        }
        Listener listener = ServiceManager.getListener();
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID());
        msgHeader2.setTTL(msgHeader.getHopsTaken() + 1);
        int n = shareFileArray.length;
        if (n > 255) {
            n = 255;
        }
        ShareFile shareFile = null;
        MsgResRecord[] msgResRecordArray = new MsgResRecord[n];
        for (int i = 0; i < n; ++i) {
            MsgResRecord msgResRecord;
            shareFile = shareFileArray[i];
            msgResRecordArray[i] = msgResRecord = new MsgResRecord(shareFile.getFileIndex(), (int)shareFile.getFileSize(), shareFile.getEffectiveName());
        }
        HostAddress hostAddress = listener.getLocalAddress();
        InetAddress inetAddress = InetAddress.getByName(hostAddress.getHostName());
        short s = (short)hostAddress.getPort();
        MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader2, this.mManager.getClientID(), inetAddress, s, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L), msgResRecordArray);
        this.mSendMgr.queueMsgToSend(this.mRemoteHost, msgQueryResponse, false);
    }

    private void handleQueryResponse(MsgHeader msgHeader, byte[] byArray) throws Exception {
        int n = msgHeader.getDataLen();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader, byArray2);
        this.mMsgMgr.addToPushRoutingTable(msgQueryResponse.getRemoteClientID(), this.mRemoteHost);
        this.mMsgMgr.processQueryResponse(this.mRemoteHost, msgQueryResponse);
        Host host = this.mMsgMgr.getRouting(msgQueryResponse.getHeader().getMsgID());
        if (host == null) {
            return;
        }
        if (this.mMsgMgr.decTTL(msgQueryResponse)) {
            return;
        }
        this.mSendMgr.queueMsgToSend(host, msgQueryResponse, false);
    }

    private void handlePushRequest(MsgHeader msgHeader, byte[] byArray) throws Exception {
        MsgPushRequest msgPushRequest = new MsgPushRequest(msgHeader);
        msgPushRequest.deserialize(byArray, 0);
        if (this.mManager.getClientID().equals(msgPushRequest.getClientID())) {
            new PushWorker(msgPushRequest);
            return;
        }
        Host host = this.mMsgMgr.getPushRouting(msgPushRequest.getClientID());
        if (host == null) {
            return;
        }
        if (this.mMsgMgr.decTTL(msgPushRequest)) {
            return;
        }
        this.mSendMgr.queueMsgToSend(host, msgPushRequest, false);
    }

    private void handleUnknown(MsgHeader msgHeader, byte[] byArray) throws Exception {
        this.mRemoteHost.incDropCount();
        this.statTracker.incStatDropCount(1);
    }
}

