/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import phex.Debug;
import phex.GUID;
import phex.JobsRunner;
import phex.Listener;
import phex.MainFrame;
import phex.NetworkManager;
import phex.SendManager;
import phex.common.TransferRateService;
import phex.config.Cfg;
import phex.connection.ConnectionManager;
import phex.download.DownloadManager;
import phex.gui.common.LazyEventQueue;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.share.IndexerManager;
import phex.share.ShareManager;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;

public class ServiceManager {
    private static final String CONFIG_FILE_NAME;
    private static final String LOG_FILE_NAME;
    private static final String HOSTS_FILE_NAME;
    private static final String AUTOCONNECT_HOSTS_FILE_NAME;
    private static final String DEBUG_FILE_NAME;
    private static final String OLD_DOWNLOAD_FILE_NAME;
    private static final String XML_DOWNLOAD_FILE_NAME;
    private static final String XML_RESEARCH_SERVICE_FILE_NAME;
    private static ServiceManager sTheManager;
    private static Object sInitLocker;
    public static Cfg sCfg;
    private String mLogfilename;
    private String mDebugfilename;
    private String mHostsFilename;
    private String mObjectDownloadSaveFilename;
    private String mXMLDownloadSaveFilename;
    private String xmlResearchServiceFilename;
    private PrintWriter mLogFile;
    private ConnectionManager mConnectionManager;
    private NetworkManager mNetworkManager;
    private SendManager mSendManager;
    private HostManager mHostManager;
    private MsgManager mMsgManager;
    private ShareManager mShareManager;
    private DownloadManager mDownloadManager;
    private QueryManager queryManager;
    private IndexerManager mIndexerManager;
    private Listener mListener;
    private JobsRunner mJobsRunner;
    private MainFrame mMainFrame;
    private StatisticTracker statisticTracker;
    private TransferRateService transferRateService;
    private LazyEventQueue lazyEventQueue;

    private static void checkPhexHomePath() {
        String string = ServiceManager.determinePhexHomePath();
        File file = new File(string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        String[] stringArray = new String[]{"phex.cfg", "phex.log", "phex.hosts", "phex.debug", "phex.download", "phexdownload.xml"};
        String string2 = System.getProperty("user.home");
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(File.separator).append(stringArray[i]))));
            if (!file2.exists()) continue;
            File file3 = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append(stringArray[i]))));
            file2.renameTo(file3);
        }
    }

    private static String determinePhexHomePath() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(File.separator);
        if (File.separatorChar == '/') {
            stringBuffer.append('.');
        }
        stringBuffer.append("phex");
        return stringBuffer.toString();
    }

    public static ServiceManager getManager() {
        if (sTheManager == null) {
            Object object = sInitLocker;
            synchronized (object) {
                if (sTheManager == null) {
                    sTheManager = new ServiceManager();
                    sTheManager.init();
                }
            }
        }
        return sTheManager;
    }

    private ServiceManager() {
        sCfg = new Cfg(CONFIG_FILE_NAME);
        sCfg.load();
        this.mLogfilename = ServiceManager.sCfg.mLogFile;
        if (this.mLogfilename == null || this.mLogfilename.length() == 0) {
            this.mLogfilename = LOG_FILE_NAME;
        }
        this.mLogfilename = ServiceManager.envSubstitution(this.mLogfilename);
        try {
            this.mLogFile = new PrintWriter(new BufferedWriter(new FileWriter(this.mLogfilename)));
        }
        catch (IOException iOException) {
            this.mLogFile = new PrintWriter(new OutputStreamWriter(System.out));
            this.logMsg(String.valueOf(String.valueOf(new StringBuffer("Failed to create default log file '").append(this.mLogfilename).append(".'  ").append(iOException.toString()))));
            this.logMsg("Use standard output.");
        }
        this.mDebugfilename = ServiceManager.sCfg.mDebugFile;
        if (this.mDebugfilename == null || this.mDebugfilename.length() == 0) {
            this.mDebugfilename = DEBUG_FILE_NAME;
        }
        this.mDebugfilename = ServiceManager.envSubstitution(this.mDebugfilename);
        try {
            Debug.out = new PrintWriter(new BufferedWriter(new FileWriter(this.mDebugfilename)));
        }
        catch (IOException iOException) {
            Debug.out = new PrintWriter(new OutputStreamWriter(System.out));
            Debug.out.println(String.valueOf(String.valueOf(new StringBuffer("Failed to create default debug file '").append(this.mDebugfilename).append(".'  ").append(iOException.toString()))));
            Debug.out.println("Use standard output.");
        }
        this.mHostsFilename = ServiceManager.sCfg.mHostFile;
        if (this.mHostsFilename == null || this.mHostsFilename.length() == 0) {
            this.mHostsFilename = HOSTS_FILE_NAME;
        }
        this.mHostsFilename = ServiceManager.envSubstitution(this.mHostsFilename);
        this.mObjectDownloadSaveFilename = ServiceManager.sCfg.mDownloadSaveFile;
        if (this.mObjectDownloadSaveFilename == null || this.mObjectDownloadSaveFilename.length() == 0) {
            this.mObjectDownloadSaveFilename = OLD_DOWNLOAD_FILE_NAME;
        }
        this.mObjectDownloadSaveFilename = ServiceManager.envSubstitution(this.mObjectDownloadSaveFilename);
        this.mXMLDownloadSaveFilename = ServiceManager.sCfg.mXMLDownloadSaveFile;
        if (this.mXMLDownloadSaveFilename == null || this.mXMLDownloadSaveFilename.length() == 0) {
            this.mXMLDownloadSaveFilename = XML_DOWNLOAD_FILE_NAME;
        }
        this.mXMLDownloadSaveFilename = ServiceManager.envSubstitution(this.mXMLDownloadSaveFilename);
        this.xmlResearchServiceFilename = ServiceManager.sCfg.xmlResearchServiceFilename;
        if (this.xmlResearchServiceFilename == null || this.xmlResearchServiceFilename.length() == 0) {
            this.xmlResearchServiceFilename = XML_RESEARCH_SERVICE_FILE_NAME;
        }
        this.xmlResearchServiceFilename = ServiceManager.envSubstitution(this.xmlResearchServiceFilename);
    }

    private void init() {
        ServiceManager.log("\n*** ServiceManager initializing ***");
        this.statisticTracker = new StatisticTracker();
        this.transferRateService = new TransferRateService();
        this.mIndexerManager = new IndexerManager(this);
        this.mConnectionManager = new ConnectionManager();
        this.mNetworkManager = new NetworkManager();
        this.mListener = new Listener();
        this.mHostManager = new HostManager();
        this.queryManager = new QueryManager();
        this.mSendManager = new SendManager();
        this.mMsgManager = new MsgManager();
        this.mShareManager = new ShareManager();
        this.mDownloadManager = new DownloadManager();
        this.lazyEventQueue = new LazyEventQueue();
        this.mJobsRunner = new JobsRunner();
        ServiceManager.log("*** ServiceManager is ready ***");
    }

    public synchronized void shutdown() {
        this.mLogFile.flush();
        ServiceManager.log("manager shutting down...");
        this.mJobsRunner.shutdown(true);
        this.mLogFile.close();
    }

    public void startJobsRunner() {
        this.mJobsRunner.startup();
    }

    public static ConnectionManager getConnectionManager() {
        return ServiceManager.getManager().mConnectionManager;
    }

    public static LazyEventQueue getLazyEventQueue() {
        return ServiceManager.getManager().lazyEventQueue;
    }

    public static NetworkManager getNetworkManager() {
        return ServiceManager.getManager().mNetworkManager;
    }

    public static SendManager getSendManager() {
        return ServiceManager.getManager().mSendManager;
    }

    public static HostManager getHostManager() {
        return ServiceManager.getManager().mHostManager;
    }

    public static QueryManager getQueryManager() {
        return ServiceManager.getManager().queryManager;
    }

    public static StatisticTracker getStatisticTracker() {
        return ServiceManager.getManager().statisticTracker;
    }

    public static TransferRateService getTransferRateService() {
        return ServiceManager.getManager().transferRateService;
    }

    public static MsgManager getMsgManager() {
        return ServiceManager.getManager().mMsgManager;
    }

    public static ShareManager getShareManager() {
        return ServiceManager.getManager().mShareManager;
    }

    public static DownloadManager getDownloadManager() {
        return ServiceManager.getManager().mDownloadManager;
    }

    public static IndexerManager getIndexerManager() {
        return ServiceManager.getManager().mIndexerManager;
    }

    public static Listener getListener() {
        return ServiceManager.getManager().mListener;
    }

    public GUID getClientID() {
        return ServiceManager.sCfg.mProgramClientID;
    }

    public static String getHostsFilename() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            return ServiceManager.getManager().mHostsFilename;
        }
        String string = String.valueOf(String.valueOf(new StringBuffer("phex_").append(ServiceManager.sCfg.mCurrentNetwork).append(".hosts")));
        string = StrUtil.convertToLocalSystemFilename(string);
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(System.getProperty("user.home")))).append(File.separator).append(string)));
    }

    public static String getAutoConnectHostsFilename() {
        return AUTOCONNECT_HOSTS_FILE_NAME;
    }

    public static String getObjectDownloadSaveFilename() {
        return ServiceManager.getManager().mObjectDownloadSaveFilename;
    }

    public static String getXMLDownloadSaveFilename() {
        return ServiceManager.getManager().mXMLDownloadSaveFilename;
    }

    public static String getXMLResearchServiceFilename() {
        return ServiceManager.getManager().xmlResearchServiceFilename;
    }

    public static void log(String string) {
        ServiceManager.getManager().logMsg(string);
    }

    public static void log(Exception exception) {
        ServiceManager.getManager().logMsg(exception);
    }

    public void logMsg(String string) {
        this.mLogFile.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DateFormat.getTimeInstance(2).format(new Date())))).append(": ").append(string))));
        this.mLogFile.flush();
    }

    public void logMsg(Exception exception) {
        this.mLogFile.println(exception.toString());
        exception.printStackTrace(this.mLogFile);
        this.mLogFile.flush();
    }

    public static String envSubstitution(String string) {
        String string2 = string.toLowerCase();
        String string3 = "$user.home";
        String string4 = "$(user.home)";
        if (string2.startsWith(string3)) {
            string = String.valueOf(String.valueOf(System.getProperty("user.home"))).concat(String.valueOf(String.valueOf(string.substring(string3.length()))));
        } else if (string2.startsWith(string4)) {
            string = String.valueOf(String.valueOf(System.getProperty("user.home"))).concat(String.valueOf(String.valueOf(string.substring(string4.length()))));
        }
        return string;
    }

    void setMainFrame(MainFrame mainFrame) {
        this.mMainFrame = mainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mMainFrame;
    }

    public static void printStack(String string) {
        try {
            throw new Exception(string);
        }
        catch (Exception exception) {
            ServiceManager.log(exception);
            return;
        }
    }

    static {
        ServiceManager.checkPhexHomePath();
        String string = ServiceManager.determinePhexHomePath();
        CONFIG_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phex.cfg")));
        LOG_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phex.log")));
        HOSTS_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phex.hosts")));
        AUTOCONNECT_HOSTS_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("autoconnecthosts.cfg")));
        DEBUG_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phex.debug")));
        OLD_DOWNLOAD_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phex.download")));
        XML_DOWNLOAD_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phexdownload.xml")));
        XML_RESEARCH_SERVICE_FILE_NAME = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("phexresearch.xml")));
        sTheManager = null;
        sInitLocker = new Object();
    }
}

