/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import phex.ServiceManager;
import phex.host.HostAddress;
import phex.utils.IOUtil;

public class ConnectionManager {
    public Socket connect(String string) throws Exception {
        return this.connect(new HostAddress(string));
    }

    public Socket connect(HostAddress hostAddress) throws Exception {
        return this.connect(hostAddress.getHostName(), hostAddress.getPort());
    }

    public Socket connect(HostAddress hostAddress, int n) throws IOException {
        return this.connect(hostAddress.getHostName(), hostAddress.getPort(), n);
    }

    public Socket connect(String string, int n) throws IOException {
        return this.connect(string, n, 0);
    }

    public Socket connect(String string, int n, int n2) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Wrong host address (port out of range: ").append(n).append(" )"))));
        }
        if (ServiceManager.sCfg.mProxyUse) {
            return this.connectSock5(string, n);
        }
        SocketFactory socketFactory = new SocketFactory(string, n, n2);
        return socketFactory.createSocket();
    }

    private Socket connectSock5(String string, int n) throws IOException {
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            socket = new Socket(ServiceManager.sCfg.mProxyHost, ServiceManager.sCfg.mProxyPort);
            this.setSocketTimeout(socket, socket.getInetAddress().getAddress());
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            byte[] byArray = new byte[600];
            byArray[0] = 5;
            byArray[1] = 1;
            byArray[2] = 0;
            int n2 = 3;
            if (ServiceManager.sCfg.mProxyUserName.length() > 0) {
                byArray[1] = 2;
                byArray[3] = 2;
                n2 = 4;
            }
            outputStream.write(byArray, 0, n2);
            int n3 = inputStream.read();
            if (n3 != 5) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n3);
                while (n3 != -1) {
                    n3 = inputStream.read();
                    stringBuffer.append((char)n3);
                }
                throw new IOException("Invalid response from Socks5 proxy server: ".concat(String.valueOf(String.valueOf(stringBuffer.toString()))));
            }
            byte by = (byte)inputStream.read();
            if (by == -1) {
                throw new IOException("No acceptable authentication method selected by Socks5 proxy server.");
            }
            if (by != 0) {
                if (by == 2) {
                    this.authenticateUserPassword(inputStream, outputStream, byArray);
                } else {
                    throw new IOException("Unknown authentication method selected by Socks5 proxy server.");
                }
            }
            n2 = 0;
            byArray[n2++] = 5;
            byArray[n2++] = 1;
            byArray[n2++] = 0;
            byArray[n2++] = 1;
            n2 = IOUtil.serializeIP(string, byArray, n2);
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
            outputStream.write(byArray, 0, n2);
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            inputStream.read();
            int n6 = inputStream.read();
            if (n6 == 1) {
                inputStream.read();
                inputStream.read();
                inputStream.read();
                inputStream.read();
            } else if (n6 == 3) {
                n2 = inputStream.read();
                if (n2 < 0) {
                    n2 += 256;
                }
                while (n2 > 0) {
                    inputStream.read();
                    --n2;
                }
            } else if (n6 == 4) {
                for (int i = 0; i < 16; ++i) {
                    inputStream.read();
                }
            } else {
                throw new IOException("Invalid return address type for Socks5");
            }
            inputStream.read();
            inputStream.read();
            if (n4 == 5 && n5 == 0) {
                Socket socket2 = socket;
                return socket2;
            }
            throw new IOException("Connection failed via Socks5 proxy server.  Proxy status=".concat(String.valueOf(String.valueOf(n5))));
        }
        catch (Exception exception) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
            throw new IOException("Proxy server: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
        }
    }

    private void authenticateUserPassword(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 0;
        byArray[n++] = 1;
        byArray[n++] = (byte)ServiceManager.sCfg.mProxyUserName.length();
        n = IOUtil.serializeString(ServiceManager.sCfg.mProxyUserName, byArray, n);
        byArray[n++] = (byte)ServiceManager.sCfg.mProxyPassword.length();
        n = IOUtil.serializeString(ServiceManager.sCfg.mProxyPassword, byArray, n);
        outputStream.write(byArray, 0, n);
        if (inputStream.read() == 1 && inputStream.read() == 0) {
            return;
        }
        throw new IOException("Proxy server authentication failed.");
    }

    public void setSocketTimeout(Socket socket, byte[] byArray) throws IOException {
        socket.setSoTimeout(ServiceManager.sCfg.mSocketTimeout);
    }

    private class OpenSocketThread
    extends Thread {
        private String host;
        private int port;
        private boolean isTimedOut;
        private Socket socket;
        private SocketFactory notifyFactory;
        private IOException connectException;

        public OpenSocketThread(ConnectionManager connectionManager, String string, int n, SocketFactory socketFactory) {
            this.host = string;
            this.port = n;
            this.notifyFactory = socketFactory;
        }

        public Socket acquireSocketOrTimeout() throws IOException {
            SocketFactory socketFactory = this.notifyFactory;
            synchronized (socketFactory) {
                if (this.connectException != null) {
                    throw this.connectException;
                }
                if (this.socket != null) {
                    Socket socket = this.socket;
                    return socket;
                }
                this.setTimedOut(true);
            }
            return null;
        }

        public void setTimedOut(boolean bl) {
            SocketFactory socketFactory = this.notifyFactory;
            synchronized (socketFactory) {
                this.isTimedOut = bl;
                if (this.socket == null) {
                    return;
                }
                if (this.isTimedOut) {
                    this.closeSocket();
                }
            }
        }

        public void run() {
            Socket socket = null;
            try {
                socket = new Socket(this.host, this.port);
            }
            catch (IOException iOException) {
                this.connectException = iOException;
            }
            SocketFactory socketFactory = this.notifyFactory;
            synchronized (socketFactory) {
                this.socket = socket;
                if (this.isTimedOut) {
                    this.closeSocket();
                } else {
                    this.notifyFactory.notify();
                }
            }
        }

        private void closeSocket() {
            if (this.socket == null) {
                return;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class SocketFactory {
        private String host;
        private int port;
        private int timeout;

        public SocketFactory(String string, int n, int n2) {
            this.host = string;
            this.port = n;
            this.timeout = n2;
        }

        public Socket createSocket() throws IOException {
            if (this.timeout == 0) {
                Socket socket = new Socket(this.host, this.port);
                ConnectionManager.this.setSocketTimeout(socket, socket.getInetAddress().getAddress());
                return socket;
            }
            ConnectionManager connectionManager = ConnectionManager.this;
            connectionManager.getClass();
            OpenSocketThread openSocketThread = new OpenSocketThread(connectionManager, this.host, this.port, this);
            openSocketThread.start();
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                openSocketThread.setTimedOut(true);
                throw new IOException("Timeout while opening Socket");
            }
            Socket socket = openSocketThread.acquireSocketOrTimeout();
            if (socket == null) {
                throw new IOException("Timeout while opening Socket");
            }
            return socket;
        }
    }
}

