/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import phex.FlexBuf;
import phex.HttpRequest;
import phex.ServiceManager;
import phex.common.HandshakeHeaders;
import phex.host.Host;
import phex.utils.Digest;
import phex.utils.HexDec;
import phex.utils.IOUtil;
import phex.utils.VersionUtils;

public class ConnectionRequest
extends HttpRequest {
    private static final String PROTOCOL_04 = "0.4";
    private static final String GNUTELLA_OK_04 = "GNUTELLA OK";
    private static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String sGnutellaConnect = "GNUTELLA CONNECT";
    public static final String sGet = "GET";
    public static final String sGiv = "GIV";
    private static final String sPasswordChallege = "GNUTELLA AUTHENTICATION CHALLENGE";
    private static final String sPasswordReply = "GNUTELLA AUTHENTICATION RESPONSE";
    private static final String sAuthFailed = "GNUTELLA AUTHENTICATION FAILED";
    private Host remoteHost;
    private FlexBuf flexBuffer;

    public ConnectionRequest(Host host) throws Exception {
        this.remoteHost = host;
        this.flexBuffer = new FlexBuf();
    }

    public void initialize() throws Exception {
        String string;
        InputStream inputStream = this.remoteHost.getIs();
        if (inputStream == null) {
            throw new IOException("Disconnected from remote host during initial handshake");
        }
        String string2 = this.readLineFromHost();
        if (!string2.startsWith(String.valueOf(String.valueOf(string = ServiceManager.getNetworkManager().getGreeting())).concat("/"))) {
            if (string2.startsWith("GET ")) {
                this.setMethod(sGet);
                int n = string2.indexOf("/get/");
                this.setUri(string2.substring(n, string2.length()));
                int n2 = string2.indexOf("HTTP/") + 5;
                this.setVersion(string2.substring(n2, string2.length()));
                return;
            }
            if (string2.startsWith("GIV ")) {
                this.setMethod(sGiv);
                String string3 = string2.substring(4);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                this.putHeader("FileRef", stringTokenizer.nextToken());
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "/");
                this.putHeader("ClientID", stringTokenizer2.nextToken());
                this.putHeader("Filename", stringTokenizer2.nextToken());
                return;
            }
            throw new Exception("Unknown request: ".concat(String.valueOf(String.valueOf(string2))));
        }
        this.handleGnutellaConnect(string2);
    }

    private void handleGnutellaConnect(String string) throws Exception {
        if (!ServiceManager.getHostManager().hasIncommingSlotsAvailable()) {
            throw new IOException("No free slots.");
        }
        this.setMethod(sGnutellaConnect);
        int n = string.lastIndexOf(47) + 1;
        String string2 = string.substring(n, string.length());
        this.setVersion(string2);
        if (string2.equals(PROTOCOL_04)) {
            this.checkPassword();
            this.sendStringToHost("GNUTELLA OK\n\n");
        } else if (this.is06orHigher(string2)) {
            this.readHeaders(this.remoteHost.getIs());
            this.sendStringToHost("GNUTELLA/0.6 200 OK\r\n");
            this.sendHeadersToHost(HandshakeHeaders.OPEN_HEADERS);
            String string3 = this.readLineFromHost();
            if (!string3.equals(GNUTELLA_OK_06)) {
                throw new IOException("Bad protocol response");
            }
            this.readHeaders(this.remoteHost.getIs());
        }
    }

    private void sendHeadersToHost(Properties properties) throws Exception {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.sendStringToHost(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(": ").append(string2).append("\r\n"))));
        }
        this.sendStringToHost("\r\n");
    }

    private String readLineFromHost() throws Exception {
        byte[] byArray = this.flexBuffer.getBuf(1024);
        int n = IOUtil.readToCRLF(this.remoteHost.getIs(), byArray, 1024, 0);
        StringBuffer stringBuffer = new StringBuffer();
        IOUtil.deserializeString(byArray, 0, n, stringBuffer);
        String string = stringBuffer.toString();
        return string;
    }

    private void sendStringToHost(String string) throws Exception {
        byte[] byArray = this.flexBuffer.getBuf(string.length());
        int n = IOUtil.serializeString(string, byArray, 0);
        this.remoteHost.getOs().write(byArray, 0, n);
    }

    private boolean is06orHigher(String string) {
        int n = VersionUtils.compare(string, PROTOCOL_04);
        return n >= 0;
    }

    private void checkPassword() throws Exception {
        String string = (String)ServiceManager.sCfg.mNetworkPasswords.get(ServiceManager.sCfg.mCurrentNetwork);
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = this.flexBuffer.getBuf(1024);
            byte[] byArray2 = Digest.generateChallengeKey();
            String string2 = HexDec.convertBytesToHexString(byArray2);
            byte[] byArray3 = Digest.computePasswordDigest(string, byArray2);
            String string3 = HexDec.convertBytesToHexString(byArray3);
            int n = IOUtil.serializeString(String.valueOf(String.valueOf(new StringBuffer("GNUTELLA AUTHENTICATION CHALLENGE ").append(string2).append("\n\n"))), byArray, 0);
            this.remoteHost.getOs().write(byArray, 0, n);
            n = IOUtil.readToCRLF(this.remoteHost.getIs(), byArray, 1024, 0);
            IOUtil.deserializeString(byArray, 0, n, stringBuffer);
            String string4 = stringBuffer.toString();
            if (string4.startsWith(sPasswordReply)) {
                String string5 = string4.substring(sPasswordReply.length() + 1);
                string5.toUpperCase();
                if (!string3.equals(string5)) {
                    n = IOUtil.serializeString("GNUTELLA AUTHENTICATION FAILED\n\n", byArray, 0);
                    this.remoteHost.getOs().write(byArray, 0, n);
                    Thread.sleep(2000L);
                    throw new Exception("Client password not matching.");
                }
            }
        }
    }
}

