/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import phex.BaseFrame;
import phex.ServiceManager;
import phex.config.Cfg;
import phex.host.HostManager;
import phex.utils.IPUtils;

public class DlgConfigInvalid
extends JDialog
implements KeyListener {
    private BaseFrame mFrame;
    private Vector mInvalidHosts;
    private boolean mCancel;
    private JTextField mInvalidText;
    private DefaultListModel mHostModel;
    private JList mHostList;

    public DlgConfigInvalid(BaseFrame baseFrame, String string, Vector vector) {
        super((Frame)baseFrame, true);
        this.mFrame = baseFrame;
        this.mInvalidHosts = new Vector();
        this.setTitle("Invalid Hosts");
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        jPanel.add("Center", new JLabel("Invalid hosts will not go into the host catcher."));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 6, 20), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.mInvalidText = new JTextField(string, 20);
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new AddActionListener());
        jPanel4.add("Center", this.mInvalidText);
        jPanel4.add("East", jButton);
        jPanel3.add("North", new JLabel("Invalid Host:"));
        jPanel3.add("Center", jPanel4);
        jPanel3.add("South", new JLabel("  "));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new FlowLayout());
        JButton jButton2 = new JButton("Remove");
        JButton jButton3 = new JButton("Reset To Defaults");
        jButton2.addActionListener(new RemoveActionListener());
        jButton3.addActionListener(new DefaultsActionListener());
        jPanel6.add(jButton2);
        jPanel6.add(jButton3);
        this.mHostModel = new DefaultListModel();
        this.mHostList = new JList(this.mHostModel);
        jPanel5.add("North", new JLabel("Invalid Hosts:"));
        jPanel5.add("Center", new JScrollPane(this.mHostList));
        jPanel5.add("South", jPanel6);
        jPanel2.add("North", jPanel3);
        jPanel2.add("Center", jPanel5);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", jPanel2);
        JPanel jPanel7 = new JPanel(new FlowLayout());
        JButton jButton4 = new JButton("OK");
        JButton jButton5 = new JButton("Cancel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("Cancel")) {
                    if (!DlgConfigInvalid.this.doOk()) {
                        return;
                    }
                } else {
                    DlgConfigInvalid.this.mCancel = true;
                }
                ((Component)DlgConfigInvalid.this).setVisible(false);
            }
        };
        jButton4.addActionListener(actionListener);
        jButton4.setMnemonic('O');
        jButton5.addActionListener(actionListener);
        jButton5.setMnemonic('C');
        jPanel7.add(jButton4);
        jPanel7.add(jButton5);
        this.getContentPane().add("South", jPanel7);
        this.addKeyListener(this);
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            String string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(stringArray[0]))).append(".").append(stringArray[1]).append(".").append(stringArray[2]).append(".").append(stringArray[3])));
            this.mHostModel.addElement(string2);
        }
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    public Vector getInvalidHosts() {
        return this.mInvalidHosts;
    }

    public boolean getCancel() {
        return this.mCancel;
    }

    private boolean doOk() {
        for (int i = 0; i < this.mHostModel.size(); ++i) {
            this.mInvalidHosts.addElement(IPUtils.splitIP2Parts((String)this.mHostModel.elementAt(i)));
        }
        this.mCancel = false;
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.mCancel = true;
            ((Component)this).setVisible(false);
        } else if (keyEvent.getKeyCode() == 10) {
            // empty if block
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DlgConfigInvalid.this.mInvalidText.getText().trim();
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String[] stringArray = new String[4];
                stringArray[0] = stringTokenizer.nextToken();
                if (!(stringArray[0].equals("*") || Integer.parseInt(stringArray[0]) >= 0 && Integer.parseInt(stringArray[0]) < 256)) {
                    throw new Exception();
                }
                stringArray[1] = stringTokenizer.nextToken();
                if (!(stringArray[1].equals("*") || Integer.parseInt(stringArray[1]) >= 0 && Integer.parseInt(stringArray[1]) < 256)) {
                    throw new Exception();
                }
                stringArray[2] = stringTokenizer.nextToken();
                if (!(stringArray[2].equals("*") || Integer.parseInt(stringArray[2]) >= 0 && Integer.parseInt(stringArray[2]) < 256)) {
                    throw new Exception();
                }
                stringArray[3] = stringTokenizer.nextToken();
                if (!(stringArray[3].equals("*") || Integer.parseInt(stringArray[3]) >= 0 && Integer.parseInt(stringArray[3]) < 256)) {
                    throw new Exception();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    throw new Exception();
                }
                for (int i = 0; i < DlgConfigInvalid.this.mHostModel.size(); ++i) {
                    if (!string.equals(DlgConfigInvalid.this.mHostModel.elementAt(i))) continue;
                    JOptionPane.showMessageDialog(DlgConfigInvalid.this.mFrame, String.valueOf(String.valueOf(new StringBuffer("'").append(string).append("' is already in the list."))), "Duplicate Address", 0);
                    DlgConfigInvalid.this.mInvalidText.requestFocus();
                    return;
                }
                DlgConfigInvalid.this.mHostModel.addElement(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(DlgConfigInvalid.this.mFrame, String.valueOf(String.valueOf(new StringBuffer("'").append(string).append("' is not a valid IP address."))), "Invalid Host Address", 0);
                DlgConfigInvalid.this.mInvalidText.requestFocus();
            }
        }
    }

    private class DefaultsActionListener
    implements ActionListener {
        private DefaultsActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HostManager hostManager = ServiceManager.getHostManager();
            Vector vector = Cfg.getDefaultInvalidHosts();
            DlgConfigInvalid.this.mHostModel.removeAllElements();
            for (int i = 0; i < vector.size(); ++i) {
                String[] stringArray = (String[])vector.elementAt(i);
                String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(stringArray[0]))).append(".").append(stringArray[1]).append(".").append(stringArray[2]).append(".").append(stringArray[3])));
                DlgConfigInvalid.this.mHostModel.addElement(string);
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DlgConfigInvalid.this.mHostList.getSelectedIndices();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                DlgConfigInvalid.this.mHostModel.removeElementAt(nArray[i]);
            }
            DlgConfigInvalid.this.mHostList.clearSelection();
        }
    }
}

