/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import phex.GUID;
import phex.ServiceManager;
import phex.common.FileHandlingException;
import phex.common.TransferDataProvider;
import phex.download.DownloadManager;
import phex.download.DownloadWorker;
import phex.download.RemoteFile;
import phex.event.DownloadCandidatesChangeListener;
import phex.query.ResearchSetting;
import phex.utils.StrUtil;
import phex.xml.XMLDownloadFile;
import phex.xml.XMLRemoteFile;

public class DownloadFile
implements Serializable,
TransferDataProvider {
    public static final int sQueued = 1;
    public static final int sDownloading = 2;
    public static final int sNoCandidates = 3;
    public static final int sCompleted = 4;
    public static final int sError = 5;
    public static final int HOST_BUSY = 6;
    public static final int sStopping = 7;
    public static final int sStopped = 8;
    public static final int sRemoved = 9;
    public static final int sConnecting = 10;
    public static final int sRequestPushTransfer = 11;
    public static final int sErrorMaxRetry = 12;
    public static final int sRetryWait = 13;
    private String mFilename;
    private long mFileSize;
    private String mShortname;
    private ArrayList mRemoteCandidates;
    private int mCurrCandidate;
    private int mStatus = 1;
    private String mStatusText = "";
    private long mStatusTime = 0L;
    private String mLog = "";
    private int mStartSize = 0;
    private long mTransferredSize = 0L;
    private DownloadWorker mDownloadWorker = null;
    private int mFileOffset = 0;
    private String mRemoteAppName = null;
    private DownloadManager mDownloadMgr;
    private int mRetryLast = 0;
    private long mNextRetryTime = 0L;
    private long lastSearchTime;
    private Integer currentProgress;
    private Integer retryCount;
    private int transferRate;
    private long transferRateTimestamp;
    private long startTime;
    private long stopTime;
    private int transferRateBytes;
    private String localFilename;
    private ResearchSetting researchSetting;
    private ArrayList listenerList = new ArrayList(2);

    public DownloadFile() {
        this(0L, null, null);
    }

    public DownloadFile(XMLDownloadFile xMLDownloadFile) {
        this(xMLDownloadFile.getFilesize(), xMLDownloadFile.getFilename(), xMLDownloadFile.getFilename());
        this.researchSetting.setSearchTerm(xMLDownloadFile.getSearchterm());
        if (xMLDownloadFile.getLocalFilename() != null) {
            this.localFilename = xMLDownloadFile.getLocalFilename();
        }
        this.mStatus = 3;
        if (xMLDownloadFile.getStatus() != null) {
            if (xMLDownloadFile.getStatus().equalsIgnoreCase(this.getStatusName(4))) {
                this.mStatus = 4;
            }
            if (xMLDownloadFile.getStatus().equalsIgnoreCase(this.getStatusName(8))) {
                this.mStatus = 8;
            }
        }
        Iterator iterator = xMLDownloadFile.createXMLRemoteFileIterator();
        while (iterator.hasNext()) {
            XMLRemoteFile xMLRemoteFile = (XMLRemoteFile)iterator.next();
            try {
                RemoteFile remoteFile = new RemoteFile(xMLRemoteFile);
                this.addRemoteCandidate(remoteFile);
            }
            catch (Exception exception) {}
        }
    }

    public DownloadFile(long l, String string, String string2) {
        this.mDownloadMgr = ServiceManager.getDownloadManager();
        ServiceManager.getTransferRateService().registerTransferDataProvider(this);
        this.mShortname = string2;
        this.mFilename = string;
        this.localFilename = string2;
        this.mFileSize = l;
        this.mCurrCandidate = -1;
        this.mStatus = 3;
        this.lastSearchTime = 0L;
        this.transferRate = 0;
        this.transferRateTimestamp = 0L;
        this.transferRateBytes = 0;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.mRemoteCandidates = new ArrayList();
        this.currentProgress = new Integer(0);
        this.retryCount = new Integer(0);
        this.researchSetting = new ResearchSetting(this);
        this.researchSetting.setSearchTerm(StrUtil.createNaturalSearchTerm(this.mShortname));
    }

    public DownloadFile(RemoteFile remoteFile) {
        this(remoteFile.getFileSize(), remoteFile.getFilename(), remoteFile.getFilename());
        this.mRemoteCandidates.add(remoteFile);
        this.mStatus = 1;
        this.mCurrCandidate = 0;
        int n = this.mFilename.lastIndexOf("/");
        if (n != -1) {
            this.mShortname = this.mFilename.substring(n + 1);
        } else {
            n = this.mFilename.lastIndexOf("\\");
            if (n != -1) {
                this.mShortname = this.mFilename.substring(n + 1);
            }
        }
        this.researchSetting.setSearchTerm(StrUtil.createNaturalSearchTerm(this.mShortname));
        this.localFilename = this.mShortname;
    }

    public DownloadFile(RemoteFile remoteFile, String string, String string2) {
        this(remoteFile);
        this.researchSetting.setSearchTerm(string);
        this.localFilename = string2;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public String getShortname() {
        return this.mShortname;
    }

    public long getTransferDataSize() {
        return this.mFileSize - (long)this.mStartSize;
    }

    public long getTotalFileSize() {
        return this.mFileSize;
    }

    public Integer getProgress() {
        int n;
        if (this.mStatus == 4) {
            n = 100;
        } else {
            long l = this.getTransferDataSize();
            n = (int)(this.getTransferredDataSize() * 100L / (l == 0L ? 1L : l));
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public int getCurrentCandidate() {
        return this.mCurrCandidate;
    }

    public boolean advanceCurrCandidate() {
        ++this.mCurrCandidate;
        if (this.mCurrCandidate >= this.mRemoteCandidates.size()) {
            this.mCurrCandidate = 0;
            return true;
        }
        return false;
    }

    public RemoteFile getCurrentRemoteFile() {
        ArrayList arrayList = this.mRemoteCandidates;
        synchronized (arrayList) {
            int n = this.mCurrCandidate;
            if (n < this.mRemoteCandidates.size() && n >= 0) {
                RemoteFile remoteFile = (RemoteFile)this.mRemoteCandidates.get(n);
                return remoteFile;
            }
            RemoteFile remoteFile = null;
            return remoteFile;
        }
    }

    public int getRemoteCandidatesCount() {
        return this.mRemoteCandidates.size();
    }

    public RemoteFile getRemoteCandidateAt(int n) {
        ArrayList arrayList = this.mRemoteCandidates;
        synchronized (arrayList) {
            if (n < 0 || n >= this.mRemoteCandidates.size()) {
                RemoteFile remoteFile = null;
                return remoteFile;
            }
            RemoteFile remoteFile = (RemoteFile)this.mRemoteCandidates.get(n);
            return remoteFile;
        }
    }

    public boolean addRemoteCandidate(RemoteFile remoteFile) {
        if (remoteFile.getFileSize() != this.mFileSize) {
            return false;
        }
        if (this.mRemoteCandidates.contains(remoteFile)) {
            return false;
        }
        int n = this.mRemoteCandidates.size();
        this.mRemoteCandidates.add(n, remoteFile);
        this.fireDownloadCandidateAdded(n);
        return true;
    }

    public void setCandidateCurrent(int n) {
        if (n < 0 || n >= this.mRemoteCandidates.size() || n == this.mCurrCandidate) {
            return;
        }
        this.mCurrCandidate = n;
        this.fireDownloadCandidateChanged(n);
    }

    public void removeAllRemoteCandidates() {
        ArrayList arrayList = this.mRemoteCandidates;
        synchronized (arrayList) {
            for (int i = this.mRemoteCandidates.size() - 1; i >= 0; --i) {
                this.removeRemoteCandidate(i);
            }
        }
    }

    public void removeRemoteCandidate(int n) {
        ArrayList arrayList = this.mRemoteCandidates;
        synchronized (arrayList) {
            if (n < 0 || n >= this.mRemoteCandidates.size()) {
                return;
            }
            this.appendLog("Removing Candidate: ".concat(String.valueOf(String.valueOf(this.getRemoteCandidateAt(n).getRemoteHost()))));
            this.mRemoteCandidates.remove(n);
            this.fireDownloadCandidateRemoved(n);
            if (this.mCurrCandidate >= this.mRemoteCandidates.size()) {
                if (this.mRemoteCandidates.size() == 0) {
                    this.mCurrCandidate = -1;
                    this.mStatus = 3;
                } else {
                    this.mCurrCandidate = this.mRemoteCandidates.size() - 1;
                    this.fireDownloadCandidateChanged(this.mCurrCandidate);
                }
            }
        }
    }

    public void removeCurrentCandidate() {
        if (this.mCurrCandidate >= 0) {
            this.removeRemoteCandidate(this.mCurrCandidate);
        }
    }

    public String getSearchTerm() {
        return this.researchSetting.getSearchTerm();
    }

    public void setSearchTerm(String string) {
        this.researchSetting.setSearchTerm(string);
    }

    public void stopSearchForCandidates() {
        this.researchSetting.stopSearch();
    }

    public void startSearchForCandidates() {
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    public boolean isSearchRunning() {
        return this.researchSetting.isSearchRunning();
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public String getRangeHeader(int n) {
        if (n == 0) {
            return "";
        }
        return String.valueOf(String.valueOf(new StringBuffer("Range: bytes=").append(n).append("-\r\n")));
    }

    public int getStatus() {
        return this.mStatus;
    }

    public short getDataTransferStatus() {
        switch (this.mStatus) {
            case 2: {
                return 10;
            }
            case 5: {
                return 13;
            }
            case 4: {
                return 12;
            }
        }
        return 11;
    }

    public String getStatusName() {
        return this.getStatusName(this.mStatus);
    }

    public String getStatusName(int n) {
        switch (n) {
            case 1: {
                return "queued...";
            }
            case 2: {
                return "downloading...";
            }
            case 3: {
                return "no candidates...";
            }
            case 4: {
                return "COMPLETED";
            }
            case 5: {
                return this.mStatusText;
            }
            case 6: {
                return "Host is busy.";
            }
            case 7: {
                return "stopping...";
            }
            case 8: {
                return "STOPPED";
            }
            case 10: {
                return "connecting...";
            }
            case 11: {
                return "requesting push transfer...";
            }
            case 12: {
                return "Error: retried too many times.";
            }
            case 13: {
                int n2 = (int)((this.mNextRetryTime - System.currentTimeMillis()) / (long)1000);
                return String.valueOf(String.valueOf(new StringBuffer("waiting for ").append(n2).append(" seconds...")));
            }
        }
        return String.valueOf(String.valueOf(new StringBuffer("Error: unknown status ( ").append(n).append(" )")));
    }

    public void setStatus(int n) {
        this.setStatus(n, "");
    }

    public void setStatus(int n, String string) {
        this.mStatus = n;
        this.mStatusText = string;
        this.mStatusTime = System.currentTimeMillis();
        this.mDownloadMgr.fireDownloadFileChanged(this);
    }

    public boolean isErrorStatusExpired() {
        return (this.mStatus == 5 || this.mStatus == 6) && System.currentTimeMillis() - this.mStatusTime > (long)5000;
    }

    public String getRemoteAppName() {
        return this.mRemoteAppName;
    }

    public void setRemoteAppName(String string) {
        this.mRemoteAppName = string;
        this.mDownloadMgr.fireDownloadFileChanged(this);
    }

    public void setLog(String string) {
        this.mLog = string;
    }

    public void appendLog(String string) {
        this.mLog = this.mLog != null ? String.valueOf(String.valueOf(this.mLog)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat("\n")))) : String.valueOf(String.valueOf(string)).concat("\n");
        if (this.mLog.length() > 4096) {
            this.mLog = this.mLog.substring(2048);
        }
    }

    public String getLog() {
        return this.mLog;
    }

    public void setStartSize(int n) {
        this.mStartSize = n;
        this.mTransferredSize = 0L;
    }

    public void setStartingTime(long l) {
        this.transferRateTimestamp = l;
        this.startTime = l;
        this.stopTime = 0L;
    }

    public void setStoppingTime(long l) {
        if (this.stopTime == (long)0) {
            this.stopTime = l;
        }
    }

    public long getTransferredDataSize() {
        return this.mTransferredSize;
    }

    public long getTransferTimeInSeconds() {
        if (this.stopTime != (long)0) {
            return (this.stopTime - this.startTime) / (long)1000;
        }
        return (System.currentTimeMillis() - this.startTime) / (long)1000;
    }

    public void setTransferredDataSize(long l) {
        long l2 = l - this.mTransferredSize;
        this.transferRateBytes = (int)((long)this.transferRateBytes + l2);
        this.mTransferredSize = l;
        this.mDownloadMgr.fireDownloadFileChanged(this);
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getDataTransferRate() {
        if (this.transferRateTimestamp != (long)0) {
            double d = (System.currentTimeMillis() - this.transferRateTimestamp) / (long)1000;
            if (this.transferRateBytes > 0 || d > 1.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public Integer getRetryCountObject() {
        return this.retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int n) {
        if (n != this.retryCount) {
            this.retryCount = new Integer(n);
            this.mDownloadMgr.fireDownloadFileChanged(this);
        }
    }

    public int getRetryLast() {
        return this.mRetryLast;
    }

    public void setRetryLast(int n) {
        this.mRetryLast = n;
    }

    public long getNextRetryTime() {
        return this.mNextRetryTime;
    }

    public void setNextRetryTime(long l) {
        this.mNextRetryTime = l;
    }

    public DownloadWorker getDownloadWorker() {
        return this.mDownloadWorker;
    }

    public void setDownloadWorker(DownloadWorker downloadWorker) {
        this.mDownloadWorker = downloadWorker;
    }

    public boolean isDownloadInProgress() {
        return this.mDownloadWorker != null;
    }

    public boolean isDownloadCompleted() {
        return this.mStatus == 4;
    }

    public boolean isDownloadStopped() {
        return this.mStatus == 8;
    }

    public String getLocalFilename() {
        return this.localFilename;
    }

    public void setLocalFilename(String string, boolean bl) throws FileHandlingException {
        if (bl && !string.equals(this.localFilename)) {
            if (this.mDownloadMgr.isNewLocalFilenameUsed(this, string)) {
                throw new FileHandlingException(1);
            }
            DownloadFile.renameLocalFile(this.localFilename, string);
        }
        this.localFilename = string;
    }

    private static void renameLocalFile(String string, String string2) throws FileHandlingException {
        File file = new File(DownloadFile.getFullLocalFilename(string));
        File file2 = new File(DownloadFile.getFullLocalFilename(string2));
        File file3 = new File(DownloadFile.getDownloadFileName(string));
        File file4 = new File(DownloadFile.getDownloadFileName(string2));
        if (file2.exists() || file4.exists()) {
            throw new FileHandlingException(1);
        }
        if (file.exists() && !file.renameTo(file2)) {
            throw new FileHandlingException(0);
        }
        if (file3.exists() && !file3.renameTo(file4)) {
            throw new FileHandlingException(0);
        }
    }

    public String getFullLocalFilename() {
        return DownloadFile.getFullLocalFilename(this.localFilename);
    }

    private static String getFullLocalFilename(String string) {
        String string2 = ServiceManager.sCfg.mDownloadDir;
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(File.separator).append(StrUtil.convertToLocalSystemFilename(string))));
    }

    private static String getDownloadFileName(String string) {
        return String.valueOf(String.valueOf(DownloadFile.getFullLocalFilename(string))).concat(".dl");
    }

    public String getDownloadName() {
        return String.valueOf(String.valueOf(this.getFullLocalFilename())).concat(".dl");
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mFilename))).append("(").append(this.mFileSize).append(")")));
    }

    public XMLDownloadFile createXMLDownloadFile() {
        XMLDownloadFile xMLDownloadFile = new XMLDownloadFile();
        xMLDownloadFile.setFilename(this.mFilename);
        xMLDownloadFile.setFilesize(this.mFileSize);
        xMLDownloadFile.setSearchterm(this.researchSetting.getSearchTerm());
        xMLDownloadFile.setLocalFilename(this.localFilename);
        xMLDownloadFile.setStatus(this.getStatusName());
        Iterator iterator = ((AbstractList)this.mRemoteCandidates).iterator();
        while (iterator.hasNext()) {
            RemoteFile remoteFile = (RemoteFile)iterator.next();
            XMLRemoteFile xMLRemoteFile = remoteFile.createXMLRemoteFile();
            xMLDownloadFile.addXMLRemoteFile(xMLRemoteFile);
        }
        return xMLDownloadFile;
    }

    public void readFromOIS(DataInputStream dataInputStream, boolean bl) throws ClassNotFoundException, IOException {
        this.mDownloadMgr = ServiceManager.getDownloadManager();
        if (bl) {
            dataInputStream.skipBytes(536);
        } else {
            dataInputStream.skipBytes(5);
        }
        byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
        ServiceManager.log(String.valueOf(String.valueOf(new StringBuffer("Reading DownloadFile after: ").append(byArray[0]).append(" ").append(byArray[1]).append(" ").append(byArray[2]).append(" ").append(byArray[3]))));
        if (byArray[2] == 122) {
            ServiceManager.log("found long entry exception");
            dataInputStream.skipBytes(3);
        }
        int n = dataInputStream.readInt();
        ServiceManager.log("Reading DownloadFile Version: ".concat(String.valueOf(String.valueOf(n))));
        switch (n) {
            case 1: {
                this.deserialize1(dataInputStream, bl);
                break;
            }
            default: {
                throw new IOException("Fail to deserialize datafile.  Unknown verison.");
            }
        }
    }

    private void deserialize1(DataInputStream dataInputStream, boolean bl) throws ClassNotFoundException, IOException {
        this.mFilename = dataInputStream.readUTF();
        ServiceManager.log("Reading DownloadFile Item: ".concat(String.valueOf(String.valueOf(this.mFilename))));
        this.mFileSize = dataInputStream.readLong();
        this.mShortname = dataInputStream.readUTF();
        this.researchSetting.setSearchTerm(dataInputStream.readUTF());
        this.mCurrCandidate = dataInputStream.readInt();
        if (bl) {
            dataInputStream.skipBytes(39);
        } else {
            dataInputStream.skipBytes(2);
        }
        byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
        ServiceManager.log(String.valueOf(String.valueOf(new StringBuffer("Reading DownloadFile after: ").append(byArray[0]).append(" ").append(byArray[1]).append(" ").append(byArray[2]).append(" ").append(byArray[3]))));
        int n = dataInputStream.readInt();
        ServiceManager.log("Reading DownloadFile RemoteFile Items: ".concat(String.valueOf(String.valueOf(n))));
        dataInputStream.skipBytes(5);
        for (int i = 0; i < n; ++i) {
            RemoteFile remoteFile = new RemoteFile(new GUID(), 0, this.mFilename, (int)this.mFileSize, "", 0);
            remoteFile.readFromOIS(dataInputStream, bl);
            bl = false;
            this.mRemoteCandidates.add(remoteFile);
        }
        dataInputStream.skipBytes(4);
        this.mStatus = dataInputStream.readInt();
        ServiceManager.log("Reading DownloadFile Status: ".concat(String.valueOf(String.valueOf(this.mStatus))));
        if (this.mStatus != 4) {
            this.mStatus = 1;
        }
    }

    public void addDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.add(downloadCandidatesChangeListener);
    }

    public void removeDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(downloadCandidatesChangeListener);
    }

    private void fireDownloadCandidateChanged(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = DownloadFile.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)objectArray[i];
                    downloadCandidatesChangeListener.downloadCandidateChanged(n);
                }
            }
        });
    }

    private void fireDownloadCandidateAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = DownloadFile.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)objectArray[i];
                    downloadCandidatesChangeListener.downloadCandidateAdded(n);
                }
            }
        });
    }

    private void fireDownloadCandidateRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = DownloadFile.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)objectArray[i];
                    downloadCandidatesChangeListener.downloadCandidateRemoved(n);
                }
            }
        });
    }

    public void fireDownloadCandidateChanged(RemoteFile remoteFile) {
        int n = this.mRemoteCandidates.indexOf(remoteFile);
        if (n >= 0) {
            this.fireDownloadCandidateChanged(n);
        }
    }
}

