/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import phex.DataChanger;
import phex.Res;
import phex.ServiceManager;
import phex.common.TransferRateService;
import phex.connection.ConnectionRequest;
import phex.download.DownloadFile;
import phex.download.DownloadWorker;
import phex.download.RemoteFile;
import phex.event.DownloadFilesChangeListener;
import phex.host.Host;
import phex.interfaces.IDataChangedListener;
import phex.msg.MsgHeader;
import phex.msg.MsgPushRequest;
import phex.utils.StrUtil;
import phex.xml.XMLBuilder;
import phex.xml.XMLDownloadFile;
import phex.xml.XMLDownloadList;
import phex.xml.XMLPhex;
import phex.xml.XMLPhexXMLCodec;

public class DownloadManager {
    private static final int MAX_RETRIES = 500;
    private Vector mDownloadList = new Vector();
    private Hashtable mPendingPushTransfer = new Hashtable();
    private int mWorkerCount = 0;
    private boolean mShutdownAllWorkers = false;
    private int mDownloadingCount = 0;
    private DataChanger mStatusChangedListener = new DataChanger();
    private static boolean lockDownloadFileList = false;
    private TransferRateService transferRateService;
    private ArrayList listenerList = new ArrayList(2);

    public DownloadManager() {
        this.transferRateService = ServiceManager.getTransferRateService();
    }

    public void addStatusChangedListener(IDataChangedListener iDataChangedListener) {
        this.mStatusChangedListener.addListener(iDataChangedListener);
    }

    public void init() {
        try {
            this.loadDownloadInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createEnoughWorkers();
    }

    public synchronized void createEnoughWorkers() {
        while (this.mWorkerCount < ServiceManager.sCfg.mMaxDownload) {
            ++this.mWorkerCount;
            new DownloadWorker(this);
        }
    }

    synchronized boolean isTooManyWorker() {
        if (this.mWorkerCount > ServiceManager.sCfg.mMaxDownload) {
            --this.mWorkerCount;
            return true;
        }
        return false;
    }

    private boolean tooManyDownloadPerIP(DownloadFile downloadFile) {
        int n = 0;
        try {
            RemoteFile remoteFile = downloadFile.getCurrentRemoteFile();
            if (remoteFile == null) {
                boolean bl = false;
                return bl;
            }
            String string = remoteFile.getRemoteHost();
            for (int i = 0; i < this.mDownloadList.size(); ++i) {
                DownloadFile downloadFile2;
                Vector vector = this.mDownloadList;
                synchronized (vector) {
                    if (i >= this.mDownloadList.size()) {
                        continue;
                    }
                    downloadFile2 = (DownloadFile)this.mDownloadList.elementAt(i);
                }
                RemoteFile remoteFile2 = downloadFile2.getCurrentRemoteFile();
                if (downloadFile2 == downloadFile || remoteFile2 == null || remoteFile2.getRemoteHost() == null || !remoteFile2.getRemoteHost().equals(string) || downloadFile2.getStatus() != 2 && downloadFile2.getStatus() != 10 && downloadFile2.getStatus() != 11) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Ignore out of range error in tooManyDownloadPerIP.");
            exception.printStackTrace();
            boolean bl = true;
            return bl;
        }
        return n >= ServiceManager.sCfg.mMaxDownloadPerIP;
    }

    public synchronized boolean addFileToDownload(RemoteFile remoteFile) {
        String string = StrUtil.createNaturalSearchTerm(remoteFile.getShortname());
        return this.addFileToDownload(remoteFile, string, remoteFile.getFilename());
    }

    public boolean isNewLocalFilenameUsed(DownloadFile downloadFile, String string) {
        for (int i = 0; i < this.mDownloadList.size(); ++i) {
            DownloadFile downloadFile2 = (DownloadFile)this.mDownloadList.elementAt(i);
            if (downloadFile != null && downloadFile2 == downloadFile || !downloadFile2.getLocalFilename().equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean addFileToDownload(RemoteFile remoteFile, String string, String string2) {
        for (int i = 0; i < this.mDownloadList.size(); ++i) {
            DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(i);
            if (!downloadFile.getLocalFilename().equals(string2)) continue;
            if (downloadFile.getTotalFileSize() == remoteFile.getFileSize()) {
                downloadFile.addRemoteCandidate(remoteFile);
                try {
                    this.saveDownloadInfo();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.notifyAll();
                return true;
            }
            return false;
        }
        this.createEnoughWorkers();
        DownloadFile downloadFile = new DownloadFile(remoteFile, string, string2);
        int n = this.mDownloadList.size();
        this.mDownloadList.insertElementAt(downloadFile, n);
        this.transferRateService.registerTransferDataProvider(downloadFile);
        this.fireDownloadFileAdded(n);
        downloadFile.setStatus(1);
        try {
            this.saveDownloadInfo();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.notifyAll();
        return true;
    }

    public synchronized DownloadFile getNextFileToDownload(DownloadWorker downloadWorker) {
        while (!this.mShutdownAllWorkers) {
            if (this.isTooManyWorker()) {
                return null;
            }
            for (int i = 0; i < this.mDownloadList.size(); ++i) {
                DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(i);
                if (downloadFile.getStatus() != 1) continue;
                if (downloadFile.getRemoteCandidatesCount() == 0) {
                    downloadFile.setStatus(3);
                    continue;
                }
                if (this.tooManyDownloadPerIP(downloadFile)) continue;
                downloadFile.setStatus(10);
                downloadFile.setDownloadWorker(downloadWorker);
                return downloadFile;
            }
            try {
                this.wait();
                continue;
            }
            catch (Exception exception) {
                ServiceManager.log("Problems writing datafile. ".concat(String.valueOf(String.valueOf(exception))));
                continue;
            }
            break;
        }
        return null;
    }

    public XMLDownloadList createXMLDownloadList() {
        XMLDownloadList xMLDownloadList = new XMLDownloadList();
        Enumeration enumeration = this.mDownloadList.elements();
        while (enumeration.hasMoreElements()) {
            DownloadFile downloadFile = (DownloadFile)enumeration.nextElement();
            xMLDownloadList.addXMLDownloadFile(downloadFile.createXMLDownloadFile());
        }
        return xMLDownloadList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveDownloadInfo() throws IOException {
        block3: {
            lockDownloadFileList = true;
            OutputStreamWriter outputStreamWriter = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(ServiceManager.getXMLDownloadSaveFilename());
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                XMLDownloadList xMLDownloadList = this.createXMLDownloadList();
                XMLPhex xMLPhex = new XMLPhex();
                xMLPhex.setDownloadList(xMLDownloadList);
                xMLPhex.setPhexVersion(Res.getStr("Program.Version"));
                XmlDocument xmlDocument = XMLPhexXMLCodec.encodeXML(xMLPhex);
                xmlDocument.write(outputStreamWriter, "UTF-8");
                Object var7_6 = null;
                if (outputStreamWriter == null) break block3;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                lockDownloadFileList = false;
                throw throwable;
            }
            outputStreamWriter.close();
        }
        lockDownloadFileList = false;
    }

    private void loadXMLDownloadInfo() {
        File file = new File(ServiceManager.getXMLDownloadSaveFilename());
        Document document = XMLBuilder.loadFromFile(file);
        XMLPhex xMLPhex = XMLPhexXMLCodec.decodeXML(document.getDocumentElement());
        XMLDownloadList xMLDownloadList = xMLPhex.getDownloadList();
        Iterator iterator = xMLDownloadList.createXMLDownloadFileIterator();
        while (iterator.hasNext()) {
            XMLDownloadFile xMLDownloadFile = (XMLDownloadFile)iterator.next();
            DownloadFile downloadFile = new DownloadFile(xMLDownloadFile);
            int n = this.mDownloadList.size();
            this.mDownloadList.insertElementAt(downloadFile, n);
            this.transferRateService.registerTransferDataProvider(downloadFile);
            this.fireDownloadFileAdded(n);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadDownloadInfo() {
        block19: {
            if (DownloadManager.lockDownloadFileList) {
                return;
            }
            var1_1 = new File(ServiceManager.getXMLDownloadSaveFilename());
            if (var1_1.exists()) {
                this.loadXMLDownloadInfo();
                return;
            }
            var2_2 = null;
            var3_3 = new FileInputStream(ServiceManager.getObjectDownloadSaveFilename());
            var2_2 = new DataInputStream(var3_3);
            var2_2.skipBytes(6);
            var4_6 = var2_2.readInt();
            ServiceManager.log("Reading DownloadList Version: ".concat(String.valueOf(String.valueOf(var4_6))));
            switch (var4_6) {
                case 1: {
                    this.deserialize1((DataInputStream)var2_2);
                    ** break;
                }
                default: {
                    throw new IOException("Fail to deserialize datafile.  Unknown verison.");
lbl22:
                    // 1 sources

                    break;
                }
            }
            var6_7 = null;
            try {
                if (var2_2 != null) {
                    var2_2.close();
                }
                break block19;
            }
            catch (IOException var7_11) {}
            break block19;
            {
                catch (FileNotFoundException var3_4) {
                    var6_8 = null;
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                        break block19;
                    }
                    catch (IOException var7_12) {}
                    break block19;
                }
                catch (Exception var3_5) {
                    var3_5.printStackTrace();
                    ServiceManager.log("Problems reading datafile. ".concat(String.valueOf(String.valueOf(var3_5))));
                    var6_9 = null;
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                        break block19;
                    }
                    catch (IOException var7_13) {}
                }
            }
            catch (Throwable var5_15) {
                var6_10 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                catch (IOException var7_14) {
                    // empty catch block
                }
                throw var5_15;
            }
        }
    }

    private void deserialize1(DataInputStream dataInputStream) throws ClassNotFoundException, IOException {
        dataInputStream.skipBytes(108);
        int n = dataInputStream.readInt();
        ServiceManager.log("Reading DownloadList Size: ".concat(String.valueOf(String.valueOf(n))));
        this.mDownloadList = new Vector(n);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            ServiceManager.log("Reading DownloadFile Item Nr: ".concat(String.valueOf(String.valueOf(i))));
            DownloadFile downloadFile = new DownloadFile();
            downloadFile.readFromOIS(dataInputStream, bl);
            bl = false;
            int n2 = this.mDownloadList.size();
            this.mDownloadList.insertElementAt(downloadFile, n2);
            this.transferRateService.registerTransferDataProvider(downloadFile);
            this.fireDownloadFileAdded(n2);
        }
    }

    public synchronized void incDownloadingCount() {
        ++this.mDownloadingCount;
    }

    public synchronized void decDownloadingCount() {
        --this.mDownloadingCount;
    }

    public int getDownloadingCount() {
        return this.mDownloadingCount;
    }

    public synchronized void stopDownload(int n) {
        if (n >= this.mDownloadList.size()) {
            return;
        }
        DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(n);
        this.stopDownload(downloadFile);
    }

    public synchronized void stopDownload(DownloadFile downloadFile) {
        if (downloadFile.isDownloadInProgress()) {
            downloadFile.setStatus(7);
            downloadFile.setStoppingTime(System.currentTimeMillis());
            downloadFile.getDownloadWorker().stopDownload();
        } else {
            downloadFile.setStatus(8);
        }
    }

    public synchronized void resumeDownload(int n) {
        if (n >= this.mDownloadList.size()) {
            return;
        }
        DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(n);
        this.resumeDownload(downloadFile);
    }

    public synchronized void resumeDownload(DownloadFile downloadFile) {
        if (downloadFile.getStatus() == 8 || downloadFile.getStatus() == 5) {
            if (downloadFile.getRemoteCandidatesCount() == 0) {
                downloadFile.setStatus(3);
            } else {
                downloadFile.setStatus(1);
            }
            downloadFile.setRetryCount(1);
            this.notifyAll();
        }
    }

    public synchronized void removeDownload(int n) {
        if (n >= this.mDownloadList.size()) {
            return;
        }
        DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(n);
        this.mDownloadList.removeElementAt(n);
        this.transferRateService.unregisterTransferDataProvider(downloadFile);
        this.fireDownloadFileRemoved(n);
        DownloadWorker downloadWorker = downloadFile.getDownloadWorker();
        if (downloadWorker != null) {
            downloadFile.setStatus(9);
            downloadWorker.stopDownload();
        } else {
            File file = new File(downloadFile.getDownloadName());
            if (file.exists()) {
                file.delete();
            }
        }
        try {
            this.saveDownloadInfo();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void removeCompleted() {
        int n = 0;
        while (n < this.mDownloadList.size()) {
            DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(n);
            if (downloadFile.getStatus() == 4) {
                this.mDownloadList.removeElementAt(n);
                this.transferRateService.unregisterTransferDataProvider(downloadFile);
                this.fireDownloadFileRemoved(n);
                continue;
            }
            ++n;
        }
    }

    public DownloadFile getDownloadFileAt(int n) {
        Vector vector = this.mDownloadList;
        synchronized (vector) {
            if (n < 0 || n >= this.mDownloadList.size()) {
                DownloadFile downloadFile = null;
                return downloadFile;
            }
            DownloadFile downloadFile = (DownloadFile)this.mDownloadList.get(n);
            return downloadFile;
        }
    }

    public int getDownloadCount() {
        return this.mDownloadList.size();
    }

    public synchronized boolean notifyReadPushedFile(ConnectionRequest connectionRequest, Host host) {
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(connectionRequest.getHeader("FileRef")))).append(":").append(connectionRequest.getHeader("ClientID"))));
        if (this.mPendingPushTransfer.get(string) != null) {
            this.mPendingPushTransfer.put(string, host);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized Host pushRequestTransfer(Host host, DownloadFile downloadFile) throws Exception {
        downloadFile.setStatus(11);
        RemoteFile remoteFile = downloadFile.getCurrentRemoteFile();
        MsgPushRequest msgPushRequest = new MsgPushRequest(new MsgHeader());
        msgPushRequest.setClientID(remoteFile.getRemoteClientID());
        msgPushRequest.setFileIndex(remoteFile.getFileIndex());
        msgPushRequest.setRequestPort((short)ServiceManager.getListener().getLocalAddress().getPort());
        msgPushRequest.setRequestHost(ServiceManager.getListener().getLocalAddress().getHostName());
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(msgPushRequest.getFileIndex()))).append(":").append(msgPushRequest.getClientID().toHexString())));
        this.mPendingPushTransfer.put(string, "none");
        downloadFile.appendLog(string);
        Host host2 = ServiceManager.getMsgManager().getPushRouting(msgPushRequest.getClientID());
        if (host2 == null) {
            downloadFile.removeCurrentCandidate();
            throw new IOException("Routing table has no info to route back to sharing host.");
        }
        ServiceManager.getSendManager().queueMsgToSend(host2, msgPushRequest, false);
        downloadFile.appendLog("Wait for connection from sharing host");
        long l = System.currentTimeMillis();
        while (this.mPendingPushTransfer.get(string) == "none") {
            long l2 = System.currentTimeMillis() - l;
            long l3 = (long)ServiceManager.sCfg.mPushTransferTimeout - l2;
            if (l3 < (long)0) {
                this.mPendingPushTransfer.remove(string);
                downloadFile.appendLog("Time out waiting for connection from sharing host");
                return null;
            }
            try {
                this.wait(l3 + (long)1000);
            }
            catch (Exception exception) {}
        }
        downloadFile.appendLog("Sharing host made connection to me");
        return (Host)this.mPendingPushTransfer.remove(string);
    }

    public void retryDownloads() {
        int n = 0;
        for (int i = 0; i < this.mDownloadList.size(); ++i) {
            DownloadFile downloadFile = (DownloadFile)this.mDownloadList.elementAt(i);
            int n2 = downloadFile.getStatus();
            if (n2 == 5 || n2 == 6) {
                if (!downloadFile.isErrorStatusExpired()) continue;
                ++n;
                if (downloadFile.advanceCurrCandidate()) {
                    downloadFile.setStatus(13);
                    downloadFile.setNextRetryTime(System.currentTimeMillis() + (long)ServiceManager.sCfg.mDownloadRetryWait);
                    continue;
                }
                downloadFile.setRetryCount(downloadFile.getRetryCount() + 1);
                downloadFile.setStatus(1);
                continue;
            }
            if (n2 == 13) {
                if (System.currentTimeMillis() <= downloadFile.getNextRetryTime()) continue;
                ++n;
                downloadFile.setRetryCount(downloadFile.getRetryCount() + 1);
                downloadFile.setStatus(1);
                continue;
            }
            if (n2 != 3 || downloadFile.getRemoteCandidatesCount() <= 0) continue;
            ++n;
            downloadFile.setStatus(1);
            downloadFile.advanceCurrCandidate();
        }
        if (n > 0) {
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                this.notifyAll();
            }
        }
    }

    public void addDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.add(downloadFilesChangeListener);
    }

    public void removeDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(downloadFilesChangeListener);
    }

    private void fireDownloadFileChanged(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = DownloadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileChanged(n);
                }
            }
        });
    }

    private void fireDownloadFileAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = DownloadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileAdded(n);
                }
            }
        });
    }

    private void fireDownloadFileRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = DownloadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileRemoved(n);
                }
            }
        });
    }

    public void fireDownloadFileChanged(DownloadFile downloadFile) {
        int n = this.mDownloadList.indexOf(downloadFile);
        if (n >= 0) {
            this.fireDownloadFileChanged(n);
        }
    }
}

