/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import phex.GUID;
import phex.ServiceManager;
import phex.xml.XMLRemoteFile;

public class RemoteFile
implements Serializable {
    private GUID mRemoteClientID;
    private int mFileIndex;
    private String mFilename;
    private String mShortname;
    private String mFileExt = null;
    private long mFileSize;
    private Long mFileSizeLong;
    private String mRemoteHost;
    private int mSpeed;
    private Integer mSpeedInt;
    private boolean isInDownloadQueue;
    private String localFilename;
    private String searchTerm;
    private Short score;

    private RemoteFile() {
    }

    public RemoteFile(XMLRemoteFile xMLRemoteFile) throws Exception {
        this(GUID.createFromHexString(xMLRemoteFile.getGuid()), xMLRemoteFile.getFileIndex(), xMLRemoteFile.getFileName(), xMLRemoteFile.getFileSize(), xMLRemoteFile.getRemoteHost(), xMLRemoteFile.getSpeed());
    }

    public RemoteFile(GUID gUID, int n, String string, long l, String string2, int n2) {
        this(gUID, n, string, l, string2, n2, -1);
    }

    public RemoteFile(GUID gUID, int n, String string, long l, String string2, int n2, short s) {
        this.mRemoteClientID = gUID;
        this.mFileIndex = n;
        this.mShortname = this.mFilename = string;
        this.mFileSize = l;
        this.mFileSizeLong = new Long(l);
        this.mRemoteHost = string2;
        this.mSpeed = n2;
        this.mSpeedInt = new Integer(n2);
        this.isInDownloadQueue = false;
        this.score = new Short(s);
        int n3 = this.mFilename.lastIndexOf("/");
        if (n3 != -1) {
            this.mShortname = this.mFilename.substring(n3 + 1);
        } else {
            n3 = this.mFilename.lastIndexOf("\\");
            if (n3 != -1) {
                this.mShortname = this.mFilename.substring(n3 + 1);
            }
        }
    }

    public RemoteFile(RemoteFile remoteFile) {
        this.copy(remoteFile);
    }

    public void copy(RemoteFile remoteFile) {
        this.mRemoteClientID = remoteFile.getRemoteClientID();
        this.mFileIndex = remoteFile.getFileIndex();
        this.mFilename = remoteFile.getFilename();
        this.mShortname = remoteFile.getShortname();
        this.mFileSize = remoteFile.getFileSize();
        this.mFileSizeLong = remoteFile.getFileSizeLong();
        this.mRemoteHost = remoteFile.getRemoteHost();
        this.mSpeed = remoteFile.getSpeed();
        this.mSpeedInt = remoteFile.getSpeedInt();
        this.isInDownloadQueue = remoteFile.isInDownloadQueue();
        this.score = remoteFile.getScore();
    }

    public GUID getRemoteClientID() {
        return this.mRemoteClientID;
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public String getShortname() {
        return this.mShortname;
    }

    public String getFileExt() {
        if (this.mFileExt != null) {
            return this.mFileExt;
        }
        int n = this.mFilename.lastIndexOf(".");
        this.mFileExt = n > -1 ? this.mFilename.substring(n + 1, this.mFilename.length()) : "";
        return this.mFileExt;
    }

    public long getFileSize() {
        return this.mFileSize;
    }

    public Long getFileSizeLong() {
        return this.mFileSizeLong;
    }

    public String getRemoteHost() {
        return this.mRemoteHost;
    }

    public int getSpeed() {
        return this.mSpeed;
    }

    public Integer getSpeedInt() {
        return this.mSpeedInt;
    }

    public boolean isInDownloadQueue() {
        return this.isInDownloadQueue;
    }

    public void setInDownloadQueue(boolean bl) {
        this.isInDownloadQueue = bl;
    }

    public String getURL() {
        return String.valueOf(String.valueOf(new StringBuffer("http://").append(this.mRemoteHost).append("/get/").append(this.mFileIndex).append("/").append(this.mFilename)));
    }

    public String getGetRequest() {
        return String.valueOf(String.valueOf(new StringBuffer("GET /get/").append(this.mFileIndex).append("/").append(this.mFilename).append(" HTTP/1.0\r\n")));
    }

    public Short getScore() {
        return this.score;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)object;
        return this.mRemoteHost.equals(remoteFile.mRemoteHost) && this.mFileIndex == remoteFile.mFileIndex;
    }

    public XMLRemoteFile createXMLRemoteFile() {
        XMLRemoteFile xMLRemoteFile = new XMLRemoteFile();
        xMLRemoteFile.setFileIndex(this.mFileIndex);
        xMLRemoteFile.setGuid(this.mRemoteClientID.toHexString());
        xMLRemoteFile.setRemoteHost(this.mRemoteHost);
        xMLRemoteFile.setSpeed(this.mSpeed);
        xMLRemoteFile.setFileName(this.mFilename);
        xMLRemoteFile.setFileSize(this.mFileSize);
        return xMLRemoteFile;
    }

    public void readFromOIS(DataInputStream dataInputStream, boolean bl) throws ClassNotFoundException, IOException {
        if (bl) {
            dataInputStream.skipBytes(244);
        } else {
            dataInputStream.skipBytes(5);
        }
        byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
        ServiceManager.log(String.valueOf(String.valueOf(new StringBuffer("Reading RemoteFile after: ").append(byArray[0]).append(" ").append(byArray[1]).append(" ").append(byArray[2]).append(" ").append(byArray[3]))));
        int n = dataInputStream.readInt();
        ServiceManager.log("Reading RemoteFile Version: ".concat(String.valueOf(String.valueOf(n))));
        switch (n) {
            case 1: {
                this.deserialize1(dataInputStream, bl);
                break;
            }
            default: {
                throw new IOException("Fail to deserialize remotefile.  Unknown verison.");
            }
        }
    }

    private void deserialize1(DataInputStream dataInputStream, boolean bl) throws ClassNotFoundException, IOException {
        this.mRemoteClientID = new GUID();
        this.mRemoteClientID.readFromOIS(dataInputStream, bl);
        byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
        if (byArray[1] == 122) {
            ServiceManager.log("found long entry exception");
            dataInputStream.skipBytes(3);
        }
        this.mFileIndex = dataInputStream.readInt();
        ServiceManager.log("Reading RemoteFile Index: ".concat(String.valueOf(String.valueOf(this.mFileIndex))));
        this.mFilename = dataInputStream.readUTF();
        ServiceManager.log("Reading RemoteFile Item: ".concat(String.valueOf(String.valueOf(this.mFilename))));
        this.mShortname = dataInputStream.readUTF();
        ServiceManager.log("Reading RemoteFile Shortname: ".concat(String.valueOf(String.valueOf(this.mShortname))));
        this.mFileSize = dataInputStream.readInt();
        ServiceManager.log("Reading RemoteFile FileSize: ".concat(String.valueOf(String.valueOf(this.mFileSize))));
        if (bl) {
            dataInputStream.skipBytes(79);
        } else if (dataInputStream.readByte() == 113) {
            ServiceManager.log("found known FileSize: skipping");
            dataInputStream.skipBytes(6);
        } else {
            dataInputStream.skipBytes(11);
        }
        this.mRemoteHost = dataInputStream.readUTF();
        ServiceManager.log("Reading RemoteFile RemoteHost: ".concat(String.valueOf(String.valueOf(this.mRemoteHost))));
        this.mSpeed = dataInputStream.readInt();
        ServiceManager.log("Reading RemoteFile Speed: ".concat(String.valueOf(String.valueOf(this.mSpeed))));
        this.mSpeedInt = new Integer(this.mSpeed);
        if (dataInputStream.readByte() == 113) {
            ServiceManager.log("found known Speed: skipping");
            dataInputStream.skipBytes(4);
        } else {
            dataInputStream.skipBytes(9);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("  ");
        stringBuffer.append(this.mRemoteHost);
        stringBuffer.append("  ");
        stringBuffer.append(this.mFilename);
        stringBuffer.append("  ");
        stringBuffer.append(this.mFileIndex);
        return stringBuffer.toString();
    }
}

