/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import phex.ServiceManager;
import phex.utils.Localizer;

public final class GUIUtils {
    private GUIUtils() {
    }

    public static void adjustTableProgresssBarHeight(JTable jTable) {
        Font font = (Font)UIManager.getDefaults().get("ProgressBar.font");
        FontMetrics fontMetrics = ((Component)jTable).getFontMetrics(font);
        int n = fontMetrics.getHeight() + fontMetrics.getDescent();
        jTable.setRowHeight(n);
    }

    public static void setToolTipText(JComponent jComponent, String string) {
        if (ServiceManager.sCfg.mUIDisplayTooltip) {
            jComponent.setToolTipText(string);
        }
    }

    public static void fireTableChanged(JTable jTable, AbstractTableModel abstractTableModel) {
        int n = jTable.getSelectedRowCount();
        int[] nArray = jTable.getSelectedRows();
        abstractTableModel.fireTableDataChanged();
        if (n > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= jTable.getRowCount()) continue;
                jTable.addRowSelectionInterval(nArray[i], nArray[i]);
            }
        }
    }

    public static void showErrorMessage(String string) {
        GUIUtils.showErrorMessage(ServiceManager.getManager().getMainFrame(), string);
    }

    public static void showErrorMessage(String string, String string2) {
        GUIUtils.showErrorMessage(null, string, string2);
    }

    public static void showErrorMessage(Component component, String string) {
        GUIUtils.showErrorMessage(component, string, Localizer.getString("Error"));
    }

    public static void showErrorMessage(Component component, String string, String string2) {
        if (component == null) {
            component = ServiceManager.getManager().getMainFrame();
        }
        JOptionPane.showMessageDialog(component, string, string2, 0);
    }
}

