/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import phex.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.share.FileAdministration;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;

public class DirectoriesPane
extends OptionsSettingsPane {
    private static final String DIRECTORY_ERROR_KEY = "DirectoryErrorKey";
    private static final String DOWNLOAD_DIRECTORY_KEY = "DownloadDirectory";
    private static final String SHARE_DIRECTORIES_KEY = "ShareDirectories";
    private static final String DOWNLOAD_DIR_SHARED = "DownloadDirShared";
    private static final String NO_DIRECTORY_SHARED = "NoDirectoryShared";
    private static final String CANT_CREATE_DOWNLOAD_DIR = "CantCreateDownloadDir";
    private JTextField downloadDirectoryTF;
    private JList sharedDirectoryList;
    private JCheckBox shareSubDirectoriesChkBx;
    private JTextField includeFilesTF;
    private JTextField excludeFilesTF;

    public DirectoriesPane() {
        super("Directories");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("DownloadDirectorySettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(DOWNLOAD_DIRECTORY_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.downloadDirectoryTF = new JTextField(ServiceManager.sCfg.mDownloadDir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.downloadDirectoryTF, gridBagConstraints);
        JButton jButton = new JButton(Localizer.getString("SetDirectory"));
        jButton.addActionListener(new SetDownlodDirectoryListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("SharingDirectorySettings")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("SharedDirectories"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        FileAdministration fileAdministration = ServiceManager.getShareManager().getFileAdministration();
        Object[] objectArray = fileAdministration.getSharedDirectories();
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
        this.sharedDirectoryList = new JList(defaultListModel);
        this.sharedDirectoryList.setVisibleRowCount(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)new JScrollPane(this.sharedDirectoryList), gridBagConstraints);
        jButton = new JButton(Localizer.getString("Add"));
        jButton.addActionListener(new AddUploadDirectoryListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel3.add((Component)jButton, gridBagConstraints);
        jButton = new JButton(Localizer.getString("Remove"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DirectoriesPane.this.sharedDirectoryList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                DefaultListModel defaultListModel = (DefaultListModel)DirectoriesPane.this.sharedDirectoryList.getModel();
                defaultListModel.removeElementAt(n);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel3.add((Component)jButton, gridBagConstraints);
        this.shareSubDirectoriesChkBx = new JCheckBox(Localizer.getString("ShareSubDirectories"), ServiceManager.sCfg.mUploadScanRecursively);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this.shareSubDirectoriesChkBx, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("IncludeFiles"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.includeFilesTF = new JTextField(ServiceManager.sCfg.mUploadFileInclusions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.includeFilesTF, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("ExcludeFiles"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.excludeFilesTF = new JTextField(ServiceManager.sCfg.mUploadFileExclusions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.excludeFilesTF, gridBagConstraints);
    }

    public void checkInput(HashMap hashMap) {
        int n;
        String string = this.downloadDirectoryTF.getText();
        File file = new File(string);
        boolean bl = this.shareSubDirectoriesChkBx.isSelected();
        ListModel listModel = this.sharedDirectoryList.getModel();
        int n2 = listModel.getSize();
        if (n2 == 0) {
            hashMap.put(DIRECTORY_ERROR_KEY, NO_DIRECTORY_SHARED);
            this.setInputValid(hashMap, false);
            return;
        }
        File[] fileArray = new File[n2];
        for (n = 0; n < n2; ++n) {
            String string2 = (String)listModel.getElementAt(n);
            File file2 = new File(string2);
            boolean bl2 = file.equals(file2);
            if (bl && !bl2) {
                bl2 = this.isSubDirOf(file, file2);
            }
            if (bl2) {
                hashMap.put(DIRECTORY_ERROR_KEY, DOWNLOAD_DIR_SHARED);
                this.setInputValid(hashMap, false);
                return;
            }
            fileArray[n] = file2;
        }
        if (!(file.exists() && file.isDirectory() || (n = (int)(file.mkdirs() ? 1 : 0)) != 0)) {
            hashMap.put(DIRECTORY_ERROR_KEY, CANT_CREATE_DOWNLOAD_DIR);
            this.setInputValid(hashMap, false);
            return;
        }
        hashMap.put(DOWNLOAD_DIRECTORY_KEY, file);
        hashMap.put(SHARE_DIRECTORIES_KEY, fileArray);
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        Object v = hashMap.get(DIRECTORY_ERROR_KEY);
        if (v == null) {
            return;
        }
        if (v.equals(DOWNLOAD_DIR_SHARED)) {
            this.downloadDirectoryTF.requestFocus();
            this.downloadDirectoryTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString(DOWNLOAD_DIR_SHARED), Localizer.getString("DirectoryError"));
        } else if (v.equals(NO_DIRECTORY_SHARED)) {
            GUIUtils.showErrorMessage(Localizer.getString(NO_DIRECTORY_SHARED), Localizer.getString("DirectoryError"));
        } else if (v.equals(CANT_CREATE_DOWNLOAD_DIR)) {
            this.downloadDirectoryTF.requestFocus();
            this.downloadDirectoryTF.selectAll();
            Object[] objectArray = new String[]{this.downloadDirectoryTF.getText()};
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_DOWNLOAD_DIR, objectArray), Localizer.getString("DirectoryError"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        String string;
        String string2;
        File file = (File)hashMap.get(DOWNLOAD_DIRECTORY_KEY);
        String string3 = file.getAbsolutePath();
        if (!ServiceManager.sCfg.mDownloadDir.equals(string3)) {
            ServiceManager.sCfg.mDownloadDir = string3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        File[] fileArray = (File[])hashMap.get(SHARE_DIRECTORIES_KEY);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            stringBuffer.append(';');
        }
        if (!ServiceManager.sCfg.mUploadDir.equals(stringBuffer.toString())) {
            ServiceManager.sCfg.mUploadDir = stringBuffer.toString();
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
        if (!ServiceManager.sCfg.mUploadFileInclusions.equals(string2 = this.includeFilesTF.getText())) {
            ServiceManager.sCfg.mUploadFileInclusions = string2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
        if (!ServiceManager.sCfg.mUploadFileExclusions.equals(string = this.excludeFilesTF.getText())) {
            ServiceManager.sCfg.mUploadFileExclusions = string;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
    }

    private boolean isSubDirOf(File file, File file2) {
        if (!file.getAbsolutePath().startsWith(file2.getAbsolutePath())) {
            return false;
        }
        return this.isSubDirOfInternal(file, file2);
    }

    private boolean isSubDirOfInternal(File file, File file2) {
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        if (file3.equals(file2)) {
            return true;
        }
        return this.isSubDirOfInternal(file3, file2);
    }

    private class SetDownlodDirectoryListener
    implements ActionListener {
        private SetDownlodDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(DirectoriesPane.this.downloadDirectoryTF.getText()));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(Localizer.getString("SelectDownloadDirectory"));
            jFileChooser.setApproveButtonText(Localizer.getString("Select"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.downloadDirectoryTF.setText(string);
            }
        }
    }

    private class AddUploadDirectoryListener
    implements ActionListener {
        private AddUploadDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            DefaultListModel defaultListModel = (DefaultListModel)DirectoriesPane.this.sharedDirectoryList.getModel();
            if (defaultListModel.getSize() > 0) {
                String string = (String)defaultListModel.getElementAt(defaultListModel.getSize() - 1);
                jFileChooser.setSelectedFile(new File(string));
            }
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setDialogTitle(Localizer.getString("AddUploadDirectories"));
            jFileChooser.setApproveButtonText(Localizer.getString("Add"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("AddDirectoryMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    defaultListModel.addElement(fileArray[i].getAbsolutePath());
                }
            }
        }
    }
}

