/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import phex.BaseFrame;
import phex.ServiceManager;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.renderer.LAFListCellRenderer;
import phex.utils.Localizer;

public class GeneralUIPane
extends OptionsSettingsPane {
    private static final String INSTANCIATED_LAF_KEY = "InstanciatedLAF";
    private static final String LAF_ERROR_KEY = "LAFError";
    private static final String LAF_NOT_SUPPORTED = "LAFNotSupported";
    private static final String LAF_NOT_FOUND = "LAFNotFound";
    private static final String LAF_ACCESS_ERROR = "LAFAccessError";
    private static final String LAF_INSTANTIATION_ERROR = "LAFInstantiationError";
    private static final String[] STYLE_LIST = new String[]{"Plain", "Bold", "Italic"};
    private static final String[] SIZE_LIST;
    private JComboBox lafBox;
    private JComboBox menuFontCoBx;
    private JComboBox labelFontCoBx;
    private JComboBox contentFontCoBx;
    private JComboBox menuStyleCoBx;
    private JComboBox labelStyleCoBx;
    private JComboBox contentStyleCoBx;
    private JComboBox menuSizeCoBx;
    private JComboBox labelSizeCoBx;
    private JComboBox contentSizeCoBx;
    private JCheckBox displayTooltipChkbx;
    private JCheckBox showUpdateNotificationChkbx;

    public GeneralUIPane() {
        super("General");
    }

    public void checkInput(HashMap hashMap) {
        hashMap.remove(INSTANCIATED_LAF_KEY);
        hashMap.remove(LAF_ERROR_KEY);
        UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        try {
            Class<?> clazz = Class.forName(lookAndFeelInfo.getClassName());
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            if (!lookAndFeel.isSupportedLookAndFeel()) {
                hashMap.put(LAF_ERROR_KEY, LAF_NOT_SUPPORTED);
                this.setInputValid(hashMap, false);
                return;
            }
            hashMap.put(INSTANCIATED_LAF_KEY, lookAndFeel);
        }
        catch (ClassNotFoundException classNotFoundException) {
            hashMap.put(LAF_ERROR_KEY, LAF_NOT_FOUND);
            this.setInputValid(hashMap, false);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            hashMap.put(LAF_ERROR_KEY, LAF_ACCESS_ERROR);
            this.setInputValid(hashMap, false);
            return;
        }
        catch (InstantiationException instantiationException) {
            hashMap.put(LAF_ERROR_KEY, LAF_INSTANTIATION_ERROR);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        Object v = hashMap.get(LAF_ERROR_KEY);
        if (v != null) {
            JOptionPane.showMessageDialog(this, Localizer.getString((String)v), Localizer.getString(LAF_ERROR_KEY), 0);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        LookAndFeel lookAndFeel = (LookAndFeel)hashMap.get(INSTANCIATED_LAF_KEY);
        if (!ServiceManager.sCfg.mLFClassName.equals(lookAndFeel.getClass().getName())) {
            ServiceManager.sCfg.mLFClassName = lookAndFeel.getClass().getName();
            BaseFrame.setAllFramesLookAndFeel(lookAndFeel);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        String string = (String)this.menuFontCoBx.getSelectedItem();
        int n = this.menuStyleCoBx.getSelectedIndex();
        int n2 = Integer.parseInt((String)this.menuSizeCoBx.getSelectedItem());
        Font font = new Font(string, n, n2);
        string = (String)this.labelFontCoBx.getSelectedItem();
        n = this.labelStyleCoBx.getSelectedIndex();
        n2 = Integer.parseInt((String)this.labelSizeCoBx.getSelectedItem());
        Font font2 = new Font(string, n, n2);
        string = (String)this.contentFontCoBx.getSelectedItem();
        n = this.contentStyleCoBx.getSelectedIndex();
        n2 = Integer.parseInt((String)this.contentSizeCoBx.getSelectedItem());
        Font font3 = new Font(string, n, n2);
        if (!(ServiceManager.sCfg.mFontMenu.equals(font) && ServiceManager.sCfg.mFontLabel.equals(font2) && ServiceManager.sCfg.mFontTable.equals(font3))) {
            ServiceManager.sCfg.mFontMenu = font;
            ServiceManager.sCfg.mFontLabel = font2;
            ServiceManager.sCfg.mFontTable = font3;
            ServiceManager.getManager().getMainFrame().setFonts();
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUIDisplayTooltip != (bl2 = this.displayTooltipChkbx.isSelected())) {
            ServiceManager.sCfg.mUIDisplayTooltip = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.showUpdateNotification != (bl = this.showUpdateNotificationChkbx.isSelected())) {
            ServiceManager.sCfg.showUpdateNotification = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("GeneralUserInterfaceSettings")));
        JLabel jLabel = new JLabel(Localizer.getString("ConfigureLAF"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jLabel, gridBagConstraints);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        this.lafBox = new JComboBox<UIManager.LookAndFeelInfo>(lookAndFeelInfoArray);
        int n = this.determineCurrentLAFIndex(lookAndFeelInfoArray);
        this.lafBox.setSelectedIndex(n);
        this.lafBox.setRenderer(new LAFListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lafBox, gridBagConstraints);
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MenuFont"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        Font font = ServiceManager.sCfg.mFontMenu;
        this.menuFontCoBx = new JComboBox<String>(stringArray);
        this.menuFontCoBx.setSelectedItem(font.getName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.menuFontCoBx, gridBagConstraints);
        this.menuStyleCoBx = new JComboBox<String>(STYLE_LIST);
        this.menuStyleCoBx.setSelectedIndex(font.getStyle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.menuStyleCoBx, gridBagConstraints);
        this.menuSizeCoBx = new JComboBox<String>(SIZE_LIST);
        this.menuSizeCoBx.setSelectedItem(Integer.toString(font.getSize()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.menuSizeCoBx, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("LabelFont"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        font = ServiceManager.sCfg.mFontLabel;
        this.labelFontCoBx = new JComboBox<String>(stringArray);
        this.labelFontCoBx.setSelectedItem(font.getName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.labelFontCoBx, gridBagConstraints);
        this.labelStyleCoBx = new JComboBox<String>(STYLE_LIST);
        this.labelStyleCoBx.setSelectedIndex(font.getStyle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.labelStyleCoBx, gridBagConstraints);
        this.labelSizeCoBx = new JComboBox<String>(SIZE_LIST);
        this.labelSizeCoBx.setSelectedItem(Integer.toString(font.getSize()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.labelSizeCoBx, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("ContentFont"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        font = ServiceManager.sCfg.mFontTable;
        this.contentFontCoBx = new JComboBox<String>(stringArray);
        this.contentFontCoBx.setSelectedItem(font.getName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.contentFontCoBx, gridBagConstraints);
        this.contentStyleCoBx = new JComboBox<String>(STYLE_LIST);
        this.contentStyleCoBx.setSelectedIndex(font.getStyle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.contentStyleCoBx, gridBagConstraints);
        this.contentSizeCoBx = new JComboBox<String>(SIZE_LIST);
        this.contentSizeCoBx.setSelectedItem(Integer.toString(font.getSize()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.contentSizeCoBx, gridBagConstraints);
        this.displayTooltipChkbx = new JCheckBox(Localizer.getString("DisplayTooltipText"), ServiceManager.sCfg.mUIDisplayTooltip);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.displayTooltipChkbx, gridBagConstraints);
        this.showUpdateNotificationChkbx = new JCheckBox(Localizer.getString("ShowUpdateNotification"), ServiceManager.sCfg.showUpdateNotification);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.showUpdateNotificationChkbx, gridBagConstraints);
    }

    private int determineCurrentLAFIndex(UIManager.LookAndFeelInfo[] lookAndFeelInfoArray) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getClass().getName();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            if (!string.equals(lookAndFeelInfoArray[i].getClassName())) continue;
            return i;
        }
        return 0;
    }

    static {
        int n = 6;
        int n2 = 30;
        SIZE_LIST = new String[n2 - n + 1];
        for (int i = 0; i < SIZE_LIST.length; ++i) {
            GeneralUIPane.SIZE_LIST[i] = Integer.toString(i + n);
        }
    }
}

