/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import phex.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class NetworkPane
extends OptionsSettingsPane {
    private static final String LISTENING_PORT_KEY = "ListeningPort";
    private static final String MY_TTL_KEY = "MyTTL";
    private static final String MAX_TTL_KEY = "MaxTTL";
    private static final String MIN_CONNECTIONS_KEY = "MinConnections";
    private static final String MAX_CONNECTIONS_KEY = "MaxConnections";
    private static final String CONNECTION_TIMEOUT_KEY = "ConnectionTimeout";
    private static final String PING_FREQUENCY_KEY = "PingFrequency";
    private static final String PING_TIMEOUT_KEY = "PingTimeout";
    private static final String PROXY_PORT_KEY = "ProxyPort";
    private IntegerTextField listeningPortTF;
    private IntegerTextField myTTLTF;
    private IntegerTextField maxTTLTF;
    private IntegerTextField minConnectionsTF;
    private IntegerTextField maxConnectionsTF;
    private IntegerTextField connectionTimeoutTF;
    private IntegerTextField pingFrequencyTF;
    private IntegerTextField pingTimeoutTF;
    private JCheckBox behindFirewallCkbx;
    private JLabel exportIPLabel;
    private JTextField exportIPTF;
    private JCheckBox socks5ProxyCkbx;
    private JLabel hostLabel;
    private JTextField proxyHostTF;
    private JLabel portLabel;
    private IntegerTextField proxyPortTF;
    private JCheckBox authenticationCkbx;
    private JLabel userLabel;
    private JTextField userNameTF;
    private JLabel passwordLabel;
    private JPasswordField passwordTF;

    public NetworkPane() {
        super("Network");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("NetworkSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(LISTENING_PORT_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.listeningPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mListeningPort), 5, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.listeningPortTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(MY_TTL_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.myTTLTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetTTL), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.myTTLTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(MAX_TTL_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.maxTTLTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMaxTTL), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.maxTTLTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(MIN_CONNECTIONS_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.minConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMinConn), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.minConnectionsTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(MAX_CONNECTIONS_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.maxConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMaxConnection), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.maxConnectionsTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(PING_FREQUENCY_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.pingFrequencyTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPingFrequency / 1000), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.pingFrequencyTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(PING_TIMEOUT_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.pingTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPingTimeout / 1000), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.pingTimeoutTF, gridBagConstraints);
        jLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString(CONNECTION_TIMEOUT_KEY))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.connectionTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetConnectionTimeout / 1000), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.connectionTimeoutTF, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("FirewallProxySettings")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.exportIPLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("ExportIPAs"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.exportIPLabel, gridBagConstraints);
        this.exportIPTF = new JTextField(ServiceManager.sCfg.mMyIP, 15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.exportIPTF, gridBagConstraints);
        this.behindFirewallCkbx = new JCheckBox(Localizer.getString("BehindFirewall"), ServiceManager.sCfg.isBehindFirewall);
        this.behindFirewallCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this.behindFirewallCkbx, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.socks5ProxyCkbx = new JCheckBox(Localizer.getString("UseSocks5Proxy"), ServiceManager.sCfg.mProxyUse);
        this.socks5ProxyCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        jPanel2.add((Component)this.socks5ProxyCkbx, gridBagConstraints);
        this.hostLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("ProxyHostIP"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 2, 5);
        jPanel2.add((Component)this.hostLabel, gridBagConstraints);
        this.proxyHostTF = new JTextField(ServiceManager.sCfg.mProxyHost, 15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.proxyHostTF, gridBagConstraints);
        this.portLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("Port"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        jPanel2.add((Component)this.portLabel, gridBagConstraints);
        this.proxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mProxyPort), 5, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.proxyPortTF, gridBagConstraints);
        this.authenticationCkbx = new JCheckBox(Localizer.getString("Authentication"), ServiceManager.sCfg.useProxyAuthentication);
        this.authenticationCkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 2, 0);
        jPanel3.add((Component)this.authenticationCkbx, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.userLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("Username"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.userLabel, gridBagConstraints);
        this.userNameTF = new JTextField(ServiceManager.sCfg.mProxyUserName, 10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.userNameTF, gridBagConstraints);
        this.passwordLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("Password"))).concat(": "));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel2.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordTF = new JPasswordField(ServiceManager.sCfg.mProxyPassword, 10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.passwordTF, gridBagConstraints);
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.listeningPortTF.getText();
            n = new Integer(string);
            hashMap.put(LISTENING_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.listeningPortTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.myTTLTF.getText();
            n = new Integer(string);
            hashMap.put(MY_TTL_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.myTTLTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxTTLTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_TTL_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxTTLTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.minConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(MIN_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.minConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.connectionTimeoutTF.getText();
            n = new Integer(string);
            hashMap.put(CONNECTION_TIMEOUT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.connectionTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.pingFrequencyTF.getText();
            n = new Integer(string);
            hashMap.put(PING_FREQUENCY_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.pingFrequencyTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.pingTimeoutTF.getText();
            n = new Integer(string);
            hashMap.put(PING_TIMEOUT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.pingTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.proxyPortTF.getText();
            n = new Integer(string);
            hashMap.put(PROXY_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        String string;
        String string2;
        boolean bl;
        String string3;
        boolean bl2;
        boolean bl3;
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5;
        int n6;
        Integer n7;
        int n8;
        Integer n9;
        int n10;
        Integer n11;
        int n12;
        Integer n13;
        int n14;
        Integer n15;
        int n16;
        String string4 = this.exportIPTF.getText();
        if (!ServiceManager.sCfg.mMyIP.equals(string4)) {
            ServiceManager.sCfg.mMyIP = string4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            ServiceManager.getListener().setMyIP(ServiceManager.sCfg.mMyIP);
        }
        if (ServiceManager.sCfg.mListeningPort != (n16 = (n15 = (Integer)hashMap.get(LISTENING_PORT_KEY)).intValue())) {
            ServiceManager.sCfg.mListeningPort = n16;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            ServiceManager.getListener().shutdown(true);
            try {
                ServiceManager.getListener().startup();
            }
            catch (Exception exception) {
                GUIUtils.showErrorMessage(Localizer.getString("FailedToListenOnNewPort"), Localizer.getString("ListenerError"));
            }
        }
        if (ServiceManager.sCfg.mNetTTL != (n14 = (n13 = (Integer)hashMap.get(MY_TTL_KEY)).intValue())) {
            ServiceManager.sCfg.mNetTTL = n14;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMaxTTL != (n12 = (n11 = (Integer)hashMap.get(MAX_TTL_KEY)).intValue())) {
            ServiceManager.sCfg.mNetMaxTTL = n12;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMinConn != (n10 = (n9 = (Integer)hashMap.get(MIN_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.mNetMinConn = n10;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMaxConnection != (n8 = (n7 = (Integer)hashMap.get(MAX_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.mNetMaxConnection = n8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetConnectionTimeout != (n6 = (n5 = (Integer)hashMap.get(CONNECTION_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mNetConnectionTimeout = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mPingFrequency != (n4 = (n3 = (Integer)hashMap.get(PING_FREQUENCY_KEY)) * 1000)) {
            ServiceManager.sCfg.mPingFrequency = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mPingTimeout != (n2 = (n = (Integer)hashMap.get(PING_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mPingTimeout = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.isBehindFirewall != (bl3 = this.behindFirewallCkbx.isSelected())) {
            ServiceManager.sCfg.isBehindFirewall = bl3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mProxyUse != (bl2 = this.socks5ProxyCkbx.isSelected())) {
            ServiceManager.sCfg.mProxyUse = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            ServiceManager.getManager().getMainFrame().setTitle();
        }
        if (!ServiceManager.sCfg.mProxyHost.equals(string3 = this.proxyHostTF.getText())) {
            ServiceManager.sCfg.mProxyHost = string3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        Integer n17 = (Integer)hashMap.get(PROXY_PORT_KEY);
        int n18 = 1080;
        if (n17 != null) {
            n18 = n17;
        }
        if (ServiceManager.sCfg.mProxyPort != n18) {
            ServiceManager.sCfg.mProxyPort = n18;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.useProxyAuthentication != (bl = this.authenticationCkbx.isSelected())) {
            ServiceManager.sCfg.useProxyAuthentication = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.mProxyUserName.equals(string2 = this.userNameTF.getText())) {
            ServiceManager.sCfg.mProxyUserName = string2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.mProxyPassword.equals(string = new String(this.passwordTF.getPassword()))) {
            ServiceManager.sCfg.mProxyPassword = string;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
        this.socks5ProxyCkbx.setEnabled(this.behindFirewallCkbx.isSelected());
        this.hostLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.proxyHostTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.portLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.proxyPortTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.authenticationCkbx.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected());
        this.userLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.authenticationCkbx.isSelected());
        this.userNameTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.authenticationCkbx.isSelected());
        this.passwordLabel.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.authenticationCkbx.isSelected());
        this.passwordTF.setEnabled(this.behindFirewallCkbx.isSelected() && this.socks5ProxyCkbx.isSelected() && this.authenticationCkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkPane.this.refreshEnableState();
        }
    }
}

