/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import phex.ServiceManager;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.download.RemoteFile;
import phex.event.DownloadFilesChangeListener;
import phex.gui.common.LazyEventQueue;

public class DownloadTableModel
extends AbstractTableModel {
    private DownloadManager downloadMgr = ServiceManager.getDownloadManager();
    private static final int colNumSharingHost = 0;
    private static final int colNumClient = 1;
    private static final int colNumFile = 2;
    private static final int colNumRetries = 3;
    private static final int colNumPercent = 4;
    private static final int colNumSize = 5;
    private static final int colNumRate = 6;
    private static final int colNumStatus = 7;
    private static final String[] tableColumns = new String[]{"Sharing Host", "Server", "File", "Retries", "%", "Size", "Rate", "Status"};
    static Class class$java$lang$Integer;
    static Class class$phex$gui$renderer$TransferRateCellRenderer;
    static Class class$phex$gui$renderer$ProgressCellRenderer;
    static Class class$phex$gui$renderer$TransferSizeCellRenderer;
    static Class class$java$lang$String;

    public DownloadTableModel() {
        this.downloadMgr.addDownloadFilesChangeListener(new DownloadFilesListener());
    }

    public String getColumnName(int n) {
        return tableColumns[n];
    }

    public int getColumnCount() {
        return tableColumns.length;
    }

    public int getRowCount() {
        return this.downloadMgr.getDownloadCount();
    }

    public Object getValueAt(int n, int n2) {
        DownloadFile downloadFile = this.downloadMgr.getDownloadFileAt(n);
        if (downloadFile == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        RemoteFile remoteFile = downloadFile.getCurrentRemoteFile();
        switch (n2) {
            case 0: {
                if (remoteFile == null) {
                    return "unknown";
                }
                return remoteFile.getRemoteHost();
            }
            case 1: {
                if (downloadFile.getRemoteAppName() == null) {
                    return "unknown";
                }
                return downloadFile.getRemoteAppName();
            }
            case 2: {
                return downloadFile.getShortname();
            }
            case 3: {
                return downloadFile.getRetryCountObject();
            }
            case 4: {
                return downloadFile.getProgress();
            }
            case 5: {
                return downloadFile;
            }
            case 6: {
                return downloadFile;
            }
            case 7: {
                return downloadFile.getStatusName();
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DownloadTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 4: {
                return class$phex$gui$renderer$ProgressCellRenderer == null ? (class$phex$gui$renderer$ProgressCellRenderer = DownloadTableModel.class$("phex.gui.renderer.ProgressCellRenderer")) : class$phex$gui$renderer$ProgressCellRenderer;
            }
            case 5: {
                return class$phex$gui$renderer$TransferSizeCellRenderer == null ? (class$phex$gui$renderer$TransferSizeCellRenderer = DownloadTableModel.class$("phex.gui.renderer.TransferSizeCellRenderer")) : class$phex$gui$renderer$TransferSizeCellRenderer;
            }
            case 6: {
                return class$phex$gui$renderer$TransferRateCellRenderer == null ? (class$phex$gui$renderer$TransferRateCellRenderer = DownloadTableModel.class$("phex.gui.renderer.TransferRateCellRenderer")) : class$phex$gui$renderer$TransferRateCellRenderer;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = DownloadTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DownloadFilesListener
    implements DownloadFilesChangeListener {
        private LazyEventQueue lazyEventQueue = ServiceManager.getLazyEventQueue();

        public void downloadFileChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(DownloadTableModel.this, n, n, -1, 0));
        }

        public void downloadFileAdded(int n) {
            DownloadTableModel.this.fireTableChanged(new TableModelEvent(DownloadTableModel.this, n, n, -1, 1));
        }

        public void downloadFileRemoved(int n) {
            DownloadTableModel.this.fireTableChanged(new TableModelEvent(DownloadTableModel.this, n, n, -1, -1));
        }
    }
}

