/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import phex.ServiceManager;
import phex.event.UploadFilesChangeListener;
import phex.gui.common.LazyEventQueue;
import phex.share.UploadFile;
import phex.share.UploadFileContainer;

public class UploadFilesTableModel
extends AbstractTableModel {
    private static final int colNumDownloadingHost = 0;
    private static final int colNumClient = 1;
    private static final int colNumFile = 2;
    private static final int colNumPercent = 3;
    private static final int colNumSize = 4;
    private static final int colNumRate = 5;
    private static final int colNumStatus = 6;
    private static final String[] tableColumns = new String[]{"Downloading Host", "Client", "File", "%", "Size", "Rate", "Status"};
    private UploadFileContainer uploadFiles = ServiceManager.getShareManager().getUploadFileContainer();
    static Class class$phex$gui$renderer$TransferRateCellRenderer;
    static Class class$phex$gui$renderer$ProgressCellRenderer;
    static Class class$phex$gui$renderer$TransferSizeCellRenderer;
    static Class class$java$lang$String;

    public UploadFilesTableModel() {
        this.uploadFiles.addUploadFilesChangeListener(new UploadFilesListener());
    }

    public String getColumnName(int n) {
        return tableColumns[n];
    }

    public int getColumnCount() {
        return tableColumns.length;
    }

    public int getRowCount() {
        return this.uploadFiles.getUploadListSize();
    }

    public Object getValueAt(int n, int n2) {
        UploadFile uploadFile = this.uploadFiles.getUploadFileAt(n);
        if (uploadFile == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return uploadFile.getRemoteHost();
            }
            case 1: {
                if (uploadFile.getRemoteAppName() == null) {
                    return "";
                }
                return uploadFile.getRemoteAppName();
            }
            case 2: {
                return uploadFile.getFilename();
            }
            case 3: {
                return uploadFile.getProgress();
            }
            case 4: {
                return uploadFile;
            }
            case 5: {
                return uploadFile;
            }
            case 6: {
                return uploadFile.getStatusName();
            }
        }
        return "";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return class$phex$gui$renderer$ProgressCellRenderer == null ? (class$phex$gui$renderer$ProgressCellRenderer = UploadFilesTableModel.class$("phex.gui.renderer.ProgressCellRenderer")) : class$phex$gui$renderer$ProgressCellRenderer;
            }
            case 4: {
                return class$phex$gui$renderer$TransferSizeCellRenderer == null ? (class$phex$gui$renderer$TransferSizeCellRenderer = UploadFilesTableModel.class$("phex.gui.renderer.TransferSizeCellRenderer")) : class$phex$gui$renderer$TransferSizeCellRenderer;
            }
            case 5: {
                return class$phex$gui$renderer$TransferRateCellRenderer == null ? (class$phex$gui$renderer$TransferRateCellRenderer = UploadFilesTableModel.class$("phex.gui.renderer.TransferRateCellRenderer")) : class$phex$gui$renderer$TransferRateCellRenderer;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = UploadFilesTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UploadFilesListener
    implements UploadFilesChangeListener {
        private LazyEventQueue lazyEventQueue = ServiceManager.getLazyEventQueue();

        public void uploadFileChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(UploadFilesTableModel.this, n, n, -1, 0));
        }

        public void uploadFileAdded(int n) {
            UploadFilesTableModel.this.fireTableChanged(new TableModelEvent(UploadFilesTableModel.this, n, n, -1, 1));
        }

        public void uploadFileRemoved(int n) {
            UploadFilesTableModel.this.fireTableChanged(new TableModelEvent(UploadFilesTableModel.this, n, n, -1, -1));
        }
    }
}

