/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import phex.MainFrame;
import phex.ServiceManager;
import phex.dialogues.DlgLog;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.DownloadCandidateTableModel;
import phex.gui.models.DownloadTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.query.ResearchSetting;
import phex.utils.Localizer;
import phex.utils.TableSorter;

public class DownloadTab
extends JPanel {
    private DownloadManager mDownloadMgr = ServiceManager.getDownloadManager();
    private JTable mDownloadTable;
    private AbstractTableModel mDownloadModel;
    private TableSorter mDownloadSorter;
    private JTable mDownloadCandidate;
    private DownloadCandidateTableModel mDownloadCandidateModel;
    private JLabel mCandidateLabelStatus;
    private MainFrame mainFrame;

    public DownloadTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void initComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mDownloadModel = new DownloadTableModel();
        this.mDownloadSorter = new TableSorter(this.mDownloadModel);
        this.mDownloadTable = new JTable(this.mDownloadSorter);
        this.mDownloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        this.mDownloadSorter.addMouseListenerToHeaderInTable(this.mDownloadTable);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(Localizer.getString("Stop"));
        JButton jButton2 = new JButton(Localizer.getString("Resume"));
        JButton jButton3 = new JButton(Localizer.getString("Remove"));
        JButton jButton4 = new JButton(Localizer.getString("Configure"));
        jButton4.setActionCommand("ConfigureDownload");
        JButton jButton5 = new JButton(Localizer.getString("ShowLog"));
        this.mainFrame.addRefreshComponent("ActionDownloadStop", jButton);
        this.mainFrame.addRefreshComponent("ActionDownloadResume", jButton2);
        this.mainFrame.addRefreshComponent("ActionDownloadRemove", jButton3);
        this.mainFrame.addRefreshComponent("ActionDownloadShowLog", jButton5);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton4);
        jPanel2.add(jButton3);
        jPanel2.add(jButton5);
        jButton.addActionListener(new StopDownloadHandler());
        jButton2.addActionListener(new ResumeDownloadHandler());
        jButton4.addActionListener(new ButtonActionListener());
        jButton3.addActionListener(new RemoveDownloadHandler());
        jButton5.addActionListener(new ShowDownloadLogHandler());
        jPanel.add("North", new JLabel("Downloads:"));
        jPanel.add("Center", new JScrollPane(this.mDownloadTable));
        jPanel.add("South", jPanel2);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.mDownloadCandidateModel = new DownloadCandidateTableModel();
        this.mDownloadCandidate = new JTable(this.mDownloadCandidateModel);
        this.mDownloadCandidate.setSelectionMode(0);
        this.mDownloadCandidate.getSelectionModel().addListSelectionListener(new SelectionHandler());
        JPanel jPanel3 = new JPanel(new FlowLayout());
        JButton jButton6 = new JButton(Localizer.getString("SetCurrent"));
        JButton jButton7 = new JButton(Localizer.getString("Remove"));
        JButton jButton8 = new JButton(Localizer.getString("RemoveAll"));
        jButton8.setActionCommand("RemoveAll");
        JButton jButton9 = new JButton(Localizer.getString("Search"));
        JButton jButton10 = new JButton(Localizer.getString("StopSearch"));
        this.mainFrame.addRefreshComponent("ActionDownloadSetCandidateCurrent", jButton6);
        this.mainFrame.addRefreshComponent("ActionDownloadRemoveCandidate", jButton7);
        this.mainFrame.addRefreshComponent("ActionDownloadSearchCandidate", jButton9);
        this.mainFrame.addRefreshComponent("ActionDownloadStopSearchCandidate", jButton10);
        jPanel3.add(jButton6);
        jPanel3.add(jButton7);
        jPanel3.add(jButton8);
        jPanel3.add(jButton9);
        jPanel3.add(jButton10);
        jButton8.addActionListener(new CandidateButtonHandler());
        jButton6.addActionListener(new SetCandidateCurrentHandler());
        jButton7.addActionListener(new RemoveCandidateHandler());
        jButton9.addActionListener(new SearchCandidateHandler());
        jButton10.addActionListener(new StopSearchCandidateHandler());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.mCandidateLabelStatus = new JLabel("Download Candidates:  ");
        jPanel4.add("North", this.mCandidateLabelStatus);
        jPanel4.add("Center", new JScrollPane(this.mDownloadCandidate));
        jPanel4.add("South", jPanel3);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        jPanel.setPreferredSize(new Dimension(780, 300));
        jPanel4.setPreferredSize(new Dimension(780, 200));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel);
        jSplitPane.setBottomComponent(jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add("Center", jSplitPane);
        this.add("Center", jPanel5);
        CellRenderer cellRenderer = new CellRenderer();
        this.mDownloadTable.getColumn(this.mDownloadModel.getColumnName(0)).setCellRenderer(cellRenderer);
        this.mDownloadTable.getColumn(this.mDownloadModel.getColumnName(1)).setCellRenderer(cellRenderer);
        this.mDownloadTable.getColumn(this.mDownloadModel.getColumnName(2)).setCellRenderer(cellRenderer);
        this.mDownloadTable.getColumn(this.mDownloadModel.getColumnName(3)).setCellRenderer(cellRenderer);
        this.mDownloadTable.getColumn(this.mDownloadModel.getColumnName(7)).setCellRenderer(cellRenderer);
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.mDownloadTable);
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.mDownloadCandidate);
        GUIUtils.adjustTableProgresssBarHeight(this.mDownloadTable);
        this.mDownloadMgr.addDownloadFilesChangeListener(new DownloadFilesChangeHandler());
    }

    public void updateUI() {
        super.updateUI();
        if (this.mDownloadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.mDownloadTable);
        }
    }

    public void stopDownload() {
        int n = this.mDownloadTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mDownloadTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 >= this.mDownloadMgr.getDownloadCount()) {
                return;
            }
            n2 = this.mDownloadSorter.indexes[n2];
            this.mDownloadMgr.stopDownload(n2);
        }
        this.mainFrame.refreshAllActions();
    }

    public void resumeDownload() {
        int n = this.mDownloadTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mDownloadTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 >= this.mDownloadMgr.getDownloadCount()) {
                return;
            }
            n2 = this.mDownloadSorter.indexes[n2];
            this.mDownloadMgr.resumeDownload(n2);
        }
        this.mainFrame.refreshAllActions();
    }

    public boolean isDownloadSelected() {
        return this.mainFrame.isDownloadTabSelected() && this.mDownloadTable.getSelectedRowCount() > 0 && this.mDownloadMgr.getDownloadCount() > 0;
    }

    public void removeDownload() {
        DownloadManager downloadManager = this.mDownloadMgr;
        synchronized (downloadManager) {
            int n;
            int n2;
            int n3 = this.mDownloadTable.getSelectedRowCount();
            if (n3 <= 0) {
                return;
            }
            int[] nArray = this.mDownloadTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            Vector vector = new Vector();
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                if (n >= this.mDownloadMgr.getDownloadCount()) {
                    return;
                }
                nArray2[n2] = this.mDownloadSorter.indexes[n];
            }
            this.mDownloadTable.removeRowSelectionInterval(0, this.mDownloadTable.getRowCount() - 1);
            for (n2 = nArray2.length - 1; n2 > 0; --n2) {
                for (n = 0; n < n2; ++n) {
                    if (nArray2[n] <= nArray2[n + 1]) continue;
                    int n4 = nArray2[n];
                    nArray2[n] = nArray2[n + 1];
                    nArray2[n + 1] = n4;
                }
            }
            for (n2 = nArray2.length - 1; n2 >= 0; --n2) {
                this.mDownloadMgr.removeDownload(nArray2[n2]);
            }
            this.mainFrame.refreshAllActions();
        }
    }

    public void removeCompletedDownloads() {
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted) {
            DownloadManager downloadManager = this.mDownloadMgr;
            synchronized (downloadManager) {
                this.mDownloadMgr.removeCompleted();
            }
            this.mainFrame.refreshAllActions();
        }
    }

    public void showDownloadLog() {
        DownloadFile downloadFile = this.getSelectedDownloadFile();
        if (downloadFile == null) {
            return;
        }
        DlgLog dlgLog = new DlgLog(this.mainFrame, "Download Log", "Log for ".concat(String.valueOf(String.valueOf(downloadFile.getFilename()))), downloadFile.getLog());
        ((Component)dlgLog).setVisible(true);
    }

    public boolean isCandidateSelected() {
        if (!this.mainFrame.isDownloadTabSelected()) {
            return false;
        }
        int n = this.mDownloadTable.getSelectedRowCount();
        if (n <= 0) {
            return false;
        }
        int n2 = this.mDownloadCandidate.getSelectedRow();
        return n2 != -1;
    }

    public void setCandidateCurrent() {
        DownloadFile downloadFile = this.getSelectedDownloadFile();
        if (downloadFile == null) {
            return;
        }
        if (downloadFile.getStatus() == 10 || downloadFile.getStatus() == 2 || downloadFile.getStatus() == 11) {
            return;
        }
        int n = this.mDownloadCandidate.getSelectedRow();
        downloadFile.setCandidateCurrent(n);
    }

    public void removeCandidate() {
        DownloadFile downloadFile = this.getSelectedDownloadFile();
        if (downloadFile == null) {
            return;
        }
        int n = this.mDownloadCandidate.getSelectedRow();
        downloadFile.removeRemoteCandidate(n);
    }

    public void stopSearchCandidate() {
        DownloadFile downloadFile = this.getSelectedDownloadFile();
        if (downloadFile != null) {
            downloadFile.stopSearchForCandidates();
        }
    }

    private void updateCandidateLabel() {
        DownloadFile downloadFile = this.getSelectedDownloadFile();
        if (downloadFile == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Download Candidates  ");
        ResearchSetting researchSetting = downloadFile.getResearchSetting();
        if (researchSetting.isSearchRunning()) {
            stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("-  searching... ( ").append(researchSetting.getSearchHitCount()).append(" Hits )"))));
        } else {
            stringBuffer.append("-  search stopped!");
        }
        this.mCandidateLabelStatus.setText(stringBuffer.toString());
        this.mainFrame.refreshAllActions();
    }

    public DownloadFile getSelectedDownloadFile() {
        int n = this.mDownloadTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.mDownloadSorter.indexes[n];
        if (n2 < 0) {
            return null;
        }
        return this.mDownloadMgr.getDownloadFileAt(n2);
    }

    private void configureDownload() {
        DownloadFile downloadFile = this.getSelectedDownloadFile();
        if (downloadFile != null) {
            if (downloadFile.isDownloadInProgress()) {
                JOptionPane.showMessageDialog(this, Localizer.getString("NoConfigDownloadInProgress"), Localizer.getString("DownloadInProgress"), 2);
                return;
            }
            int n = downloadFile.getStatus();
            this.mDownloadMgr.stopDownload(downloadFile);
            DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(downloadFile);
            downloadConfigDialog.show();
            downloadFile.setStatus(n);
        }
    }

    private class DownloadSelectionHandler
    implements ListSelectionListener {
        private DownloadSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                DownloadTab.this.updateCandidateLabel();
                DownloadFile downloadFile = DownloadTab.this.getSelectedDownloadFile();
                DownloadTab.this.mDownloadCandidateModel.setCurrentDownloadFile(downloadFile);
                DownloadTab.this.mainFrame.refreshAllActions();
            }
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(Color.black);
            if (jTable == DownloadTab.this.mDownloadTable) {
                n = ((DownloadTab)DownloadTab.this).mDownloadSorter.indexes[n];
                DownloadFile downloadFile = DownloadTab.this.mDownloadMgr.getDownloadFileAt(n);
                if (downloadFile == null) {
                    return this;
                }
                switch (downloadFile.getStatus()) {
                    case 5: {
                        this.setForeground(Color.darkGray);
                        break;
                    }
                    case 2: {
                        this.setForeground(Color.red);
                        break;
                    }
                    case 4: {
                        this.setForeground(Color.blue);
                    }
                }
            }
            return this;
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DownloadTab.this.mainFrame.refreshAllActions();
        }
    }

    private class StopSearchCandidateHandler
    implements ActionListener {
        private StopSearchCandidateHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.stopSearchCandidate();
        }
    }

    private class SearchCandidateHandler
    implements ActionListener {
        private SearchCandidateHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadFile downloadFile = DownloadTab.this.getSelectedDownloadFile();
            if (downloadFile == null) {
                return;
            }
            downloadFile.startSearchForCandidates();
        }
    }

    private class RemoveCandidateHandler
    implements ActionListener {
        private RemoveCandidateHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.removeCandidate();
        }
    }

    private class SetCandidateCurrentHandler
    implements ActionListener {
        private SetCandidateCurrentHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.setCandidateCurrent();
        }
    }

    private class ShowDownloadLogHandler
    implements ActionListener {
        private ShowDownloadLogHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.showDownloadLog();
        }
    }

    private class RemoveDownloadHandler
    implements ActionListener {
        private RemoveDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.removeDownload();
        }
    }

    private class ResumeDownloadHandler
    implements ActionListener {
        private ResumeDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.resumeDownload();
        }
    }

    private class StopDownloadHandler
    implements ActionListener {
        private StopDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloadTab.this.stopDownload();
        }
    }

    private class CandidateButtonHandler
    implements ActionListener {
        private CandidateButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("RemoveAll")) {
                DownloadFile downloadFile = DownloadTab.this.getSelectedDownloadFile();
                downloadFile.removeAllRemoteCandidates();
            }
        }
    }

    private class DownloadFilesChangeHandler
    implements DownloadFilesChangeListener {
        private DownloadFilesChangeHandler() {
        }

        public void downloadFileChanged(int n) {
            if (DownloadTab.this.mDownloadTable.getSelectedRow() == n) {
                DownloadTab.this.updateCandidateLabel();
            }
        }

        public void downloadFileAdded(int n) {
        }

        public void downloadFileRemoved(int n) {
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("ConfigureDownload")) {
                DownloadTab.this.configureDownload();
            }
        }
    }
}

