/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import phex.MainFrame;
import phex.ServiceManager;
import phex.download.DownloadManager;
import phex.download.RemoteFile;
import phex.event.QueryHistoryChangeListener;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.common.TextFieldFactory;
import phex.gui.models.QueryHistoryMonitorTableModel;
import phex.interfaces.IMonitorSearch;
import phex.msg.MsgManager;
import phex.query.QueryHistoryMonitor;
import phex.utils.IPUtils;
import phex.utils.TableSorter;
import phex.utils.URLUtil;

public class MonitorTab
extends JPanel
implements IMonitorSearch {
    private MainFrame mainFrame;
    private MsgManager mMsgManager;
    private DownloadManager mDownloadMgr;
    private QueryHistoryMonitor queryHistory;
    private JTable mMonitorTable;
    private QueryHistoryMonitorTableModel queryHistoryModel;
    private JTable mPassiveSearchTable;
    private AbstractTableModel mPassiveSearchModel;
    private TableSorter mPassiveSearchSorter;
    private JTextField mPassiveSearch;
    private JButton mPassiveButton;
    private JLabel mPassiveStatus;
    private JPopupMenu mSearchResultPopupMenu;
    private JCheckBox enableMonitorCheckbox;
    private JTextField numberOfMonitorRows;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Long;
    static Class class$java$lang$String;

    public MonitorTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.mMsgManager = ServiceManager.getMsgManager();
        this.mDownloadMgr = ServiceManager.getDownloadManager();
        this.queryHistory = ServiceManager.getQueryManager().getQueryHistoryMonitor();
        this.mMsgManager.setMonitorSearchListener(this);
        this.mSearchResultPopupMenu = new JPopupMenu();
        this.mainFrame.populatePopupMenu(this.mSearchResultPopupMenu, "SearchResultTable.PopupMenu");
    }

    public void initComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Search Monitor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.enableMonitorCheckbox = new JCheckBox("enable");
        this.enableMonitorCheckbox.setSelected(this.queryHistory.isHistoryMonitored());
        this.enableMonitorCheckbox.addChangeListener(new EnableMonitorChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.enableMonitorCheckbox, gridBagConstraints);
        this.queryHistoryModel = new QueryHistoryMonitorTableModel();
        this.mMonitorTable = new JTable(this.queryHistoryModel);
        ServiceManager.getQueryManager().getQueryHistoryMonitor().setQueryHistoryChangeListener(new QueryHistoryChangeListener(){

            public void queryHistoryChanged() {
                GUIUtils.fireTableChanged(MonitorTab.this.mMonitorTable, MonitorTab.this.queryHistoryModel);
            }
        });
        this.mMonitorTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jLabel = new JLabel("Show ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.numberOfMonitorRows = new IntegerTextField(String.valueOf(this.queryHistory.getMaxHistorySize()), 3, 3);
        this.numberOfMonitorRows.getDocument().addDocumentListener(new MonitorRowsDocumentListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)this.numberOfMonitorRows, gridBagConstraints);
        jLabel = new JLabel(" Rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("Center", new JScrollPane(this.mMonitorTable));
        jPanel3.add("South", jPanel2);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.mPassiveSearchModel = new PassiveSearchTableModel();
        this.mPassiveSearchSorter = new TableSorter(this.mPassiveSearchModel);
        this.mPassiveSearchTable = new JTable(this.mPassiveSearchSorter);
        this.mPassiveSearchTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.mPassiveSearchTable.addMouseListener(new MouseHandler());
        this.mPassiveSearchSorter.addMouseListenerToHeaderInTable(this.mPassiveSearchTable);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.mPassiveSearch = TextFieldFactory.newTextField("", 20);
        GUIUtils.setToolTipText(this.mPassiveSearch, "Specify keywords to match, separated by space.");
        this.mPassiveButton = new JButton("Start Passive Search");
        GUIUtils.setToolTipText(this.mPassiveButton, "Passive search monitors the search results routed through here.  This might take a while.");
        this.mPassiveStatus = new JLabel("Passive Search Result");
        this.mPassiveButton.addActionListener(new PassiveSearchHandler());
        jPanel5.add("West", new JLabel("Monitor Filter:"));
        jPanel5.add("Center", this.mPassiveSearch);
        jPanel5.add("East", this.mPassiveButton);
        jPanel5.add("South", this.mPassiveStatus);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Download");
        JButton jButton2 = new JButton("Clear");
        jButton.addActionListener(new PassiveDownloadHandler());
        this.mainFrame.addRefreshComponent("ActionTransferDownload", jButton);
        jButton2.addActionListener(new PassiveClearHandler());
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel4.add("North", jPanel5);
        jPanel4.add("Center", new JScrollPane(this.mPassiveSearchTable));
        jPanel4.add("South", jPanel6);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        jPanel3.setPreferredSize(new Dimension(780, 200));
        jPanel4.setPreferredSize(new Dimension(780, 230));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel3);
        jSplitPane.setBottomComponent(jPanel4);
        this.add("Center", jSplitPane);
    }

    public RemoteFile getSelectedRemoteFile() {
        if (this.mPassiveSearchTable.getSelectedRowCount() < 1) {
            return null;
        }
        int[] nArray = this.mPassiveSearchTable.getSelectedRows();
        int n = this.mPassiveSearchSorter.indexes[nArray[0]];
        Vector vector = this.mMsgManager.getPassiveResults();
        RemoteFile remoteFile = (RemoteFile)vector.elementAt(n);
        return remoteFile;
    }

    public void passiveSearch() {
        if (this.mMsgManager.getPassiveSearching() == null) {
            String string = this.mPassiveSearch.getText().trim();
            this.mMsgManager.setPassiveSearching(string);
            this.mPassiveButton.setText("Stop Passive Search");
            this.mPassiveStatus.setText("Passive Search Result (Monitoring...)");
        } else {
            this.mMsgManager.setPassiveSearching(null);
            this.mPassiveButton.setText("Start Passive Search");
            this.mPassiveStatus.setText("Passive Search Result");
        }
        this.mainFrame.refreshAllActions();
    }

    public void passiveDownload() {
        int n = this.mPassiveSearchTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mPassiveSearchTable.getSelectedRows();
        Vector vector = this.mMsgManager.getPassiveResults();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            n2 = this.mPassiveSearchSorter.indexes[n2];
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            this.mDownloadMgr.addFileToDownload(remoteFile2);
        }
        this.mainFrame.selectTab(3);
        this.mainFrame.refreshAllActions();
    }

    public void passiveCopyURL() {
        int n = this.mPassiveSearchTable.getSelectedRowCount();
        if (n != 1) {
            return;
        }
        int[] nArray = this.mPassiveSearchTable.getSelectedRows();
        Vector vector = this.mMsgManager.getPassiveResults();
        int n2 = this.mPassiveSearchSorter.indexes[nArray[0]];
        RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
        String string = URLUtil.encodeURL(remoteFile.getURL());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public void filterPassiveDownloadHost() {
        int n = this.mPassiveSearchTable.getSelectedRowCount();
        if (n <= 0) {
            return;
        }
        int[] nArray = this.mPassiveSearchTable.getSelectedRows();
        Vector vector = this.mMsgManager.getPassiveResults();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            n2 = this.mPassiveSearchSorter.indexes[n2];
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
            ServiceManager.sCfg.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(remoteFile.getRemoteHost()));
        }
        ServiceManager.sCfg.save();
    }

    public boolean isPassiveResultSelected() {
        return this.mPassiveSearchTable.getSelectedRowCount() > 0;
    }

    private void passiveClearResult() {
        this.mMsgManager.resetPassiveResults();
        this.mainFrame.refreshAllActions();
    }

    public void passiveResultArrived() {
        GUIUtils.fireTableChanged(this.mPassiveSearchTable, this.mPassiveSearchModel);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EnableMonitorChangeListener
    implements ChangeListener {
        private EnableMonitorChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MonitorTab.this.queryHistory.setHistoryMonitored(MonitorTab.this.enableMonitorCheckbox.isSelected());
        }
    }

    private class MonitorRowsDocumentListener
    implements DocumentListener {
        private MonitorRowsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateMonitorRows() {
            String string = MonitorTab.this.numberOfMonitorRows.getText();
            try {
                int n = Integer.parseInt(string);
                MonitorTab.this.queryHistory.setMaxHistroySize(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MonitorTab.this.mainFrame.refreshAllActions();
        }
    }

    private class PassiveSearchTableModel
    extends AbstractTableModel {
        private PassiveSearchTableModel() {
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            Vector vector = MonitorTab.this.mMsgManager.getPassiveResults();
            return vector.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Sharing Host";
                }
                case 1: {
                    return "File";
                }
                case 2: {
                    return "Extension";
                }
                case 3: {
                    return "Size";
                }
                case 4: {
                    return "Host Speed";
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = MonitorTab.this.mMsgManager.getPassiveResults();
            if (n >= vector.size()) {
                return "";
            }
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n);
            switch (n2) {
                case 0: {
                    return remoteFile.getRemoteHost();
                }
                case 1: {
                    return remoteFile.getFilename();
                }
                case 2: {
                    return remoteFile.getFileExt();
                }
                case 3: {
                    return remoteFile.getFileSizeLong();
                }
                case 4: {
                    return remoteFile.getSpeedInt();
                }
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = MonitorTab.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = MonitorTab.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = MonitorTab.class$("java.lang.String")) : class$java$lang$String;
                }
                case 3: {
                    return class$java$lang$Long == null ? (class$java$lang$Long = MonitorTab.class$("java.lang.Long")) : class$java$lang$Long;
                }
                case 4: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = MonitorTab.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = MonitorTab.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    private class PassiveSearchHandler
    implements ActionListener {
        private PassiveSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveSearch();
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == MonitorTab.this.mPassiveSearchTable) {
                MonitorTab.this.passiveDownload();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == MonitorTab.this.mPassiveSearchTable) {
                MonitorTab.this.mSearchResultPopupMenu.show(component, n, n2);
            }
        }
    }

    private class PassiveDownloadHandler
    implements ActionListener {
        private PassiveDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveDownload();
        }
    }

    private class PassiveClearHandler
    implements ActionListener {
        private PassiveClearHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveClearResult();
        }
    }
}

