/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import phex.MainFrame;
import phex.ServiceManager;
import phex.event.SharedFilesChangeListener;
import phex.gui.common.GUIUtils;
import phex.gui.models.SharedFilesTableModel;
import phex.gui.models.UploadFilesTableModel;
import phex.gui.renderer.DefaultPhexCellRenderers;
import phex.share.FileAdministration;
import phex.share.ShareManager;
import phex.share.UploadFile;
import phex.share.UploadFileContainer;
import phex.utils.Localizer;
import phex.utils.StrUtil;
import phex.utils.TableSorter;

public class ShareTab
extends JPanel {
    private ShareManager mShareMgr;
    private UploadFileContainer uploadContainer;
    private FileAdministration fileAdmin;
    private MainFrame mainFrame;
    private JTable mUploadTable;
    private AbstractTableModel mUploadModel;
    private TableSorter mUploadSorter;
    private JTable mShareFilesTable;
    private AbstractTableModel mShareFilesModel;
    private TableSorter mShareFilesSorter;
    private JLabel sharedFilesLabel;

    public ShareTab(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.mShareMgr = ServiceManager.getShareManager();
        this.fileAdmin = this.mShareMgr.getFileAdministration();
        this.uploadContainer = this.mShareMgr.getUploadFileContainer();
    }

    public void initComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mUploadModel = new UploadFilesTableModel();
        this.mUploadSorter = new TableSorter(this.mUploadModel);
        this.mUploadTable = new JTable(this.mUploadSorter);
        this.mUploadTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.mUploadSorter.addMouseListenerToHeaderInTable(this.mUploadTable);
        jPanel.add("North", new JLabel("Uploads:"));
        jPanel.add("Center", new JScrollPane(this.mUploadTable));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Abort Upload");
        JButton jButton2 = new JButton("Clear Completed");
        this.mainFrame.addRefreshComponent("ActionShareAbort", jButton);
        this.mainFrame.addRefreshComponent("ActionShareClear", jButton2);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton.addActionListener(new AbortUploadHandler());
        jButton2.addActionListener(new ClearUploadHandler());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", jPanel);
        jPanel3.add("South", jPanel2);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.mShareFilesModel = new SharedFilesTableModel();
        this.mShareFilesSorter = new TableSorter(this.mShareFilesModel);
        this.mShareFilesTable = new JTable(this.mShareFilesSorter);
        this.mShareFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this.mUploadTable);
        CellRenderer cellRenderer = new CellRenderer();
        this.mUploadTable.getColumn(this.mUploadModel.getColumnName(0)).setCellRenderer(cellRenderer);
        this.mUploadTable.getColumn(this.mUploadModel.getColumnName(1)).setCellRenderer(cellRenderer);
        this.mUploadTable.getColumn(this.mUploadModel.getColumnName(2)).setCellRenderer(cellRenderer);
        this.mUploadTable.getColumn(this.mUploadModel.getColumnName(6)).setCellRenderer(cellRenderer);
        GUIUtils.adjustTableProgresssBarHeight(this.mUploadTable);
        this.mShareFilesSorter.addMouseListenerToHeaderInTable(this.mShareFilesTable);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JButton jButton3 = new JButton("Rescan");
        jPanel5.add(jButton3);
        jButton3.addActionListener(new ShareRescanHandler());
        this.sharedFilesLabel = new JLabel(String.valueOf(String.valueOf(Localizer.getString("SharedFiles"))).concat(":"));
        this.fileAdmin.addSharedFilesChangeListener(new SharedFilesChangeHandler());
        jPanel4.add("North", this.sharedFilesLabel);
        jPanel4.add("Center", new JScrollPane(this.mShareFilesTable));
        jPanel4.add("South", jPanel5);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        jPanel3.setPreferredSize(new Dimension(780, 230));
        jPanel4.setPreferredSize(new Dimension(780, 200));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel3);
        jSplitPane.setBottomComponent(jPanel4);
        this.add("Center", jSplitPane);
    }

    public void updateUI() {
        super.updateUI();
        if (this.mUploadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.mUploadTable);
        }
    }

    public void abortUpload() {
        int n = this.mUploadTable.getSelectedRow();
        if (n < 0 || n >= this.uploadContainer.getUploadListSize()) {
            return;
        }
        UploadFile uploadFile = this.uploadContainer.getUploadFileAt(n = this.mUploadSorter.indexes[n]);
        if (uploadFile == null) {
            return;
        }
        uploadFile.abortUpload();
        this.mainFrame.refreshAllActions();
    }

    public boolean isUploadSelected() {
        return this.mainFrame.isUploadTabSelected() && this.mUploadTable.getSelectedRowCount() > 0 && this.uploadContainer.getUploadListSize() > 0;
    }

    public void clearUpload() {
        this.uploadContainer.cleanUploadFileList();
        this.mainFrame.refreshAllActions();
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ShareTab.this.mainFrame.refreshAllActions();
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(Color.black);
            if (jTable == ShareTab.this.mUploadTable && n < ShareTab.this.uploadContainer.getUploadListSize()) {
                n = ((ShareTab)ShareTab.this).mUploadSorter.indexes[n];
                switch (ShareTab.this.uploadContainer.getUploadFileAt(n).getStatus()) {
                    case 5: 
                    case 6: {
                        this.setForeground(Color.darkGray);
                        break;
                    }
                    case 3: {
                        this.setForeground(Color.red);
                        break;
                    }
                    case 4: {
                        this.setForeground(Color.blue);
                    }
                }
            }
            return this;
        }
    }

    private class SharedFilesChangeHandler
    implements SharedFilesChangeListener {
        private SharedFilesChangeHandler() {
        }

        public void sharedFileChanged(int n) {
        }

        public void sharedFileAdded(int n) {
            this.updateLabel();
        }

        public void allSharedFilesChanged() {
            this.updateLabel();
        }

        private void updateLabel() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Localizer.getString("SharedFiles"));
            stringBuffer.append(": ( ");
            stringBuffer.append(ShareTab.this.fileAdmin.getFileCount());
            stringBuffer.append(" / ");
            stringBuffer.append(StrUtil.formatSizeBytes((long)ShareTab.this.fileAdmin.getTotalFileSizeInKb() * 1024L)).append(")");
            ShareTab.this.sharedFilesLabel.setText(stringBuffer.toString());
        }
    }

    private class ShareRescanHandler
    implements ActionListener {
        private ShareRescanHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.mShareMgr.getFileAdministration().rescan();
        }
    }

    private class ClearUploadHandler
    implements ActionListener {
        private ClearUploadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.clearUpload();
        }
    }

    private class AbortUploadHandler
    implements ActionListener {
        private AbortUploadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.abortUpload();
        }
    }
}

