/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import phex.Listener;
import phex.ServiceManager;
import phex.event.CaughtHostsChangeListener;
import phex.host.HostAddress;
import phex.utils.IPUtils;

public class CaughtHostsContainer {
    private static final String[] DEFAULT_STARTUP_HOSTS = new String[]{"connect1.gnutellanet.com:6346", "connect2.gnutellanet.com:6346", "connect3.gnutellanet.com:6346", "gnutella-again.hostscache.com:6346", "gnutella.hostscache.com:6346", "gnotella.fileflash.com:6346", "public.bearshare.net:6346"};
    public static final short HIGH_PRIORITY = 0;
    public static final short LOW_PRIORITY = 1;
    private Listener listener;
    private ArrayList caughtHosts;
    private ArrayList autoConnectHosts;
    private HashMap uniqueCaughtHosts;
    private boolean hasChangedSinceLastSave;
    private ArrayList listenerList = new ArrayList(2);

    public CaughtHostsContainer() {
        this.listener = ServiceManager.getListener();
        this.caughtHosts = new ArrayList();
        this.autoConnectHosts = new ArrayList();
        this.uniqueCaughtHosts = new HashMap();
    }

    public void initializeCaughtHostsContainer() {
        this.removeAllCaughtHosts();
        this.removeAllAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
        this.loadAutoConnectHostsFromFile();
    }

    public synchronized String getNextCaughtHost() {
        String string = this.getCaughtHostAt(0);
        if (string == null) {
            this.addAutoConnectHosts();
            string = this.getCaughtHostAt(0);
        }
        this.removeCaughtHost(string);
        return string;
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.size();
    }

    public synchronized int getAutoConnectHostsCount() {
        return this.autoConnectHosts.size();
    }

    public synchronized String getCaughtHostAt(int n) {
        if (n >= this.caughtHosts.size()) {
            return null;
        }
        return (String)this.caughtHosts.get(n);
    }

    public synchronized String getAutoConnectHostAt(int n) {
        if (n >= this.autoConnectHosts.size()) {
            return null;
        }
        return (String)this.autoConnectHosts.get(n);
    }

    public synchronized String[] getCaughtHostsAt(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.caughtHosts.get(nArray[i]);
        }
        return stringArray;
    }

    public synchronized void resetCaughtHosts() {
        this.removeAllCaughtHosts();
        this.addAutoConnectHosts();
    }

    public synchronized void removeAllCaughtHosts() {
        for (int i = this.caughtHosts.size() - 1; i >= 0; --i) {
            this.removeCaughtHost((String)this.caughtHosts.get(i));
        }
    }

    public synchronized void removeAllAutoConnectHosts() {
        for (int i = this.autoConnectHosts.size() - 1; i >= 0; --i) {
            this.removeAutoConnectHost((String)this.autoConnectHosts.get(i));
        }
    }

    public synchronized void addCaughtHost(HostAddress hostAddress, short s) {
        if (hostAddress.isLocalHost()) {
            return;
        }
        try {
            if (IPUtils.isInvalidIP(hostAddress.getHostIP())) {
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        this.insertCaughtHost(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(hostAddress.getHostName()))).append(":").append(hostAddress.getPort()))), s);
    }

    public synchronized void addAutoConnectHost(String string) {
        this.insertAutoConnectHost(string, this.autoConnectHosts.size());
    }

    private synchronized void insertCaughtHost(String string, short s) {
        if (this.caughtHosts.size() > ServiceManager.sCfg.mNetMaxHostToCatch) {
            if (s == 0) {
                this.removeCaughtHost(this.getCaughtHostAt(this.caughtHosts.size() - 1));
            } else {
                this.removeCaughtHost(this.getCaughtHostAt(0));
            }
        }
        int n = s == 0 ? 0 : this.caughtHosts.size();
        if (this.uniqueCaughtHosts.get(string) == null) {
            this.caughtHosts.add(n, string);
            this.uniqueCaughtHosts.put(string, string);
            this.hasChangedSinceLastSave = true;
            this.fireCaughtHostAdded(n);
        }
    }

    private synchronized void insertAutoConnectHost(String string, int n) {
        if (!this.autoConnectHosts.contains(string)) {
            this.autoConnectHosts.add(n, string);
            this.hasChangedSinceLastSave = true;
            this.fireAutoConnectHostAdded(n);
        }
    }

    public synchronized void removeCaughtHost(String string) {
        int n = this.caughtHosts.indexOf(string);
        if (n >= 0) {
            this.caughtHosts.remove(n);
            this.uniqueCaughtHosts.remove(string);
            this.fireCaughtHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized void removeAutoConnectHost(String string) {
        int n = this.autoConnectHosts.indexOf(string);
        if (n >= 0) {
            this.autoConnectHosts.remove(n);
            this.fireAutoConnectHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.saveAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
    }

    private synchronized void addAutoConnectHosts() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            int n = this.autoConnectHosts.size();
            for (int i = n - 1; i >= 0; --i) {
                this.insertCaughtHost((String)this.autoConnectHosts.get(i), (short)0);
            }
            if (n == 0) {
                this.addDefaultAutoConnectHosts();
            }
        }
    }

    private synchronized void addDefaultAutoConnectHosts() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            for (int i = DEFAULT_STARTUP_HOSTS.length - 1; i >= 0; --i) {
                this.insertCaughtHost(DEFAULT_STARTUP_HOSTS[i], (short)0);
            }
        }
    }

    private void copyDefaultAutoConnectHosts() {
        for (int i = 0; i < DEFAULT_STARTUP_HOSTS.length; ++i) {
            this.addAutoConnectHost(DEFAULT_STARTUP_HOSTS[i]);
        }
    }

    private void loadHostsFromFile() {
        try {
            String string;
            File file = new File(ServiceManager.getHostsFilename());
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.insertCaughtHost(string, (short)1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadAutoConnectHostsFromFile() {
        try {
            String string;
            File file = new File(ServiceManager.getAutoConnectHostsFilename());
            if (!file.exists()) {
                this.copyDefaultAutoConnectHosts();
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.insertAutoConnectHost(string, this.autoConnectHosts.size());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void saveCaughtHosts() {
        try {
            File file = new File(ServiceManager.getHostsFilename());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.caughtHosts.size(); ++i) {
                String string = (String)this.caughtHosts.get(i);
                if (this.isInStartupHosts(string)) continue;
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private synchronized void saveAutoConnectHosts() {
        try {
            File file = new File(ServiceManager.getAutoConnectHostsFilename());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.autoConnectHosts.size(); ++i) {
                String string = (String)this.autoConnectHosts.get(i);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean isInStartupHosts(String string) {
        int n;
        for (n = 0; n < DEFAULT_STARTUP_HOSTS.length; ++n) {
            if (!string.equals(DEFAULT_STARTUP_HOSTS[n])) continue;
            return true;
        }
        n = this.autoConnectHosts.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.autoConnectHosts.get(i))) continue;
            return true;
        }
        return false;
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.add(caughtHostsChangeListener);
    }

    public void removeCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        ((AbstractCollection)this.listenerList).remove(caughtHostsChangeListener);
    }

    private void fireCaughtHostAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.caughtHostAdded(n);
                }
            }
        });
    }

    private void fireAutoConnectHostAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.autoConnectHostAdded(n);
                }
            }
        });
    }

    private void fireCaughtHostRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.caughtHostRemoved(n);
                }
            }
        });
    }

    private void fireAutoConnectHostRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.autoConnectHostRemoved(n);
                }
            }
        });
    }
}

