/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import phex.ServiceManager;
import phex.event.CaughtHostsChangeListener;
import phex.event.NetworkHostsChangeListener;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.NetworkHostsContainer;
import phex.utils.ThrottleController;

public final class HostManager {
    private CaughtHostsContainer caughtHostsContainer = new CaughtHostsContainer();
    private NetworkHostsContainer networkHostsContainer = new NetworkHostsContainer();
    private ThrottleController mBandwidthThrottle = ThrottleController.acquireThrottle();

    public void dispose() {
        this.mBandwidthThrottle.dispose();
    }

    public CaughtHostsContainer getCaughtHostsContainer() {
        return this.caughtHostsContainer;
    }

    public void initializeCaughtHosts() {
        this.caughtHostsContainer.initializeCaughtHostsContainer();
    }

    public void addCaughtHost(HostAddress hostAddress, short s) {
        this.caughtHostsContainer.addCaughtHost(hostAddress, s);
    }

    public int getCaughtHostCount() {
        return this.caughtHostsContainer.getCaughtHostsCount();
    }

    public String getCaughtHostAt(int n) {
        return this.caughtHostsContainer.getCaughtHostAt(n);
    }

    public String[] getCaughtHostsAt(int[] nArray) {
        return this.caughtHostsContainer.getCaughtHostsAt(nArray);
    }

    public void removeCaughtHost(String string) {
        this.caughtHostsContainer.removeCaughtHost(string);
    }

    public void resetCaughtHosts() {
        this.caughtHostsContainer.resetCaughtHosts();
    }

    public void saveHostsContainer() {
        try {
            this.caughtHostsContainer.saveHostsContainer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.caughtHostsContainer.addCaughtHostsChangeListener(caughtHostsChangeListener);
    }

    public void createOutgoingConnectionToHost(String string) {
        this.networkHostsContainer.createOutgoingConnectionToHost(string);
    }

    public void addConnectedHost(Host host) {
        this.networkHostsContainer.addConnectedHost(host);
    }

    public void cleanupConnectedHosts() {
        this.networkHostsContainer.cleanupConnectedHosts();
    }

    public void addIncomingHost(Host host) {
        this.networkHostsContainer.addIncomingHost(host);
    }

    public int getConnectedHostCount() {
        return this.networkHostsContainer.getConnectedHostCount();
    }

    public boolean hasIncommingSlotsAvailable() {
        return this.networkHostsContainer.hasIncommingSlotsAvailable();
    }

    public Host getConnectedHostAt(int n) {
        return this.networkHostsContainer.getConnectedHostAt(n);
    }

    public void periodicallyCheckHosts() {
        this.networkHostsContainer.periodicallyCheckHosts();
    }

    public int getNetworkHostCount() {
        return this.networkHostsContainer.getNetworkHostCount();
    }

    public void cleanupNetworkHosts() {
        this.networkHostsContainer.cleanupNetworkHosts();
    }

    public Host getNetworkHostAt(int n) {
        return this.networkHostsContainer.getNetworkHostAt(n);
    }

    public void removeAllNetworkHosts() {
        this.networkHostsContainer.removeAllNetworkHosts();
    }

    public void removeNetworkHosts(Host[] hostArray) {
        this.networkHostsContainer.removeNetworkHosts(hostArray);
    }

    public void removeNetworkHost(Host host) {
        this.networkHostsContainer.removeNetworkHost(host);
    }

    public void addNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.networkHostsContainer.addNetworkHostsChangeListener(networkHostsChangeListener);
    }

    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.networkHostsContainer.removeNetworkHostsChangeListener(networkHostsChangeListener);
    }

    public void fireNetworkHostChanged(Host host) {
        this.networkHostsContainer.fireNetworkHostChanged(host);
    }

    public void autoConnectToNextCaughtHost() {
        if (!ServiceManager.sCfg.mAutoConnect) {
            return;
        }
        String string = this.caughtHostsContainer.getNextCaughtHost();
        if (string != null) {
            this.networkHostsContainer.createOutgoingConnectionToHost(string);
        }
    }

    public void throttleControl(long l) {
        this.mBandwidthThrottle.setRate(ServiceManager.sCfg.mNetMaxRate);
        this.mBandwidthThrottle.controlThrottle(l);
    }
}

