/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.GUID;
import phex.ServiceManager;
import phex.host.Host;
import phex.utils.IOUtil;

public class MsgHeader {
    public static final int sDataLength = 23;
    public static final int sInit = 0;
    public static final int sInitResponse = 1;
    public static final int sPushRequest = 64;
    public static final int sQuery = 128;
    public static final int sQueryResponse = 129;
    public static final int sCChat = 142;
    public static final int sUnknown = 255;
    private GUID mMsgID;
    private int mFunction;
    private int mTTL;
    private int mHopsTaken;
    private int mDataLen;
    private long mArrivalTime;
    private Host mFromHost = null;

    public MsgHeader() {
        this.mMsgID = new GUID();
        this.mFunction = 255;
        this.mTTL = ServiceManager.sCfg.mNetTTL;
        this.mHopsTaken = 0;
        this.mDataLen = 0;
    }

    public MsgHeader(GUID gUID) {
        this.mMsgID = gUID;
        this.mFunction = 255;
        this.mTTL = 0;
        this.mHopsTaken = 0;
        this.mDataLen = 0;
    }

    public GUID getMsgID() {
        return this.mMsgID;
    }

    public void setMsgID(GUID gUID) {
        this.mMsgID = gUID;
    }

    public int getFunction() {
        return this.mFunction;
    }

    public void setFunction(int n) {
        this.mFunction = n;
    }

    public String getFunctionName() {
        switch (this.mFunction) {
            case 0: {
                return "Init";
            }
            case 1: {
                return "InitResponse";
            }
            case 142: {
                return "Channel Chat";
            }
            case 64: {
                return "PushRequest";
            }
            case 128: {
                return "Query";
            }
            case 129: {
                return "QueryResponse";
            }
        }
        return "Unknown";
    }

    public int getTTL() {
        return this.mTTL;
    }

    public void setTTL(int n) {
        this.mTTL = n;
    }

    public int getHopsTaken() {
        return this.mHopsTaken;
    }

    public void setHopsTaken(int n) {
        this.mHopsTaken = n;
    }

    public int getDataLen() {
        return this.mDataLen;
    }

    public void setDataLen(int n) {
        this.mDataLen = n;
    }

    public long getArrivalTime() {
        return this.mArrivalTime;
    }

    public void setArrivalTime(long l) {
        this.mArrivalTime = l;
    }

    public Host getFromHost() {
        return this.mFromHost;
    }

    public void setFromHost(Host host) {
        this.mFromHost = host;
    }

    public int getSize() {
        return 23;
    }

    public void copy(MsgHeader msgHeader) {
        this.mMsgID = msgHeader.mMsgID;
        this.mFunction = msgHeader.mFunction;
        this.mTTL = msgHeader.mTTL;
        this.mHopsTaken = msgHeader.mHopsTaken;
        this.mDataLen = msgHeader.mDataLen;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mMsgID.serialize(byArray, n);
        byArray[n++] = (byte)this.mFunction;
        byArray[n++] = (byte)this.mTTL;
        byArray[n++] = (byte)this.mHopsTaken;
        n = IOUtil.serializeIntLE(this.mDataLen, byArray, n);
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        n = this.mMsgID.deserialize(byArray, n);
        this.mFunction = byArray[n++];
        this.mFunction = this.mFunction < 0 ? this.mFunction + 256 : this.mFunction;
        this.mTTL = byArray[n++];
        this.mTTL = this.mTTL < 0 ? this.mTTL + 256 : this.mTTL;
        this.mHopsTaken = byArray[n++];
        this.mHopsTaken = this.mHopsTaken < 0 ? this.mHopsTaken + 256 : this.mHopsTaken;
        this.mDataLen = IOUtil.deserializeIntLE(byArray, n);
        return n += 4;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("[MsgID=").append(this.mMsgID).append(", ").append("Function=").append(this.mFunction).append("(").append(this.getFunctionName()).append("), ").append("TTL=").append(this.mTTL).append(", ").append("HopsTaken=").append(this.mHopsTaken).append(", ").append("DataLen=").append(this.mDataLen).append("]")));
    }
}

