/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import phex.GUID;
import phex.SendManager;
import phex.ServiceManager;
import phex.cqueue.CQueue;
import phex.cqueue.CQueueElement;
import phex.download.RemoteFile;
import phex.host.Host;
import phex.host.HostManager;
import phex.interfaces.IMonitorSearch;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.msg.MsgInit;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryManager;
import phex.utils.IPUtils;

public final class MsgManager {
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private SendManager sendMgr = ServiceManager.getSendManager();
    private QueryManager queryMgr = ServiceManager.getQueryManager();
    private Hashtable mMsgSeen;
    private Hashtable mRoutingTable;
    private Hashtable mPushRoutingTable;
    private CQueue mMsgLRU;
    private CQueue mRoutingLRU;
    private CQueue mPushRoutingLRU;
    private MsgInit mMyMsgInit;
    private Vector mPassiveResults = new Vector();
    private String mPassiveSearching = null;
    private Vector mPassiveSearchingList = new Vector();
    private IMonitorSearch mMonitorSearchListener;

    public MsgManager() {
        this.mMsgSeen = new Hashtable();
        this.mRoutingTable = new Hashtable();
        this.mPushRoutingTable = new Hashtable();
        this.mMsgLRU = new CQueue(10000, false);
        this.mRoutingLRU = new CQueue(10000, false);
        this.mPushRoutingLRU = new CQueue(1000, false);
        this.mMyMsgInit = new MsgInit();
        this.mMyMsgInit.getHeader().setTTL(ServiceManager.sCfg.mNetTTL);
        this.checkAndAddMsgSeen(this.mMyMsgInit);
    }

    public void setMonitorSearchListener(IMonitorSearch iMonitorSearch) {
        this.mMonitorSearchListener = iMonitorSearch;
    }

    public synchronized boolean checkAndAddMsgSeen(IMsg iMsg) {
        GUID gUID = iMsg.getHeader().getMsgID();
        if (this.mMsgSeen.get(gUID.getHashCode()) != null) {
            return true;
        }
        this.mMsgSeen.put(gUID.getHashCode(), iMsg.getHeader());
        try {
            this.mMsgLRU.addToHead(new CQueueElement(gUID));
            if (this.mMsgLRU.isExceedingMax()) {
                CQueueElement cQueueElement = (CQueueElement)this.mMsgLRU.removeFromTail();
                GUID gUID2 = (GUID)cQueueElement.getObj();
                this.mMsgSeen.remove(gUID2.getHashCode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public synchronized void addToRoutingTable(GUID gUID, Host host) {
        try {
            this.mRoutingTable.put(gUID.getHashCode(), host);
            this.mRoutingLRU.addToHead(new CQueueElement(gUID));
            if (this.mRoutingLRU.isExceedingMax()) {
                CQueueElement cQueueElement = (CQueueElement)this.mRoutingLRU.removeFromTail();
                GUID gUID2 = (GUID)cQueueElement.getObj();
                this.mRoutingTable.remove(gUID2.getHashCode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addToPushRoutingTable(GUID gUID, Host host) {
        try {
            this.mPushRoutingTable.put(gUID.getHashCode(), host);
            this.mPushRoutingLRU.addToHead(new CQueueElement(gUID));
            if (this.mPushRoutingLRU.isExceedingMax()) {
                CQueueElement cQueueElement = (CQueueElement)this.mPushRoutingLRU.removeFromTail();
                GUID gUID2 = (GUID)cQueueElement.getObj();
                this.mPushRoutingTable.remove(gUID2.getHashCode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized Host getRouting(GUID gUID) {
        return (Host)this.mRoutingTable.get(gUID.getHashCode());
    }

    public synchronized Host getPushRouting(GUID gUID) {
        return (Host)this.mPushRoutingTable.get(gUID.getHashCode());
    }

    public MsgInit getMyMsgInit() {
        return this.mMyMsgInit;
    }

    public void resetMyMsgInit() {
        this.mMyMsgInit = new MsgInit();
    }

    public synchronized void processQueryResponse(Host host, MsgQueryResponse msgQueryResponse) {
        this.queryMgr.getSearchContainer().processQueryResponse(host, msgQueryResponse);
        this.queryMgr.getBackgroundSearchContainer().processQueryResponse(host, msgQueryResponse);
        if (!IPUtils.isHostInUserFilter(msgQueryResponse.getRemoteHost().getHostAddress())) {
            this.passiveMonitorResult(msgQueryResponse);
        }
    }

    public String getPassiveSearching() {
        return this.mPassiveSearching;
    }

    public void setPassiveSearching(String string) {
        this.mPassiveSearching = string;
        this.mPassiveSearchingList.removeAllElements();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreElements()) {
                this.mPassiveSearchingList.addElement(stringTokenizer.nextElement());
            }
        }
    }

    public Vector getPassiveResults() {
        return this.mPassiveResults;
    }

    public void passiveMonitorResult(MsgQueryResponse msgQueryResponse) {
        if (this.mPassiveSearching == null) {
            return;
        }
        if (this.mPassiveResults.size() >= ServiceManager.sCfg.mSearchMaxSearch) {
            return;
        }
        String string = msgQueryResponse.getRemoteHostStr();
        int n = msgQueryResponse.getRemoteHostSpeed();
        block0: for (int i = 0; i < msgQueryResponse.getRecordCount(); ++i) {
            RemoteFile remoteFile;
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(i);
            if (this.mPassiveSearching.length() == 0 && !this.passiveResultExists(remoteFile = new RemoteFile(msgQueryResponse.getRemoteClientID(), msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), string, n))) {
                this.mPassiveResults.addElement(remoteFile);
                this.mMonitorSearchListener.passiveResultArrived();
                continue;
            }
            for (int j = 0; j < this.mPassiveSearchingList.size(); ++j) {
                String string2 = (String)this.mPassiveSearchingList.elementAt(j);
                if (msgResRecord.getFilename().indexOf(string2) == -1) continue;
                RemoteFile remoteFile2 = new RemoteFile(msgQueryResponse.getRemoteClientID(), msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), string, n);
                if (this.passiveResultExists(remoteFile2)) continue block0;
                this.mPassiveResults.addElement(remoteFile2);
                this.mMonitorSearchListener.passiveResultArrived();
                continue block0;
            }
        }
    }

    private boolean passiveResultExists(RemoteFile remoteFile) {
        for (int i = 0; i < this.mPassiveResults.size(); ++i) {
            RemoteFile remoteFile2 = (RemoteFile)this.mPassiveResults.elementAt(i);
            if (!remoteFile2.equals(remoteFile)) continue;
            return true;
        }
        return false;
    }

    public void resetPassiveResults() {
        this.mPassiveResults.removeAllElements();
        this.mMonitorSearchListener.passiveResultArrived();
    }

    public void forwardMsg(IMsg iMsg, Host host) {
        if (this.decTTL(iMsg)) {
            return;
        }
        int n = this.mHostMgr.getConnectedHostCount();
        for (int i = 0; i < n; ++i) {
            Host host2 = this.mHostMgr.getConnectedHostAt(i);
            if (host2 == host) continue;
            this.sendMsgToHost(iMsg, host2);
        }
    }

    public void sendMsgToHosts(IMsg iMsg) {
        int n = this.mHostMgr.getConnectedHostCount();
        for (int i = 0; i < n; ++i) {
            Host host = this.mHostMgr.getConnectedHostAt(i);
            this.sendMsgToHost(iMsg, host);
        }
    }

    public void pingNeighbors() {
        int n = this.mHostMgr.getConnectedHostCount();
        for (int i = 0; i < n; ++i) {
            Host host = this.mHostMgr.getConnectedHostAt(i);
            if (host == null) continue;
            host.pingHost();
        }
    }

    public void sendMsgToHost(IMsg iMsg, Host host) {
        if (host == null) {
            return;
        }
        if (host.sendQueueInRed() || host.latencyInRed()) {
            return;
        }
        this.sendMgr.queueMsgToSend(host, iMsg, false);
    }

    public boolean decTTL(IMsg iMsg) {
        MsgHeader msgHeader = iMsg.getHeader();
        int n = msgHeader.getTTL() - 1;
        if (n <= 0) {
            return true;
        }
        if (n > ServiceManager.sCfg.mNetMaxTTL) {
            n = ServiceManager.sCfg.mNetMaxTTL;
        }
        msgHeader.setTTL(n);
        msgHeader.setHopsTaken(msgHeader.getHopsTaken() + 1);
        return false;
    }
}

