/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.net.InetAddress;
import phex.GUID;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;

public class MsgPushRequest
implements IMsg {
    private MsgHeader mHeader;
    private GUID mClientID;
    private int mFileIndex;
    private String requestHost;
    private short requestPort;

    private MsgPushRequest() {
    }

    public MsgPushRequest(MsgHeader msgHeader) {
        this.setHeader(msgHeader);
        this.mClientID = new GUID();
        this.mFileIndex = -1;
        this.requestHost = null;
        this.requestPort = 0;
    }

    public void setHeader(MsgHeader msgHeader) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(64);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public GUID getClientID() {
        return this.mClientID;
    }

    public void setClientID(GUID gUID) {
        this.mClientID = gUID;
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public void setFileIndex(int n) {
        this.mFileIndex = n;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestHost(String string) {
        this.requestHost = string;
    }

    public short getRequestPort() {
        return this.requestPort;
    }

    public void setRequestPort(short s) {
        this.requestPort = s;
    }

    public void computeHeaderLen() {
        this.mHeader.setDataLen(this.getSize() - this.mHeader.getSize());
    }

    public int getSize() {
        return this.mHeader.getSize() + this.mClientID.getSize() + 4 + 4 + 2;
    }

    public void copy(MsgPushRequest msgPushRequest) {
        this.mHeader.copy(msgPushRequest.getHeader());
        this.mClientID = msgPushRequest.mClientID;
        this.mFileIndex = msgPushRequest.mFileIndex;
        this.requestHost = msgPushRequest.requestHost;
        this.requestPort = msgPushRequest.requestPort;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        n = this.mClientID.serialize(byArray, n);
        n = IOUtil.serializeIntLE(this.mFileIndex, byArray, n);
        InetAddress inetAddress = InetAddress.getByName(this.requestHost);
        System.arraycopy(inetAddress.getAddress(), 0, byArray, n, 4);
        n += 4;
        n = IOUtil.serializeShortLE(this.requestPort, byArray, n);
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        n = this.mClientID.deserialize(byArray, n);
        this.mFileIndex = IOUtil.deserializeIntLE(byArray, n);
        n += 4;
        StringBuffer stringBuffer = new StringBuffer();
        n = IOUtil.deserializeIP(byArray, n, stringBuffer);
        this.requestHost = stringBuffer.toString();
        this.requestPort = IOUtil.deserializeShortLE(byArray, n);
        return n += 2;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("[").append(this.mHeader).append(" ").append("ClientID=").append(this.mClientID).append(", ").append("FileIndex=").append(this.mFileIndex).append(", ").append("RequestHost=").append(this.requestHost).append(", ").append("RequestPort=").append(this.requestPort).append("]")));
    }
}

