/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;

public class MsgQuery
implements IMsg {
    private MsgHeader mHeader;
    private Short minSpeed;
    private String mSearchString;

    public MsgQuery() {
        this(new MsgHeader());
    }

    public MsgQuery(MsgHeader msgHeader) {
        this.setHeader(msgHeader);
        this.minSpeed = new Short(0);
        this.mSearchString = "";
    }

    public void setHeader(MsgHeader msgHeader) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(128);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public void setMinSpeed(short s) {
        this.minSpeed = new Short(s);
    }

    public short getMinSpeed() {
        return this.minSpeed;
    }

    public Short getMinSpeedObject() {
        return this.minSpeed;
    }

    public void setSearchString(String string) {
        this.mSearchString = string;
    }

    public String getSearchString() {
        return this.mSearchString;
    }

    public void computeHeaderLen() {
        this.mHeader.setDataLen(this.getSize() - this.mHeader.getSize());
    }

    public int getSize() {
        return this.mHeader.getSize() + 2 + this.mSearchString.length() + 1;
    }

    public void copy(MsgQuery msgQuery) {
        this.mHeader.copy(msgQuery.getHeader());
        this.minSpeed = msgQuery.minSpeed;
        this.mSearchString = msgQuery.mSearchString;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        n = IOUtil.serializeShortLE(this.minSpeed, byArray, n);
        n = IOUtil.serializeString(this.mSearchString, byArray, n);
        byArray[n++] = 0;
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        this.minSpeed = new Short(IOUtil.deserializeShortLE(byArray, n));
        n += 2;
        StringBuffer stringBuffer = new StringBuffer();
        if ((n = IOUtil.deserializeString(byArray, n, stringBuffer)) < byArray.length && byArray[n] == 0) {
            ++n;
        }
        this.mSearchString = stringBuffer.toString();
        return n;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("[").append(this.mHeader).append(" ").append("MinSpeed=").append(this.minSpeed.shortValue()).append(", ").append("SearchString=").append(this.mSearchString).append("]")));
    }
}

