/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.ServiceManager;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.host.HostManager;
import phex.query.ResearchServiceConfig;
import phex.query.ResearchSetting;

public class ResearchService {
    private ResearchServiceConfig researchConfig;

    public ResearchService(ResearchServiceConfig researchServiceConfig) {
        this.researchConfig = researchServiceConfig;
    }

    public void startResearchSequence() {
        if (this.researchConfig.isResearchEnabled()) {
            return;
        }
        DownloadManager downloadManager = ServiceManager.getDownloadManager();
        for (int i = downloadManager.getDownloadCount(); i >= 0; --i) {
            DownloadFile downloadFile = downloadManager.getDownloadFileAt(i);
            if (downloadFile == null) continue;
            this.performResearchOnDownload(downloadFile);
        }
    }

    private void performResearchOnDownload(DownloadFile downloadFile) {
        if (downloadFile.isDownloadInProgress() || downloadFile.isDownloadCompleted() || downloadFile.isDownloadStopped()) {
            return;
        }
        this.performResearchOnSetting(downloadFile.getResearchSetting(), downloadFile);
    }

    private void performResearchOnSetting(ResearchSetting researchSetting, DownloadFile downloadFile) {
        HostManager hostManager = ServiceManager.getHostManager();
        if (hostManager.getConnectedHostCount() == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.isSearchRunning(researchSetting, l)) {
            return;
        }
        if (!this.isTimeForResearch(downloadFile, researchSetting, l)) {
            return;
        }
        researchSetting.startSearch(this.researchConfig.getResearchTimeout());
    }

    private boolean isTimeForResearch(DownloadFile downloadFile, ResearchSetting researchSetting, long l) {
        long l2 = researchSetting.getLastResearchStartTime();
        int n = researchSetting.getNoNewResultsCount();
        long l3 = this.researchConfig.getResearchIntervalMillis();
        int n2 = downloadFile.getRemoteCandidatesCount();
        int n3 = this.researchConfig.getCandidatesIntervalThreshold();
        int n4 = researchSetting.getTotalResearchCount();
        long l4 = this.researchConfig.getResearchTimePenalty();
        long l5 = l3 + l3 * (long)n + l4 * (long)Math.max(0, n2 - n3) + l4 * (long)n4;
        long l6 = l2 + (l5 = Math.min(l5, this.researchConfig.getMaxResearchIntervalMillis()));
        return l > l6;
    }

    private boolean isSearchRunning(ResearchSetting researchSetting, long l) {
        return researchSetting.isSearchRunning();
    }
}

