/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import javax.swing.SwingUtilities;
import phex.ServiceManager;
import phex.config.Cfg;
import phex.download.DownloadFile;
import phex.download.DownloadManager;
import phex.download.RemoteFile;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.query.BackgroundSearchContainer;
import phex.query.Search;

public class ResearchSetting {
    private long lastResearchStartTime;
    private int noNewResultsCount;
    private int totalResearchCount;
    private String searchTerm;
    private Search search;
    private boolean hasNewSearchResults;
    private DownloadFile downloadFile;
    private DownloadManager downloadMgr;
    private ResearchChangeListener researchChangeListener;

    public ResearchSetting(DownloadFile downloadFile) {
        this.downloadFile = downloadFile;
        this.downloadMgr = ServiceManager.getDownloadManager();
        this.researchChangeListener = new ResearchChangeListener();
    }

    public long getLastResearchStartTime() {
        return this.lastResearchStartTime;
    }

    public void setLastResearchStartTime(long l) {
        this.lastResearchStartTime = l;
    }

    public int getNoNewResultsCount() {
        return this.noNewResultsCount;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String string) {
        this.searchTerm = string;
    }

    public void startSearch(long l) {
        long l2;
        if (this.search != null && this.search.isSearching()) {
            return;
        }
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
            return;
        }
        this.hasNewSearchResults = false;
        BackgroundSearchContainer backgroundSearchContainer = ServiceManager.getQueryManager().getBackgroundSearchContainer();
        Search.FileSizeConstraints fileSizeConstraints = new Search.FileSizeConstraints(this.downloadFile.getTotalFileSize(), this.downloadFile.getTotalFileSize());
        this.search = backgroundSearchContainer.createSearch(this.searchTerm, 0, fileSizeConstraints, l);
        this.search.addSearchChangeListener(this.researchChangeListener);
        ++this.totalResearchCount;
        this.lastResearchStartTime = l2 = System.currentTimeMillis();
    }

    public int getTotalResearchCount() {
        return this.totalResearchCount;
    }

    public void stopSearch() {
        if (this.search == null || !this.search.isSearching()) {
            return;
        }
        this.search.stopSearching();
    }

    public int getSearchHitCount() {
        return this.search.getQueryHitCount();
    }

    public boolean isSearchRunning() {
        if (this.search == null) {
            return false;
        }
        return this.search.isSearching();
    }

    static /* synthetic */ DownloadManager access$4(ResearchSetting researchSetting) {
        return researchSetting.downloadMgr;
    }

    static /* synthetic */ DownloadFile access$5(ResearchSetting researchSetting) {
        return researchSetting.downloadFile;
    }

    static /* synthetic */ boolean access$6(ResearchSetting researchSetting, boolean bl) {
        researchSetting.hasNewSearchResults = bl;
        return researchSetting.hasNewSearchResults;
    }

    static /* synthetic */ boolean access$1(ResearchSetting researchSetting) {
        return researchSetting.hasNewSearchResults;
    }

    static /* synthetic */ int access$3(ResearchSetting researchSetting, int n) {
        researchSetting.noNewResultsCount = n;
        return researchSetting.noNewResultsCount;
    }

    static /* synthetic */ int access$2(ResearchSetting researchSetting) {
        return ++researchSetting.noNewResultsCount;
    }

    public class ResearchChangeListener
    implements SearchChangeListener {
        public void searchChanged(SearchChangeEvent searchChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(this, searchChangeEvent){
                private final /* synthetic */ SearchChangeEvent val$event;
                private final /* synthetic */ ResearchChangeListener this$1;
                {
                    this.this$1 = researchChangeListener;
                    this.val$event = searchChangeEvent;
                }

                public void run() {
                    if (this.val$event.getType() == 2) {
                        if (!ResearchSetting.access$1(ResearchChangeListener.access$0(this.this$1))) {
                            ResearchSetting.access$2(ResearchChangeListener.access$0(this.this$1));
                        } else {
                            ResearchSetting.access$3(ResearchChangeListener.access$0(this.this$1), 0);
                        }
                    }
                    if (this.val$event.getType() != 1) {
                        ResearchSetting.access$4(ResearchChangeListener.access$0(this.this$1)).fireDownloadFileChanged(ResearchSetting.access$5(ResearchChangeListener.access$0(this.this$1)));
                        return;
                    }
                    Search search = (Search)this.val$event.getSource();
                    int n = this.val$event.getStartIndex();
                    int n2 = this.val$event.getEndIndex();
                    for (int i = n; i < n2; ++i) {
                        RemoteFile remoteFile = search.getQueryHit(i);
                        boolean bl = ResearchSetting.access$5(ResearchChangeListener.access$0(this.this$1)).addRemoteCandidate(remoteFile);
                        if (!bl) continue;
                        ResearchSetting.access$6(ResearchChangeListener.access$0(this.this$1), true);
                    }
                    ResearchSetting.access$4(ResearchChangeListener.access$0(this.this$1)).fireDownloadFileChanged(ResearchSetting.access$5(ResearchChangeListener.access$0(this.this$1)));
                }
            });
        }

        static /* synthetic */ ResearchSetting access$0(ResearchChangeListener researchChangeListener) {
            return researchChangeListener.ResearchSetting.this;
        }
    }
}

