/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;
import phex.GUID;
import phex.ServiceManager;
import phex.download.RemoteFile;
import phex.event.NetworkHostsChangeListener;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.SearchContainer;
import phex.utils.IPUtils;
import phex.utils.SearchEngine;

public class Search {
    public static final long DEFAULT_SEARCH_TIMEOUT = 300000L;
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private MsgManager mMsgMgr = ServiceManager.getMsgManager();
    private SearchContainer searchContainer;
    private int mMinSpeed;
    private String mQueryStr;
    private FileSizeConstraints mFileSizeConstraints;
    private int mMaxResult;
    private MsgQuery mQuery;
    private ArrayList queryHitList;
    private boolean isSearching = false;
    private long mSearchStartTime;
    private long searchTimeout;
    private String fixedDisplayStr;
    private NewConnectedHostListener newHostListener;
    private ArrayList listenerList = new ArrayList(2);

    private Search() {
    }

    public Search(int n, String string, FileSizeConstraints fileSizeConstraints) {
        this(n, string, fileSizeConstraints, ServiceManager.sCfg.mSearchMaxSearch, 300000L);
    }

    public Search(int n, String string, FileSizeConstraints fileSizeConstraints, int n2, long l) {
        this.queryHitList = new ArrayList();
        this.searchContainer = ServiceManager.getQueryManager().getSearchContainer();
        this.mMinSpeed = n;
        this.mQueryStr = string;
        this.mFileSizeConstraints = fileSizeConstraints;
        this.mMaxResult = n2;
        this.searchTimeout = l;
        this.mQuery = new MsgQuery();
        this.mQuery.getHeader().setTTL(ServiceManager.sCfg.mNetTTL);
        this.mQuery.setMinSpeed((short)n);
        this.mQuery.setSearchString(string);
        this.fixedDisplayStr = String.valueOf(String.valueOf(new StringBuffer("[Search=").append(string).append("]    [Max Result=").append(this.mMaxResult).append("]    [Min Speed=").append(n).append("]    [Min Size=").append(fileSizeConstraints.getLowerBound()).append(" bytes]")));
        this.newHostListener = new NewConnectedHostListener();
    }

    public int getQueryHitCount() {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            int n = this.queryHitList.size();
            return n;
        }
    }

    public RemoteFile getQueryHit(int n) {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            RemoteFile remoteFile = (RemoteFile)this.queryHitList.get(n);
            return remoteFile;
        }
    }

    public Vector getQueryResults() {
        return new Vector(this.queryHitList);
    }

    public int getMinSpeed() {
        return this.mMinSpeed;
    }

    public String getQueryStr() {
        return this.mQueryStr;
    }

    public String getDisplayStr() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.fixedDisplayStr))).append("    [Results=").append(this.getQueryHitCount()).append(']')));
    }

    public MsgQuery getQuery() {
        return this.mQuery;
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public void startSearching() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Search.this.mMsgMgr.checkAndAddMsgSeen(Search.this.mQuery);
                Search.this.mHostMgr.addNetworkHostsChangeListener(Search.this.newHostListener);
                Search.this.mMsgMgr.sendMsgToHosts(Search.this.mQuery);
                Search.this.isSearching = true;
                Search.this.mSearchStartTime = System.currentTimeMillis();
                Search.this.fireSearchStarted();
            }
        });
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        this.mHostMgr.removeNetworkHostsChangeListener(this.newHostListener);
        this.fireSearchStoped();
    }

    public void processResponse(Host host, MsgQueryResponse msgQueryResponse) {
        int n;
        if (!msgQueryResponse.getHeader().getMsgID().equals(this.mQuery.getHeader().getMsgID())) {
            return;
        }
        if (IPUtils.isHostInUserFilter(msgQueryResponse.getRemoteHost().getHostAddress())) {
            return;
        }
        String string = msgQueryResponse.getRemoteHostStr();
        int n2 = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        int n3 = this.queryHitList.size();
        for (n = 0; n < msgQueryResponse.getRecordCount(); ++n) {
            String string2;
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n);
            long l = msgResRecord.getFileSize();
            if (l < this.mFileSizeConstraints.getLowerBound() || l > this.mFileSizeConstraints.getUpperBound() || this.isResultFiltered(string2 = msgResRecord.getFilename())) continue;
            ArrayList arrayList = this.queryHitList;
            synchronized (arrayList) {
                short s = Search.calculateSearchScore(this.mQueryStr, string2);
                RemoteFile remoteFile = new RemoteFile(gUID, msgResRecord.getFileIndex(), string2, l, string, n2, s);
                this.queryHitList.add(remoteFile);
                if (this.queryHitList.size() >= this.mMaxResult) {
                    this.stopSearching();
                    break;
                }
                continue;
            }
        }
        if ((n = this.queryHitList.size()) > n3) {
            this.fireSearchHitsAdded(n3, n);
        }
    }

    public void checkForSearchTimeout(long l) {
        if (l > this.mSearchStartTime + this.searchTimeout) {
            this.stopSearching();
        }
    }

    private static short calculateSearchScore(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            d += 1.0;
            searchEngine.setPattern(string3, false);
            if (!searchEngine.match()) continue;
            d2 += 1.0;
        }
        double d3 = d2 / d * (double)100;
        return (short)d3;
    }

    private boolean isResultFiltered(String string) {
        Vector vector = ServiceManager.sCfg.mSearchFilterTokens;
        string = string.toLowerCase();
        for (int i = 0; i < vector.size(); ++i) {
            if (string.indexOf(((String)vector.elementAt(i)).toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public void addSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.listenerList.add(searchChangeListener);
    }

    public void removeSearchChangeListener(SearchChangeListener searchChangeListener) {
        ((AbstractCollection)this.listenerList).remove(searchChangeListener);
    }

    private void fireSearchStarted() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchStoped() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchHitsAdded(int n, int n2) {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 1, n, n2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(final SearchChangeEvent searchChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = Search.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchChangeListener searchChangeListener = (SearchChangeListener)objectArray[i];
                    searchChangeListener.searchChanged(searchChangeEvent);
                }
            }
        });
    }

    private class NewConnectedHostListener
    implements NetworkHostsChangeListener {
        private NewConnectedHostListener() {
        }

        public void networkHostChanged(int n) {
            if (!Search.this.isSearching) {
                return;
            }
            Host host = Search.this.mHostMgr.getConnectedHostAt(n);
            if (host == null || !host.isConnectionStable()) {
                return;
            }
            Search.this.mMsgMgr.sendMsgToHost(Search.this.mQuery, host);
        }

        public void networkHostAdded(int n) {
        }

        public void networkHostRemoved(int n) {
        }
    }

    public static final class FileSizeConstraints {
        private final long lower;
        private final long upper;

        private FileSizeConstraints() {
            this.upper = 0L;
            this.lower = 0L;
        }

        public FileSizeConstraints(long l, long l2) {
            this.lower = l;
            this.upper = l2;
        }

        public long getUpperBound() {
            return this.upper;
        }

        public long getLowerBound() {
            return this.lower;
        }
    }
}

