/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import phex.ServiceManager;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.event.SearchListChangeListener;
import phex.host.Host;
import phex.msg.MsgQueryResponse;
import phex.query.Search;

public class SearchContainer {
    private ArrayList listenerList = new ArrayList(2);
    protected ArrayList searchList;
    private SearchChangeListener searchChangeListener = new SingleSearchChangeListener();

    public SearchContainer() {
        this.searchList = new ArrayList();
    }

    public synchronized Search createSearch(String string, int n, Search.FileSizeConstraints fileSizeConstraints) {
        Search search = new Search(n, string, fileSizeConstraints);
        this.insertToSearchList(search, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int n2 = this.searchList.size() - 1;
            this.removeFromSearchList(n2);
        }
        search.startSearching();
        return search;
    }

    protected synchronized void insertToSearchList(Search search, int n) {
        search.addSearchChangeListener(this.searchChangeListener);
        this.searchList.add(n, search);
        this.fireSearchAdded(n);
    }

    protected synchronized void removeFromSearchList(int n) {
        Search search = this.getSearchAt(n);
        search.stopSearching();
        search.removeSearchChangeListener(this.searchChangeListener);
        this.searchList.remove(n);
        this.fireSearchRemoved(n);
    }

    public synchronized int getSearchCount() {
        return this.searchList.size();
    }

    public synchronized Search getSearchAt(int n) {
        if (n > this.getSearchCount() - 1) {
            return null;
        }
        return (Search)this.searchList.get(n);
    }

    public synchronized void removeSearch(Search search) {
        int n = this.searchList.indexOf(search);
        if (n >= 0) {
            this.removeFromSearchList(n);
        }
    }

    public synchronized void removeSearch(int n) {
        this.removeFromSearchList(n);
    }

    public synchronized void stopExpiredSearches(long l) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).checkForSearchTimeout(l);
        }
    }

    public synchronized void stopAllSearches() {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).stopSearching();
        }
    }

    public synchronized void removeAllSearches() {
        for (int i = this.searchList.size() - 1; i >= 0; --i) {
            this.removeFromSearchList(i);
        }
    }

    public synchronized void processQueryResponse(Host host, MsgQueryResponse msgQueryResponse) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).processResponse(host, msgQueryResponse);
        }
    }

    public void addSearchListChangeListener(SearchListChangeListener searchListChangeListener) {
        this.listenerList.add(searchListChangeListener);
    }

    public void removeSearchListChangeListener(SearchListChangeListener searchListChangeListener) {
        ((AbstractCollection)this.listenerList).remove(searchListChangeListener);
    }

    protected void fireSearchChanged(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[i];
                    searchListChangeListener.searchChanged(n);
                }
            }
        });
    }

    protected void fireSearchAdded(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[i];
                    searchListChangeListener.searchAdded(n);
                }
            }
        });
    }

    protected void fireSearchRemoved(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[i];
                    searchListChangeListener.searchRemoved(n);
                }
            }
        });
    }

    protected void setSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.searchChangeListener = searchChangeListener;
    }

    protected void fireSearchChanged(Search search) {
        int n = this.searchList.indexOf(search);
        if (n >= 0) {
            this.fireSearchChanged(n);
        }
    }

    private class SingleSearchChangeListener
    implements SearchChangeListener {
        private SingleSearchChangeListener() {
        }

        public void searchChanged(SearchChangeEvent searchChangeEvent) {
            Search search = (Search)searchChangeEvent.getSource();
            SearchContainer.this.fireSearchChanged(search);
        }
    }
}

