/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import phex.interfaces.IFileIndexer;

public class IndexerTxt
implements IFileIndexer {
    private byte[] mBuf = new byte[1024];
    protected String mDelimiter = " ";
    protected String mFilterChars = ".!?:;,(){}[]/\\";
    protected Hashtable mFilterWords = new Hashtable();

    public IndexerTxt() {
        this.setupFileterWords();
    }

    protected void setupFileterWords() {
        this.mFilterWords.put("OF", "");
        this.mFilterWords.put("THE", "");
        this.mFilterWords.put("A", "");
        this.mFilterWords.put("AN", "");
        this.mFilterWords.put("OR", "");
        this.mFilterWords.put("AND", "");
        this.mFilterWords.put("AS", "");
        this.mFilterWords.put("IN", "");
        this.mFilterWords.put("ON", "");
        this.mFilterWords.put("INTO", "");
        this.mFilterWords.put("ONTO", "");
        this.mFilterWords.put("AT", "");
        this.mFilterWords.put("UNDER", "");
        this.mFilterWords.put("THIS", "");
        this.mFilterWords.put("THAT", "");
        this.mFilterWords.put("THESE", "");
        this.mFilterWords.put("THOSE", "");
        this.mFilterWords.put("IT", "");
        this.mFilterWords.put("I", "");
        this.mFilterWords.put("YOU", "");
        this.mFilterWords.put("HE", "");
        this.mFilterWords.put("SHE", "");
        this.mFilterWords.put("HIS", "");
        this.mFilterWords.put("HER", "");
        this.mFilterWords.put("HERS", "");
        this.mFilterWords.put("ME", "");
    }

    public Hashtable index(File file) throws Exception {
        String string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, this.mDelimiter);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().toUpperCase();
                if ((string2 = this.filter(string2)) == null) continue;
                hashtable.put(string2, "");
            }
        }
        return hashtable;
    }

    protected String filter(String string) {
        for (int i = 0; i < this.mFilterChars.length(); ++i) {
            if (string.length() < 1) {
                return null;
            }
            if (string.charAt(string.length() - 1) == this.mFilterChars.charAt(i)) {
                string = string.substring(0, string.length() - 1);
                i = -1;
                continue;
            }
            if (string.charAt(0) != this.mFilterChars.charAt(i)) continue;
            string = string.substring(1);
            i = -1;
        }
        if (this.mFilterWords.get(string) != null) {
            return null;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            IndexerTxt indexerTxt = new IndexerTxt();
            File file = new File(stringArray[0]);
            System.out.println(indexerTxt.index(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

